/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.style;

import android.text.SpannableStringBuilder;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.RelativeSizeSpan;
import android.util.Log;
import net.nightwhistler.htmlspanner.FontFamily;
import net.nightwhistler.htmlspanner.HtmlSpanner;
import net.nightwhistler.htmlspanner.SpanCallback;
import net.nightwhistler.htmlspanner.spans.AlignNormalSpan;
import net.nightwhistler.htmlspanner.spans.AlignOppositeSpan;
import net.nightwhistler.htmlspanner.spans.BorderSpan;
import net.nightwhistler.htmlspanner.spans.CenterSpan;
import net.nightwhistler.htmlspanner.spans.FontFamilySpan;
import net.nightwhistler.htmlspanner.style.Style;
import net.nightwhistler.htmlspanner.style.StyleValue;

public class StyleCallback
implements SpanCallback {
    private int start;
    private int end;
    private FontFamily defaultFont;
    private Style useStyle;

    public StyleCallback(FontFamily defaultFont, Style style, int start, int end) {
        this.defaultFont = defaultFont;
        this.useStyle = style;
        this.start = start;
        this.end = end;
    }

    @Override
    public void applySpan(HtmlSpanner spanner, SpannableStringBuilder builder) {
        StyleValue styleValue;
        if (this.useStyle.getFontFamily() != null || this.useStyle.getFontStyle() != null || this.useStyle.getFontWeight() != null) {
            FontFamilySpan originalSpan = this.getFontFamilySpan(builder, this.start, this.end);
            FontFamilySpan newSpan = this.useStyle.getFontFamily() == null && originalSpan == null ? new FontFamilySpan(this.defaultFont) : (this.useStyle.getFontFamily() != null ? new FontFamilySpan(this.useStyle.getFontFamily()) : new FontFamilySpan(originalSpan.getFontFamily()));
            if (this.useStyle.getFontWeight() != null) {
                newSpan.setBold(this.useStyle.getFontWeight() == Style.FontWeight.BOLD);
            } else if (originalSpan != null) {
                newSpan.setBold(originalSpan.isBold());
            }
            if (this.useStyle.getFontStyle() != null) {
                newSpan.setItalic(this.useStyle.getFontStyle() == Style.FontStyle.ITALIC);
            } else if (originalSpan != null) {
                newSpan.setItalic(originalSpan.isItalic());
            }
            builder.setSpan((Object)newSpan, this.start, this.end, 33);
        }
        if (spanner.isUseColoursFromStyle() && this.useStyle.getBackgroundColor() != null && this.useStyle.getBorderStyle() == null) {
            builder.setSpan((Object)new BackgroundColorSpan(this.useStyle.getBackgroundColor().intValue()), this.start, this.end, 33);
        }
        if (this.useStyle.getBorderStyle() != null) {
            builder.setSpan((Object)new BorderSpan(this.useStyle, this.start, this.end, spanner.isUseColoursFromStyle()), this.start, this.end, 33);
        }
        if (this.useStyle.getFontSize() != null) {
            styleValue = this.useStyle.getFontSize();
            if (styleValue.getUnit() == StyleValue.Unit.PX) {
                if (styleValue.getIntValue() > 0) {
                    builder.setSpan((Object)new AbsoluteSizeSpan(styleValue.getIntValue(), true), this.start, this.end, 33);
                }
            } else if (styleValue.getFloatValue() > 0.0f) {
                builder.setSpan((Object)new RelativeSizeSpan(styleValue.getFloatValue()), this.start, this.end, 33);
            }
        }
        if (spanner.isUseColoursFromStyle() && this.useStyle.getColor() != null) {
            builder.setSpan((Object)new ForegroundColorSpan(this.useStyle.getColor().intValue()), this.start, this.end, 33);
        }
        if (this.useStyle.getTextAlignment() != null) {
            Object alignSpan = null;
            switch (this.useStyle.getTextAlignment()) {
                case LEFT: {
                    alignSpan = new AlignNormalSpan();
                    break;
                }
                case CENTER: {
                    alignSpan = new CenterSpan();
                    break;
                }
                case RIGHT: {
                    alignSpan = new AlignOppositeSpan();
                }
            }
            builder.setSpan(alignSpan, this.start, this.end, 33);
        }
        if (this.useStyle.getTextIndent() != null) {
            int marginStart;
            styleValue = this.useStyle.getTextIndent();
            for (marginStart = this.start; marginStart < this.end && builder.charAt(marginStart) == '\n'; ++marginStart) {
            }
            int marginEnd = Math.min(this.end, marginStart + 1);
            Log.d((String)"StyleCallback", (String)("Applying LeadingMarginSpan from " + marginStart + " to " + marginEnd + " on text " + builder.subSequence(marginStart, marginEnd)));
            if (styleValue.getUnit() == StyleValue.Unit.PX) {
                if (styleValue.getIntValue() > 0) {
                    builder.setSpan((Object)new LeadingMarginSpan.Standard(styleValue.getIntValue(), 0), marginStart, marginEnd, 33);
                }
            } else if (styleValue.getFloatValue() > 0.0f) {
                builder.setSpan((Object)new LeadingMarginSpan.Standard((int)(10.0f * styleValue.getFloatValue()), 0), marginStart, marginEnd, 33);
            }
        }
        if (this.useStyle.getMarginLeft() != null) {
            styleValue = this.useStyle.getMarginLeft();
            if (styleValue.getUnit() == StyleValue.Unit.PX) {
                if (styleValue.getIntValue() > 0) {
                    builder.setSpan((Object)new LeadingMarginSpan.Standard(styleValue.getIntValue()), this.start, this.end, 33);
                }
            } else if (styleValue.getFloatValue() > 0.0f) {
                builder.setSpan((Object)new LeadingMarginSpan.Standard((int)(10.0f * styleValue.getFloatValue())), this.start, this.end, 33);
            }
        }
    }

    private FontFamilySpan getFontFamilySpan(SpannableStringBuilder builder, int start, int end) {
        FontFamilySpan[] spans = (FontFamilySpan[])builder.getSpans(start, end, FontFamilySpan.class);
        if (spans != null && spans.length > 0) {
            return spans[spans.length - 1];
        }
        return null;
    }
}

