/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;

public class NumberSpan
implements LeadingMarginSpan,
ParcelableSpan {
    private final int mGapWidth;
    private final String mNumber;
    public static final int STANDARD_GAP_WIDTH = 10;

    public NumberSpan(int gapWidth, int number) {
        this.mGapWidth = gapWidth;
        this.mNumber = Integer.toString(number).concat(".");
    }

    public NumberSpan(int number) {
        this.mGapWidth = 10;
        this.mNumber = Integer.toString(number).concat(".");
    }

    public NumberSpan(Parcel src) {
        this.mGapWidth = src.readInt();
        this.mNumber = src.readString();
    }

    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    public int getSpanTypeIdInternal() {
        return 8;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    public void writeToParcelInternal(Parcel dest, int flags) {
        dest.writeInt(this.mGapWidth);
    }

    public int getLeadingMargin(boolean first) {
        return 20 + this.mGapWidth;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
        if (((Spanned)text).getSpanStart((Object)this) == start) {
            Paint.Style style = p.getStyle();
            p.setStyle(Paint.Style.FILL);
            if (c.isHardwareAccelerated()) {
                c.save();
                c.drawText(this.mNumber, (float)(x + dir), (float)baseline, p);
                c.restore();
            } else {
                c.drawText(this.mNumber, (float)(x + dir), (float)(top + bottom) / 2.0f, p);
            }
            p.setStyle(style);
        }
    }
}

