/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.Touch;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;

public class LocalLinkMovementMethod
extends LinkMovementMethod {
    static LocalLinkMovementMethod sInstance;

    public static LocalLinkMovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new LocalLinkMovementMethod();
        }
        return sInstance;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 1 || action == 0) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout = widget.getLayout();
            int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
            ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
            if (link.length != 0) {
                if (action == 1) {
                    link[0].onClick((View)widget);
                } else if (action == 0) {
                    Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                }
                return true;
            }
            Selection.removeSelection((Spannable)buffer);
            Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
            return false;
        }
        return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
    }
}

