/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.css;

import android.graphics.Color;
import android.util.Log;
import com.osbcp.cssparser.PropertyValue;
import com.osbcp.cssparser.Rule;
import com.osbcp.cssparser.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nightwhistler.htmlspanner.FontFamily;
import net.nightwhistler.htmlspanner.HtmlSpanner;
import net.nightwhistler.htmlspanner.css.CompiledRule;
import net.nightwhistler.htmlspanner.style.Style;
import net.nightwhistler.htmlspanner.style.StyleValue;
import org.htmlcleaner.TagNode;

public class CSSCompiler {
    public static CompiledRule compile(Rule rule, HtmlSpanner spanner) {
        Log.d((String)"CSSCompiler", (String)("Compiling rule " + rule));
        ArrayList<List<TagNodeMatcher>> matchers = new ArrayList<List<TagNodeMatcher>>();
        ArrayList<StyleUpdater> styleUpdaters = new ArrayList<StyleUpdater>();
        for (Object selector : rule.getSelectors()) {
            List<TagNodeMatcher> selMatchers = CSSCompiler.createMatchersFromSelector((Selector)selector);
            matchers.add(selMatchers);
        }
        Style blank = new Style();
        for (PropertyValue propertyValue : rule.getPropertyValues()) {
            StyleUpdater updater = CSSCompiler.getStyleUpdater(propertyValue.getProperty(), propertyValue.getValue());
            if (updater == null) continue;
            styleUpdaters.add(updater);
            blank = updater.updateStyle(blank, spanner);
        }
        Log.d((String)"CSSCompiler", (String)("Compiled rule: " + blank));
        String asText = rule.toString();
        return new CompiledRule(spanner, matchers, styleUpdaters, asText);
    }

    public static Integer parseCSSColor(String colorString) {
        if (colorString.length() == 4 && colorString.startsWith("#")) {
            StringBuilder builder = new StringBuilder("#");
            for (int i = 1; i < colorString.length(); ++i) {
                builder.append(colorString.charAt(i));
                builder.append(colorString.charAt(i));
            }
            colorString = builder.toString();
        } else if (colorString.startsWith("rgb")) {
            Matcher matcher = Pattern.compile("[^0-9]").matcher(colorString);
            ArrayList<String> splitList = new ArrayList<String>(Arrays.asList(matcher.replaceAll(" ").split(" ")));
            ArrayList<String> remove = new ArrayList<String>();
            remove.add("");
            splitList.removeAll(remove);
            if (splitList.size() >= 4) {
                return Color.argb((int)Integer.parseInt((String)splitList.get(0)), (int)Integer.parseInt((String)splitList.get(1)), (int)Integer.parseInt((String)splitList.get(2)), (int)Integer.parseInt((String)splitList.get(3)));
            }
            if (splitList.size() >= 3) {
                return Color.rgb((int)Integer.parseInt((String)splitList.get(0)), (int)Integer.parseInt((String)splitList.get(1)), (int)Integer.parseInt((String)splitList.get(2)));
            }
        }
        return Color.parseColor((String)colorString);
    }

    public static List<TagNodeMatcher> createMatchersFromSelector(Selector selector) {
        ArrayList<TagNodeMatcher> matchers = new ArrayList<TagNodeMatcher>();
        String selectorString = selector.toString();
        String[] parts = selectorString.split("\\s");
        for (int i = parts.length - 1; i >= 0; --i) {
            matchers.add(CSSCompiler.createMatcherFromPart(parts[i]));
        }
        return matchers;
    }

    private static TagNodeMatcher createMatcherFromPart(String selectorPart) {
        if (selectorPart.indexOf(46) != -1) {
            return new ClassMatcher(selectorPart);
        }
        if (selectorPart.startsWith("#")) {
            return new IdMatcher(selectorPart);
        }
        return new TagNameMatcher(selectorPart);
    }

    public static StyleUpdater getStyleUpdater(final String key, final String value) {
        StyleValue styleValue;
        if ("color".equals(key)) {
            try {
                final Integer color = CSSCompiler.parseCSSColor(value);
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        Log.d((String)"CSSCompiler", (String)("Applying style " + key + ": " + value));
                        return style.setColor(color);
                    }
                };
            }
            catch (IllegalArgumentException ia) {
                Log.e((String)"CSSCompiler", (String)("Can't parse colour definition: " + value));
                return null;
            }
        }
        if ("background-color".equals(key)) {
            try {
                final Integer color = CSSCompiler.parseCSSColor(value);
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        Log.d((String)"CSSCompiler", (String)("Applying style " + key + ": " + value));
                        return style.setBackgroundColor(color);
                    }
                };
            }
            catch (IllegalArgumentException ia) {
                Log.e((String)"CSSCompiler", (String)("Can't parse colour definition: " + value));
                return null;
            }
        }
        if ("align".equals(key) || "text-align".equals(key)) {
            try {
                final Style.TextAlignment alignment = Style.TextAlignment.valueOf(value.toUpperCase());
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        Log.d((String)"CSSCompiler", (String)("Applying style " + key + ": " + value));
                        return style.setTextAlignment(alignment);
                    }
                };
            }
            catch (IllegalArgumentException i) {
                Log.e((String)"CSSCompiler", (String)("Can't parse alignment: " + value));
                return null;
            }
        }
        if ("font-weight".equals(key)) {
            try {
                final Style.FontWeight weight = Style.FontWeight.valueOf(value.toUpperCase());
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        Log.d((String)"CSSCompiler", (String)("Applying style " + key + ": " + value));
                        return style.setFontWeight(weight);
                    }
                };
            }
            catch (IllegalArgumentException i) {
                Log.e((String)"CSSCompiler", (String)("Can't parse font-weight: " + value));
                return null;
            }
        }
        if ("font-style".equals(key)) {
            try {
                final Style.FontStyle fontStyle = Style.FontStyle.valueOf(value.toUpperCase());
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        Log.d((String)"CSSCompiler", (String)("Applying style " + key + ": " + value));
                        return style.setFontStyle(fontStyle);
                    }
                };
            }
            catch (IllegalArgumentException i) {
                Log.e((String)"CSSCompiler", (String)("Can't parse font-style: " + value));
                return null;
            }
        }
        if ("font-family".equals(key)) {
            return new StyleUpdater(){

                @Override
                public Style updateStyle(Style style, HtmlSpanner spanner) {
                    Log.d((String)"CSSCompiler", (String)("Applying style " + key + ": " + value));
                    FontFamily family = spanner.getFont(value);
                    Log.d((String)"CSSCompiler", (String)("Got font " + family));
                    return style.setFontFamily(family);
                }
            };
        }
        if ("font-size".equals(key)) {
            final StyleValue styleValue2 = StyleValue.parse(value);
            if (styleValue2 != null) {
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        Log.d((String)"CSSCompiler", (String)("Applying style " + key + ": " + value));
                        return style.setFontSize(styleValue2);
                    }
                };
            }
            try {
                final Float number = Float.valueOf(CSSCompiler.translateFontSize(Integer.parseInt(value)));
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        Log.d((String)"CSSCompiler", (String)("Applying style " + key + ": " + value));
                        return style.setFontSize(new StyleValue(number.floatValue(), StyleValue.Unit.EM));
                    }
                };
            }
            catch (NumberFormatException nfe) {
                Log.e((String)"CSSCompiler", (String)("Can't parse font-size: " + value));
                return null;
            }
        }
        if ("margin-bottom".equals(key) && (styleValue = StyleValue.parse(value)) != null) {
            return new StyleUpdater(){

                @Override
                public Style updateStyle(Style style, HtmlSpanner spanner) {
                    return style.setMarginBottom(styleValue);
                }
            };
        }
        if ("margin-top".equals(key) && (styleValue = StyleValue.parse(value)) != null) {
            return new StyleUpdater(){

                @Override
                public Style updateStyle(Style style, HtmlSpanner spanner) {
                    return style.setMarginTop(styleValue);
                }
            };
        }
        if ("margin-left".equals(key) && (styleValue = StyleValue.parse(value)) != null) {
            return new StyleUpdater(){

                @Override
                public Style updateStyle(Style style, HtmlSpanner spanner) {
                    return style.setMarginLeft(styleValue);
                }
            };
        }
        if ("margin-right".equals(key) && (styleValue = StyleValue.parse(value)) != null) {
            return new StyleUpdater(){

                @Override
                public Style updateStyle(Style style, HtmlSpanner spanner) {
                    return style.setMarginRight(styleValue);
                }
            };
        }
        if ("margin".equals(key)) {
            return CSSCompiler.parseMargin(value);
        }
        if ("text-indent".equals(key) && (styleValue = StyleValue.parse(value)) != null) {
            return new StyleUpdater(){

                @Override
                public Style updateStyle(Style style, HtmlSpanner spanner) {
                    return style.setTextIndent(styleValue);
                }
            };
        }
        if ("display".equals(key)) {
            try {
                final Style.DisplayStyle displayStyle = Style.DisplayStyle.valueOf(value.toUpperCase());
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        return style.setDisplayStyle(displayStyle);
                    }
                };
            }
            catch (IllegalArgumentException ia) {
                Log.e((String)"CSSCompiler", (String)("Can't parse display-value: " + value));
                return null;
            }
        }
        if ("border-style".equals(key)) {
            try {
                final Style.BorderStyle borderStyle = Style.BorderStyle.valueOf(value.toUpperCase());
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        return style.setBorderStyle(borderStyle);
                    }
                };
            }
            catch (IllegalArgumentException ia) {
                Log.e((String)"CSSCompiler", (String)("Could not parse border-style " + value));
                return null;
            }
        }
        if ("border-color".equals(key)) {
            try {
                final Integer borderColor = CSSCompiler.parseCSSColor(value);
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        return style.setBorderColor(borderColor);
                    }
                };
            }
            catch (IllegalArgumentException ia) {
                Log.e((String)"CSSCompiler", (String)("Could not parse border-color " + value));
                return null;
            }
        }
        if ("border-width".equals(key)) {
            final StyleValue borderWidth = StyleValue.parse(value);
            if (borderWidth != null) {
                return new StyleUpdater(){

                    @Override
                    public Style updateStyle(Style style, HtmlSpanner spanner) {
                        return style.setBorderWidth(borderWidth);
                    }
                };
            }
            Log.e((String)"CSSCompiler", (String)("Could not parse border-color " + value));
            return null;
        }
        if ("border".equals(key)) {
            return CSSCompiler.parseBorder(value);
        }
        if ("text-decoration".equals(key)) {
            final Style.TextLinesStyle textLinesStyle = Style.TextLinesStyle.valueOfCompat(value.toUpperCase());
            return new StyleUpdater(){

                @Override
                public Style updateStyle(Style style, HtmlSpanner spanner) {
                    return style.setTextLinesStyle(textLinesStyle);
                }
            };
        }
        Log.d((String)"CSSCompiler", (String)("Don't understand CSS property '" + key + "'. Ignoring it."));
        return null;
    }

    private static float translateFontSize(int fontSize) {
        switch (fontSize) {
            case 1: {
                return 0.6f;
            }
            case 2: {
                return 0.8f;
            }
            case 3: {
                return 1.0f;
            }
            case 4: {
                return 1.2f;
            }
            case 5: {
                return 1.4f;
            }
            case 6: {
                return 1.6f;
            }
            case 7: {
                return 1.8f;
            }
        }
        return 1.0f;
    }

    private static StyleUpdater parseBorder(String borderDefinition) {
        String[] parts = borderDefinition.split("\\s");
        StyleValue borderWidth = null;
        Integer borderColor = null;
        Style.BorderStyle borderStyle = null;
        for (String part : parts) {
            Log.d((String)"CSSParser", (String)("Trying to parse " + part));
            if (borderWidth == null && (borderWidth = StyleValue.parse(part)) != null) {
                Log.d((String)"CSSParser", (String)("Parsed " + part + " as border-width"));
                continue;
            }
            if (borderColor == null) {
                try {
                    borderColor = CSSCompiler.parseCSSColor(part);
                    Log.d((String)"CSSParser", (String)("Parsed " + part + " as border-color"));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (borderStyle == null) {
                try {
                    borderStyle = Style.BorderStyle.valueOf(part.toUpperCase());
                    Log.d((String)"CSSParser", (String)("Parsed " + part + " as border-style"));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Log.d((String)"CSSParser", (String)("Could not make sense of border-spec " + part));
        }
        final StyleValue finalBorderWidth = borderWidth;
        final Integer finalBorderColor = borderColor;
        final Style.BorderStyle finalBorderStyle = borderStyle;
        return new StyleUpdater(){

            @Override
            public Style updateStyle(Style style, HtmlSpanner spanner) {
                if (finalBorderColor != null) {
                    style = style.setBorderColor(finalBorderColor);
                }
                if (finalBorderWidth != null) {
                    style = style.setBorderWidth(finalBorderWidth);
                }
                if (finalBorderStyle != null) {
                    style = style.setBorderStyle(finalBorderStyle);
                }
                return style;
            }
        };
    }

    private static StyleUpdater parseMargin(String marginValue) {
        String[] parts = marginValue.split("\\s");
        String bottomMarginString = "";
        String topMarginString = "";
        String leftMarginString = "";
        String rightMarginString = "";
        if (parts.length == 1) {
            bottomMarginString = parts[0];
            topMarginString = parts[0];
            leftMarginString = parts[0];
            rightMarginString = parts[0];
        } else if (parts.length == 2) {
            topMarginString = parts[0];
            bottomMarginString = parts[0];
            leftMarginString = parts[1];
            rightMarginString = parts[1];
        } else if (parts.length == 3) {
            topMarginString = parts[0];
            leftMarginString = parts[1];
            rightMarginString = parts[1];
            bottomMarginString = parts[2];
        } else if (parts.length == 4) {
            topMarginString = parts[0];
            rightMarginString = parts[1];
            bottomMarginString = parts[2];
            leftMarginString = parts[3];
        }
        final StyleValue marginBottom = StyleValue.parse(bottomMarginString);
        final StyleValue marginTop = StyleValue.parse(topMarginString);
        final StyleValue marginLeft = StyleValue.parse(leftMarginString);
        final StyleValue marginRight = StyleValue.parse(rightMarginString);
        return new StyleUpdater(){

            @Override
            public Style updateStyle(Style style, HtmlSpanner spanner) {
                Style resultStyle = style;
                if (marginBottom != null) {
                    resultStyle = resultStyle.setMarginBottom(marginBottom);
                }
                if (marginTop != null) {
                    resultStyle = resultStyle.setMarginTop(marginTop);
                }
                if (marginLeft != null) {
                    resultStyle = resultStyle.setMarginLeft(marginLeft);
                }
                if (marginRight != null) {
                    resultStyle = resultStyle.setMarginRight(marginRight);
                }
                return resultStyle;
            }
        };
    }

    private static class IdMatcher
    implements TagNodeMatcher {
        private String id;

        private IdMatcher(String selectorString) {
            this.id = selectorString.substring(1);
        }

        @Override
        public boolean matches(TagNode tagNode) {
            if (tagNode == null) {
                return false;
            }
            String idAttribute = tagNode.getAttributeByName("id");
            return idAttribute != null && idAttribute.equals(this.id);
        }
    }

    private static class TagNameMatcher
    implements TagNodeMatcher {
        private String tagName;

        private TagNameMatcher(String selectorString) {
            this.tagName = selectorString.trim();
        }

        @Override
        public boolean matches(TagNode tagNode) {
            return tagNode != null && this.tagName.equalsIgnoreCase(tagNode.getName());
        }
    }

    private static class ClassMatcher
    implements TagNodeMatcher {
        private String tagName;
        private String className;

        private ClassMatcher(String selectorString) {
            String[] elements = selectorString.split("\\.");
            if (elements.length == 2) {
                this.tagName = elements[0];
                this.className = elements[1];
            }
        }

        @Override
        public boolean matches(TagNode tagNode) {
            if (tagNode == null) {
                return false;
            }
            if (this.tagName != null && this.tagName.length() > 0 && !this.tagName.equals(tagNode.getName())) {
                return false;
            }
            String classAttribute = tagNode.getAttributeByName("class");
            return classAttribute != null && classAttribute.equals(this.className);
        }
    }

    public static interface TagNodeMatcher {
        public boolean matches(TagNode var1);
    }

    public static interface StyleUpdater {
        public Style updateStyle(Style var1, HtmlSpanner var2);
    }
}

