/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.style;

import net.nightwhistler.htmlspanner.FontFamily;
import net.nightwhistler.htmlspanner.style.StyleValue;

public class Style {
    private final FontFamily fontFamily;
    private final TextAlignment textAlignment;
    private final StyleValue fontSize;
    private final FontWeight fontWeight;
    private final FontStyle fontStyle;
    private final Integer color;
    private final Integer backgroundColor;
    private final Integer borderColor;
    private final TextLinesStyle textLinesStyle;
    private final DisplayStyle displayStyle;
    private final BorderStyle borderStyle;
    private final StyleValue borderWidth;
    private final StyleValue textIndent;
    private final StyleValue marginTop;
    private final StyleValue marginBottom;
    private final StyleValue marginLeft;
    private final StyleValue marginRight;

    public Style() {
        this.fontFamily = null;
        this.textAlignment = null;
        this.fontSize = null;
        this.fontWeight = null;
        this.fontStyle = null;
        this.color = null;
        this.backgroundColor = null;
        this.textLinesStyle = null;
        this.displayStyle = null;
        this.marginBottom = null;
        this.textIndent = null;
        this.marginTop = null;
        this.marginLeft = null;
        this.marginRight = null;
        this.borderColor = null;
        this.borderStyle = null;
        this.borderWidth = null;
    }

    public Style(FontFamily family, TextAlignment textAlignment, StyleValue fontSize, FontWeight fontWeight, FontStyle fontStyle, Integer color, Integer backgroundColor, TextLinesStyle textLinesStyle, DisplayStyle displayStyle, StyleValue marginTop, StyleValue marginBottom, StyleValue marginLeft, StyleValue marginRight, StyleValue textIndent, Integer borderColor, BorderStyle borderStyle, StyleValue borderWidth) {
        this.fontFamily = family;
        this.textAlignment = textAlignment;
        this.fontSize = fontSize;
        this.fontWeight = fontWeight;
        this.fontStyle = fontStyle;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.displayStyle = displayStyle;
        this.textLinesStyle = textLinesStyle;
        this.marginBottom = marginBottom;
        this.textIndent = textIndent;
        this.marginTop = marginTop;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
        this.borderStyle = borderStyle;
    }

    public Style setFontFamily(FontFamily fontFamily) {
        return new Style(fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setTextAlignment(TextAlignment alignment) {
        return new Style(this.fontFamily, alignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setFontSize(StyleValue fontSize) {
        return new Style(this.fontFamily, this.textAlignment, fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setFontWeight(FontWeight fontWeight) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setFontStyle(FontStyle fontStyle) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setColor(Integer color) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setBackgroundColor(Integer bgColor) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, bgColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setTextLinesStyle(TextLinesStyle textLinesStyle) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setDisplayStyle(DisplayStyle displayStyle) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setMarginBottom(StyleValue marginBottom) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setMarginTop(StyleValue marginTop) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setMarginLeft(StyleValue marginLeft) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setMarginRight(StyleValue marginRight) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, marginRight, this.textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setTextIndent(StyleValue textIndent) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, textIndent, this.borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setBorderStyle(BorderStyle borderStyle) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, borderStyle, this.borderWidth);
    }

    public Style setBorderColor(Integer borderColor) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, borderColor, this.borderStyle, this.borderWidth);
    }

    public Style setBorderWidth(StyleValue borderWidth) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.textLinesStyle, this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent, this.borderColor, this.borderStyle, borderWidth);
    }

    public Integer getBackgroundColor() {
        return this.backgroundColor;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public StyleValue getFontSize() {
        return this.fontSize;
    }

    public FontWeight getFontWeight() {
        return this.fontWeight;
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public Integer getColor() {
        return this.color;
    }

    public TextLinesStyle getTextLinesStyle() {
        return this.textLinesStyle;
    }

    public DisplayStyle getDisplayStyle() {
        return this.displayStyle;
    }

    public StyleValue getMarginBottom() {
        return this.marginBottom;
    }

    public StyleValue getMarginTop() {
        return this.marginTop;
    }

    public StyleValue getMarginLeft() {
        return this.marginLeft;
    }

    public StyleValue getMarginRight() {
        return this.marginRight;
    }

    public StyleValue getTextIndent() {
        return this.textIndent;
    }

    public Integer getBorderColor() {
        return this.borderColor;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public StyleValue getBorderWidth() {
        return this.borderWidth;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{\n");
        if (this.fontFamily != null) {
            result.append("  font-family: " + this.fontFamily.getName() + "\n");
        }
        if (this.textAlignment != null) {
            result.append("  text-alignment: " + (Object)((Object)this.textAlignment) + "\n");
        }
        if (this.fontSize != null) {
            result.append("  font-size: " + this.fontSize + "\n");
        }
        if (this.fontWeight != null) {
            result.append("  font-weight: " + (Object)((Object)this.fontWeight) + "\n");
        }
        if (this.fontStyle != null) {
            result.append("  font-style: " + (Object)((Object)this.fontStyle) + "\n");
        }
        if (this.color != null) {
            result.append("  color: " + this.color + "\n");
        }
        if (this.backgroundColor != null) {
            result.append("  background-color: " + this.backgroundColor + "\n");
        }
        if (this.textLinesStyle != null) {
            result.append("  text-decoration: " + (Object)((Object)this.textLinesStyle) + "\n");
        }
        if (this.displayStyle != null) {
            result.append("  display: " + (Object)((Object)this.displayStyle) + "\n");
        }
        if (this.marginTop != null) {
            result.append("  margin-top: " + this.marginTop + "\n");
        }
        if (this.marginBottom != null) {
            result.append("  margin-bottom: " + this.marginBottom + "\n");
        }
        if (this.marginLeft != null) {
            result.append("  margin-left: " + this.marginLeft + "\n");
        }
        if (this.marginRight != null) {
            result.append("  margin-right: " + this.marginRight + "\n");
        }
        if (this.textIndent != null) {
            result.append("  text-indent: " + this.textIndent + "\n");
        }
        if (this.borderStyle != null) {
            result.append("  border-style: " + (Object)((Object)this.borderStyle) + "\n");
        }
        if (this.borderColor != null) {
            result.append("  border-color: " + this.borderColor + "\n");
        }
        if (this.borderWidth != null) {
            result.append("  border-style: " + this.borderWidth + "\n");
        }
        result.append("}\n");
        return result.toString();
    }

    public static enum TextLinesStyle {
        OVERLINE,
        LINE_THROUGH,
        UNDERLINE,
        NONE;


        public static TextLinesStyle valueOfCompat(String name) {
            try {
                return TextLinesStyle.valueOf(name.replace("_", "-"));
            }
            catch (Exception e) {
                return NONE;
            }
        }
    }

    public static enum BorderStyle {
        SOLID,
        DASHED,
        DOTTED,
        DOUBLE;

    }

    public static enum DisplayStyle {
        BLOCK,
        INLINE;

    }

    public static enum FontStyle {
        NORMAL,
        ITALIC;

    }

    public static enum FontWeight {
        NORMAL,
        BOLD;

    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

