/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import net.nightwhistler.htmlspanner.SpanStack;
import net.nightwhistler.htmlspanner.handlers.StyledTextHandler;
import net.nightwhistler.htmlspanner.handlers.listeners.OnClickUrlListener;
import net.nightwhistler.htmlspanner.spans.URLStyleSpan;
import net.nightwhistler.htmlspanner.style.Style;
import org.htmlcleaner.TagNode;

public class LinkHandler
extends StyledTextHandler {
    private OnClickUrlListener mOnClickUrlListener;

    public LinkHandler setOnClickUrlListener(OnClickUrlListener listener) {
        this.mOnClickUrlListener = listener;
        return this;
    }

    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end, Style useStyle, SpanStack stack) {
        super.handleTagNode(node, builder, start, end, useStyle, stack);
        final String href = node.getAttributeByName("href");
        String style = node.getAttributeByName("style");
        stack.pushSpan((Object)new URLStyleSpan(href, TextUtils.isEmpty((CharSequence)style)){

            public void onClick(View widget) {
                if (LinkHandler.this.mOnClickUrlListener == null) {
                    super.onClick(widget);
                } else {
                    LinkHandler.this.mOnClickUrlListener.onClickUrl(this, href);
                }
            }
        }, start, end);
    }
}

