/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.css;

import java.util.ArrayList;
import java.util.List;
import net.nightwhistler.htmlspanner.HtmlSpanner;
import net.nightwhistler.htmlspanner.css.CSSCompiler;
import net.nightwhistler.htmlspanner.style.Style;
import org.htmlcleaner.TagNode;

public class CompiledRule {
    private List<List<CSSCompiler.TagNodeMatcher>> matchers = new ArrayList<List<CSSCompiler.TagNodeMatcher>>();
    private List<CSSCompiler.StyleUpdater> styleUpdaters = new ArrayList<CSSCompiler.StyleUpdater>();
    private HtmlSpanner spanner;
    private String asText;

    CompiledRule(HtmlSpanner spanner, List<List<CSSCompiler.TagNodeMatcher>> matchers, List<CSSCompiler.StyleUpdater> styleUpdaters, String asText) {
        this.spanner = spanner;
        this.matchers = matchers;
        this.styleUpdaters = styleUpdaters;
        this.asText = asText;
    }

    public String toString() {
        return this.asText;
    }

    public Style applyStyle(Style style) {
        Style result = style;
        for (CSSCompiler.StyleUpdater updater : this.styleUpdaters) {
            result = updater.updateStyle(result, this.spanner);
        }
        return result;
    }

    public boolean matches(TagNode tagNode) {
        for (List<CSSCompiler.TagNodeMatcher> matcherList : this.matchers) {
            if (!CompiledRule.matchesChain(matcherList, tagNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesChain(List<CSSCompiler.TagNodeMatcher> matchers, TagNode tagNode) {
        TagNode nodeToMatch = tagNode;
        for (CSSCompiler.TagNodeMatcher matcher : matchers) {
            if (!matcher.matches(nodeToMatch)) {
                return false;
            }
            nodeToMatch = nodeToMatch.getParent();
        }
        return true;
    }
}

