/*
 * Decompiled with CFR 0.152.
 */
package com.dyhdyh.support.glide.transformations;

import android.graphics.Bitmap;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.dyhdyh.support.glide.gif.transform.OverrideSizeTransform;
import com.dyhdyh.support.glide.resource.gifbitmap.ImageWrapper;
import com.dyhdyh.support.glide.resource.gifbitmap.ImageWrapperResource;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.transforms.Transform;

public abstract class ImageWrapperTransformation
implements Transformation<ImageWrapper> {
    private Transform mGifTransform;
    private Transformation mBitmapTransformation;

    public ImageWrapperTransformation(Transform gifTransform, Transformation bitmapTransformation) {
        this.mGifTransform = gifTransform;
        this.mBitmapTransformation = bitmapTransformation;
    }

    public Resource<ImageWrapper> transform(Resource<ImageWrapper> resource, int outWidth, int outHeight) {
        ImageWrapper gifBitmapWrapper = (ImageWrapper)resource.get();
        Resource<Bitmap> bitmapResource = gifBitmapWrapper.getBitmapResource();
        if (bitmapResource != null) {
            Resource transform = this.mBitmapTransformation.transform(bitmapResource, outWidth, outHeight);
            return new ImageWrapperResource(new ImageWrapper((Resource<Bitmap>)transform, gifBitmapWrapper.getGifResource()));
        }
        Resource<GifDrawable> gifResource = gifBitmapWrapper.getGifResource();
        if (gifResource != null) {
            if (this.mGifTransform instanceof OverrideSizeTransform) {
                ((OverrideSizeTransform)this.mGifTransform).setDrawSize(outWidth, outHeight);
            }
            ((GifDrawable)gifResource.get()).setTransform(this.mGifTransform);
        }
        return resource;
    }

    public String getId() {
        return this.getClass().getName();
    }
}

