/*
 * Decompiled with CFR 0.152.
 */
package com.dyhdyh.support.glide.resource.gifbitmap;

import android.graphics.Bitmap;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.model.ImageVideoWrapper;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.ImageHeaderParser;
import com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import com.bumptech.glide.util.ByteArrayPool;
import com.dyhdyh.support.glide.resource.gifbitmap.ImageWrapper;
import com.dyhdyh.support.glide.resource.gifbitmap.ImageWrapperResource;
import java.io.IOException;
import java.io.InputStream;
import pl.droidsonroids.gif.GifDrawable;

public class ImageWrapperResourceDecoder
implements ResourceDecoder<ImageVideoWrapper, ImageWrapper> {
    private static final ImageTypeParser DEFAULT_PARSER = new ImageTypeParser();
    private static final BufferedStreamFactory DEFAULT_STREAM_FACTORY = new BufferedStreamFactory();
    static final int MARK_LIMIT_BYTES = 2048;
    private final ResourceDecoder<ImageVideoWrapper, Bitmap> bitmapDecoder;
    private final ResourceDecoder<InputStream, GifDrawable> gifDecoder;
    private final BitmapPool bitmapPool;
    private final ImageTypeParser parser;
    private final BufferedStreamFactory streamFactory;
    private String id;

    public ImageWrapperResourceDecoder(ResourceDecoder<ImageVideoWrapper, Bitmap> bitmapDecoder, ResourceDecoder<InputStream, GifDrawable> gifDecoder, BitmapPool bitmapPool) {
        this(bitmapDecoder, gifDecoder, bitmapPool, DEFAULT_PARSER, DEFAULT_STREAM_FACTORY);
    }

    ImageWrapperResourceDecoder(ResourceDecoder<ImageVideoWrapper, Bitmap> bitmapDecoder, ResourceDecoder<InputStream, GifDrawable> gifDecoder, BitmapPool bitmapPool, ImageTypeParser parser, BufferedStreamFactory streamFactory) {
        this.bitmapDecoder = bitmapDecoder;
        this.gifDecoder = gifDecoder;
        this.bitmapPool = bitmapPool;
        this.parser = parser;
        this.streamFactory = streamFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource<ImageWrapper> decode(ImageVideoWrapper source, int width, int height) throws IOException {
        ByteArrayPool pool = ByteArrayPool.get();
        byte[] tempBytes = pool.getBytes();
        ImageWrapper wrapper = null;
        try {
            wrapper = this.decode(source, width, height, tempBytes);
        }
        finally {
            pool.releaseBytes(tempBytes);
        }
        return wrapper != null ? new ImageWrapperResource(wrapper) : null;
    }

    private ImageWrapper decode(ImageVideoWrapper source, int width, int height, byte[] bytes) throws IOException {
        ImageWrapper result = source.getStream() != null ? this.decodeStream(source, width, height, bytes) : this.decodeBitmapWrapper(source, width, height);
        return result;
    }

    private ImageWrapper decodeStream(ImageVideoWrapper source, int width, int height, byte[] bytes) throws IOException {
        InputStream bis = this.streamFactory.build(source.getStream(), bytes);
        bis.mark(2048);
        ImageHeaderParser.ImageType type = this.parser.parse(bis);
        bis.reset();
        ImageWrapper result = null;
        if (type == ImageHeaderParser.ImageType.GIF) {
            result = this.decodeGifWrapper(bis, width, height);
        }
        if (result == null) {
            ImageVideoWrapper forBitmapDecoder = new ImageVideoWrapper(bis, source.getFileDescriptor());
            result = this.decodeBitmapWrapper(forBitmapDecoder, width, height);
        }
        return result;
    }

    private ImageWrapper decodeGifWrapper(InputStream bis, int width, int height) throws IOException {
        ImageWrapper result = null;
        Resource gifResource = this.gifDecoder.decode((Object)bis, width, height);
        if (gifResource != null) {
            GifDrawable drawable = (GifDrawable)gifResource.get();
            if (drawable.getNumberOfFrames() > 1) {
                result = new ImageWrapper(null, (Resource<GifDrawable>)gifResource);
            } else {
                BitmapResource bitmapResource = new BitmapResource(drawable.getCurrentFrame(), this.bitmapPool);
                result = new ImageWrapper((Resource<Bitmap>)bitmapResource, null);
            }
        }
        return result;
    }

    private ImageWrapper decodeBitmapWrapper(ImageVideoWrapper toDecode, int width, int height) throws IOException {
        ImageWrapper result = null;
        Resource bitmapResource = this.bitmapDecoder.decode((Object)toDecode, width, height);
        if (bitmapResource != null) {
            result = new ImageWrapper((Resource<Bitmap>)bitmapResource, null);
        }
        return result;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.gifDecoder.getId() + this.bitmapDecoder.getId();
        }
        return this.id;
    }

    static class ImageTypeParser {
        ImageTypeParser() {
        }

        public ImageHeaderParser.ImageType parse(InputStream is) throws IOException {
            return new ImageHeaderParser(is).getType();
        }
    }

    static class BufferedStreamFactory {
        BufferedStreamFactory() {
        }

        public InputStream build(InputStream is, byte[] buffer) {
            return new RecyclableBufferedInputStream(is, buffer);
        }
    }
}

