/*
 * Decompiled with CFR 0.152.
 */
package com.dyhdyh.support.glide.resource.decoder;

import android.util.Log;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.bytes.BytesResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamByteArrayResourceDecoder
implements ResourceDecoder<InputStream, byte[]> {
    private final String TAG = "StreamByteDecoder";

    public Resource<byte[]> decode(InputStream source, int width, int height) throws IOException {
        return new BytesResource(this.inputStreamToBytes(source));
    }

    private byte[] inputStreamToBytes(InputStream is) {
        int bufferSize = 16384;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
        try {
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = is.read(data)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            Log.w((String)"StreamByteDecoder", (String)"Error reading data from stream", (Throwable)e);
        }
        return buffer.toByteArray();
    }

    public String getId() {
        return this.getClass().getName();
    }
}

