/*
 * Decompiled with CFR 0.152.
 */
package com.dyhdyh.support.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import com.bumptech.glide.GenericRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Encoder;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.StreamEncoder;
import com.bumptech.glide.load.model.stream.StreamStringLoader;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.bumptech.glide.request.animation.ViewPropertyAnimation;
import com.dyhdyh.support.glide.animator.DrawableCrossFadeAnimator;
import com.dyhdyh.support.glide.resource.gifbitmap.ImageWrapper;
import com.dyhdyh.support.glide.resource.gifbitmap.ImageWrapperDrawableTranscoder;
import com.dyhdyh.support.glide.resource.gifbitmap.ImageWrapperFileToStreamDecoder;
import com.dyhdyh.support.glide.resource.gifbitmap.ImageWrapperStreamResourceDecoder;
import com.dyhdyh.support.glide.transformations.ImageWrapperCircleTransformation;
import com.dyhdyh.support.glide.transformations.ImageWrapperTransformation;
import java.io.InputStream;

public class GlideSupport {
    private GenericRequestBuilder<String, InputStream, ImageWrapper, Drawable> mRequestBuilder;
    private Context mContext;

    public GlideSupport(Context context) {
        this.mContext = context;
    }

    public static GlideSupport with(Context context) {
        return new GlideSupport(context);
    }

    public GlideSupport gifEnhancement() {
        this.mRequestBuilder = Glide.with((Context)this.mContext).using((ModelLoader)new StreamStringLoader(this.mContext), InputStream.class).from(String.class).as(ImageWrapper.class).transcode((ResourceTranscoder)new ImageWrapperDrawableTranscoder(this.mContext), Drawable.class).decoder((ResourceDecoder)new ImageWrapperStreamResourceDecoder(this.mContext)).cacheDecoder((ResourceDecoder)new ImageWrapperFileToStreamDecoder(this.mContext)).sourceEncoder((Encoder)new StreamEncoder()).animate((ViewPropertyAnimation.Animator)new DrawableCrossFadeAnimator()).diskCacheStrategy(DiskCacheStrategy.SOURCE);
        return this;
    }

    public GlideSupport crossFade() {
        this.mRequestBuilder.animate((ViewPropertyAnimation.Animator)new DrawableCrossFadeAnimator());
        return this;
    }

    public GlideSupport circle() {
        this.mRequestBuilder.transform(new Transformation[]{new ImageWrapperCircleTransformation(this.mContext)});
        return this;
    }

    public GlideSupport transform(ImageWrapperTransformation transformation) {
        this.mRequestBuilder.transform(new Transformation[]{transformation});
        return this;
    }

    public GlideSupport animate(ViewPropertyAnimation.Animator animator) {
        this.mRequestBuilder.animate(animator);
        return this;
    }

    public GenericRequestBuilder<String, InputStream, ImageWrapper, Drawable> glide() {
        return this.mRequestBuilder;
    }
}

