/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import com.dubture.jenkins.digitalocean.DigitalOcean;
import com.dubture.jenkins.digitalocean.DigitalOceanCloud;
import com.dubture.jenkins.digitalocean.DigitalOceanComputer;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;

public class Slave
extends AbstractCloudSlave
implements TrackedItem {
    private static final Logger LOG = Logger.getLogger(Slave.class.getName());
    private final ProvisioningActivity.Id provisioningId;
    private final String cloudName;
    private final int idleTerminationTime;
    private final String initScript;
    private final Integer dropletId;
    private final String privateKey;
    private final String remoteAdmin;
    private final String jvmOpts;
    private final long startTimeMillis;
    private final int sshPort;

    public Slave(ProvisioningActivity.Id provisioningId, String cloudName, String name, String nodeDescription, Integer dropletId, String privateKey, String remoteAdmin, String remoteFS, int sshPort, int numExecutors, int idleTerminationTime, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String initScript) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, Node.Mode.NORMAL, labelString, launcher, retentionStrategy, nodeProperties);
        this.provisioningId = provisioningId;
        this.cloudName = cloudName;
        this.dropletId = dropletId;
        this.privateKey = privateKey;
        this.remoteAdmin = remoteAdmin;
        this.idleTerminationTime = idleTerminationTime;
        this.initScript = initScript;
        this.jvmOpts = "";
        this.sshPort = sshPort;
        this.startTimeMillis = System.currentTimeMillis();
    }

    public DigitalOceanComputer createComputer() {
        return new DigitalOceanComputer(this);
    }

    public DigitalOceanCloud getCloud() {
        return (DigitalOceanCloud)Jenkins.getInstance().getCloud(this.cloudName);
    }

    public String getRemoteAdmin() {
        if (this.remoteAdmin == null || this.remoteAdmin.length() == 0) {
            return "root";
        }
        return this.remoteAdmin;
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        DigitalOcean.tryDestroyDropletAsync(this.getCloud().getAuthToken(), this.dropletId);
    }

    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Integer getDropletId() {
        return this.dropletId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public int getIdleTerminationTime() {
        return this.idleTerminationTime;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getJvmOpts() {
        return this.jvmOpts;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    @Extension
    public static class DescriptorImpl
    extends Slave.SlaveDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "DigitalOcean Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

