/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DropletName {
    private static final String PREFIX = "jenkins";
    private static final String CLOUD_REGEX = "([a-zA-Z0-9\\.]+)";
    private static final String SLAVE_REGEX = "([a-zA-Z0-9\\.]+)";
    private static final String UUID_REGEX = "\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}";
    private static final String DROPLET_REGEX = "jenkins-([a-zA-Z0-9\\.]+)-([a-zA-Z0-9\\.]+)-\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}";
    private static final Pattern CLOUD_PATTERN = Pattern.compile("^([a-zA-Z0-9\\.]+)$");
    private static final Pattern SLAVE_PATTERN = Pattern.compile("^([a-zA-Z0-9\\.]+)$");
    private static final Pattern DROPLET_PATTERN = Pattern.compile("^jenkins-([a-zA-Z0-9\\.]+)-([a-zA-Z0-9\\.]+)-\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}$");

    private DropletName() {
        throw new AssertionError();
    }

    public static boolean isValidCloudName(String cloudName) {
        return CLOUD_PATTERN.matcher(cloudName).matches();
    }

    public static boolean isValidSlaveName(String slaveName) {
        return SLAVE_PATTERN.matcher(slaveName).matches();
    }

    public static String generateDropletName(String cloudName, String slaveName) {
        return "jenkins-" + cloudName + "-" + slaveName + "-" + UUID.randomUUID().toString();
    }

    public static boolean isDropletInstanceOfCloud(String dropletName, String cloudName) {
        Matcher m = DROPLET_PATTERN.matcher(dropletName);
        return m.matches() && m.group(1).equals(cloudName);
    }

    public static boolean isDropletInstanceOfSlave(String dropletName, String cloudName, String slaveName) {
        Matcher m = DROPLET_PATTERN.matcher(dropletName);
        return m.matches() && m.group(1).equals(cloudName) && m.group(2).equals(slaveName);
    }
}

