/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import com.google.common.collect.Lists;
import com.myjeeva.digitalocean.common.ImageType;
import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.impl.DigitalOceanClient;
import com.myjeeva.digitalocean.pojo.Droplet;
import com.myjeeva.digitalocean.pojo.Droplets;
import com.myjeeva.digitalocean.pojo.Image;
import com.myjeeva.digitalocean.pojo.Images;
import com.myjeeva.digitalocean.pojo.Key;
import com.myjeeva.digitalocean.pojo.Keys;
import com.myjeeva.digitalocean.pojo.Region;
import com.myjeeva.digitalocean.pojo.Regions;
import com.myjeeva.digitalocean.pojo.Size;
import com.myjeeva.digitalocean.pojo.Sizes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DigitalOcean {
    private static final Logger LOGGER = Logger.getLogger(DigitalOcean.class.getName());
    private static final List<DestroyInfo> toBeDestroyedDroplets = new ArrayList<DestroyInfo>();
    private static final Thread dropletDestroyer = new Thread(() -> {
        while (true) {
            String previousAuthToken = null;
            DigitalOceanClient client = null;
            List droplets = null;
            boolean failedToDestroy = false;
            List<DestroyInfo> list = toBeDestroyedDroplets;
            synchronized (list) {
                Iterator<DestroyInfo> it = toBeDestroyedDroplets.iterator();
                while (it.hasNext()) {
                    DestroyInfo di = it.next();
                    if (!di.authToken.equals(previousAuthToken)) {
                        previousAuthToken = di.authToken;
                        client = new DigitalOceanClient(di.authToken);
                        droplets = null;
                    }
                    try {
                        LOGGER.info("Trying to destroy droplet " + di.dropletId);
                        client.deleteDroplet(Integer.valueOf(di.dropletId));
                        LOGGER.info("Droplet " + di.dropletId + " is destroyed");
                        it.remove();
                    }
                    catch (Exception e) {
                        if (droplets == null) {
                            try {
                                droplets = client.getAvailableDroplets(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getDroplets();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (droplets != null) {
                            boolean found = false;
                            for (Droplet d : droplets) {
                                if (d.getId() != di.dropletId) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                LOGGER.info("Droplet " + di.dropletId + " doesn't even exist, stop trying to destroy it you dummy!");
                                it.remove();
                                continue;
                            }
                        }
                        failedToDestroy = true;
                        LOGGER.warning("Failed to destroy droplet " + di.dropletId);
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                if (failedToDestroy) {
                    LOGGER.info("Retrying to destroy the droplets in about 10 seconds");
                    try {
                        toBeDestroyedDroplets.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    LOGGER.info("Waiting on more droplets to destroy");
                    while (toBeDestroyedDroplets.isEmpty()) {
                        try {
                            toBeDestroyedDroplets.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    });

    private DigitalOcean() {
        throw new AssertionError();
    }

    static List<Size> getAvailableSizes(String authToken) throws DigitalOceanException, RequestUnsuccessfulException {
        Sizes sizes;
        DigitalOceanClient client = new DigitalOceanClient(authToken);
        ArrayList<Size> availableSizes = new ArrayList<Size>();
        int page = 0;
        do {
            sizes = client.getAvailableSizes(Integer.valueOf(++page));
            availableSizes.addAll(sizes.getSizes());
        } while (sizes.getMeta().getTotal() > availableSizes.size());
        availableSizes.sort(Comparator.comparing(Size::getMemorySizeInMb));
        return availableSizes;
    }

    static SortedMap<String, Image> getAvailableImages(String authToken) throws DigitalOceanException, RequestUnsuccessfulException {
        Images images;
        DigitalOceanClient client = new DigitalOceanClient(authToken);
        TreeMap<String, Image> availableImages = new TreeMap<String, Image>(DigitalOcean.ignoringCase());
        int page = 0;
        do {
            images = client.getAvailableImages(Integer.valueOf(++page), Integer.valueOf(Integer.MAX_VALUE));
            for (Image image : images.getImages()) {
                String name;
                String prefix = DigitalOcean.getPrefix(image);
                String numberedName = name = prefix + image.getDistribution() + " " + image.getName();
                int count = 2;
                while (availableImages.containsKey(numberedName)) {
                    numberedName = name + " (" + count + ")";
                    ++count;
                }
                availableImages.put(numberedName, image);
            }
        } while (images.getMeta().getTotal() > availableImages.size());
        return availableImages;
    }

    private static String getPrefix(Image image) {
        if (image.getType() == ImageType.BACKUP) {
            return "(Backup) ";
        }
        if (image.getType() == ImageType.SNAPSHOT && image.getSlug() == null && !image.isAvailablePublic()) {
            return "(Snapshot) ";
        }
        return "";
    }

    static String getImageIdentifier(Image image) {
        return image.getType() == ImageType.SNAPSHOT && image.getSlug() != null ? image.getSlug() : image.getId().toString();
    }

    static List<Region> getAvailableRegions(String authToken) throws DigitalOceanException, RequestUnsuccessfulException {
        Regions regions;
        DigitalOceanClient client = new DigitalOceanClient(authToken);
        ArrayList<Region> availableRegions = new ArrayList<Region>();
        int page = 0;
        do {
            regions = client.getAvailableRegions(Integer.valueOf(++page));
            availableRegions.addAll(regions.getRegions());
        } while (regions.getMeta().getTotal() > availableRegions.size());
        availableRegions.sort(Comparator.comparing(Region::getName));
        return availableRegions;
    }

    static String buildSizeLabel(Size size) {
        int memory = size.getMemorySizeInMb();
        String memoryUnits = "mb";
        if (memory >= 1024) {
            memory /= 1024;
            memoryUnits = "gb";
        }
        String slug = size.getSlug();
        String type = "Regular";
        if (slug.startsWith("c-")) {
            type = "High CPU";
        } else if (slug.startsWith("m-")) {
            type = "High Memory";
        }
        return String.format("$%s/month ($%s/hour): %d%s RAM, %d CPU, %dgb Disk, %dtb Transfer (%s)", size.getPriceMonthly().toString(), size.getPriceHourly().toString(), memory, memoryUnits, size.getVirutalCpuCount(), size.getDiskSize(), size.getTransfer(), type);
    }

    static List<Key> getAvailableKeys(String authToken) throws RequestUnsuccessfulException, DigitalOceanException {
        Keys keys;
        DigitalOceanClient client = new DigitalOceanClient(authToken);
        ArrayList<Key> availableKeys = new ArrayList<Key>();
        int page = 0;
        do {
            keys = client.getAvailableKeys(Integer.valueOf(++page));
            availableKeys.addAll(keys.getKeys());
        } while (keys.getMeta().getTotal() > availableKeys.size());
        return availableKeys;
    }

    static List<Droplet> getDroplets(String authToken) throws DigitalOceanException, RequestUnsuccessfulException {
        Droplets droplets;
        LOGGER.log(Level.INFO, "Listing all droplets");
        DigitalOceanClient apiClient = new DigitalOceanClient(authToken);
        ArrayList availableDroplets = Lists.newArrayList();
        int page = 0;
        do {
            droplets = apiClient.getAvailableDroplets(Integer.valueOf(++page), Integer.valueOf(Integer.MAX_VALUE));
            availableDroplets.addAll(droplets.getDroplets());
        } while (droplets.getMeta().getTotal() > availableDroplets.size());
        return availableDroplets;
    }

    static Droplet getDroplet(String authToken, Integer dropletId) throws DigitalOceanException, RequestUnsuccessfulException {
        LOGGER.log(Level.INFO, "Fetching droplet " + dropletId);
        return new DigitalOceanClient(authToken).getDropletInfo(dropletId);
    }

    static Image newImage(String idOrSlug) {
        Image image;
        try {
            image = new Image(Integer.valueOf(Integer.parseInt(idOrSlug)));
        }
        catch (NumberFormatException e) {
            image = new Image(idOrSlug);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tryDestroyDropletAsync(String authToken, int dropletId) {
        List<DestroyInfo> list = toBeDestroyedDroplets;
        synchronized (list) {
            LOGGER.info("Adding droplet to destroy " + dropletId);
            toBeDestroyedDroplets.add(new DestroyInfo(authToken, dropletId));
            toBeDestroyedDroplets.sort(Comparator.comparing(o -> o.authToken));
            toBeDestroyedDroplets.notifyAll();
            if (!dropletDestroyer.isAlive()) {
                dropletDestroyer.start();
            }
        }
    }

    private static Comparator<String> ignoringCase() {
        return String::compareToIgnoreCase;
    }

    private static class DestroyInfo {
        public final String authToken;
        public final int dropletId;

        public DestroyInfo(String authToken, int dropletId) {
            this.authToken = authToken;
            this.dropletId = dropletId;
        }
    }
}

