/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.JsonAttribute;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.processor.AttributeInfo;
import com.dslplatform.json.processor.CompiledJsonAnnotationProcessor;
import com.dslplatform.json.processor.Context;
import com.dslplatform.json.processor.EnumTemplate;
import com.dslplatform.json.processor.OptimizedConverter;
import com.dslplatform.json.processor.StructInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

class ConverterTemplate {
    private final Writer code;
    private final Context context;
    private final EnumTemplate enumTemplate;

    ConverterTemplate(Context context, EnumTemplate enumTemplate) {
        this.code = context.code;
        this.context = context;
        this.enumTemplate = enumTemplate;
    }

    private boolean isStaticEnum(AttributeInfo attr) {
        if (!attr.isEnum(this.context.structs)) {
            return false;
        }
        StructInfo target = this.context.structs.get(attr.typeName);
        return target != null && this.enumTemplate.isStatic(target);
    }

    void factoryForGenericConverter(StructInfo si) throws IOException {
        String typeName = si.element.getQualifiedName().toString();
        String producedType = si.formats.contains(CompiledJson.Format.OBJECT) ? (si.formats.contains(CompiledJson.Format.ARRAY) ? "com.dslplatform.json.runtime.FormatDescription" : "ObjectFormatConverter") : "ArrayFormatConverter";
        this.code.append("\tprivate final static class ConverterFactory implements com.dslplatform.json.DslJson.ConverterFactory<");
        this.code.append(producedType);
        this.code.append("> {\n");
        this.code.append("\t\t@Override\n");
        this.code.append("\t\tpublic ").append(producedType).append(" tryCreate(java.lang.reflect.Type manifest, com.dslplatform.json.DslJson __dsljson) {\n");
        this.code.append("\t\t\tif (manifest instanceof java.lang.reflect.ParameterizedType) {\n");
        this.code.append("\t\t\t\tjava.lang.reflect.ParameterizedType pt = (java.lang.reflect.ParameterizedType) manifest;\n");
        this.code.append("\t\t\t\tjava.lang.Class<?> rawClass = (java.lang.Class<?>) pt.getRawType();\n");
        this.code.append("\t\t\t\tif (rawClass.isAssignableFrom(").append(typeName).append(".class)) {\n");
        this.createConverter(si, typeName, "pt.getActualTypeArguments()");
        this.code.append("\t\t\t\t}\n");
        this.code.append("\t\t\t} else if (").append(typeName).append(".class.equals(manifest)) {\n");
        this.code.append("\t\t\t\tjava.lang.reflect.Type[] unknownArgs = new java.lang.reflect.Type[");
        this.code.append(Integer.toString(si.typeParametersNames.size())).append("];\n");
        this.code.append("\t\t\t\tjava.util.Arrays.fill(unknownArgs, Object.class);\n");
        this.code.append("\t\t\t\tif (__dsljson.tryFindReader(Object.class) != null && __dsljson.tryFindWriter(Object.class) != null) {\n");
        this.createConverter(si, typeName, "unknownArgs");
        this.code.append("\t\t\t\t}\n");
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t\treturn null;\n");
        this.code.append("\t\t}\n");
        this.code.append("\t}\n");
    }

    private void createConverter(StructInfo si, String typeName, String typeArguments) throws IOException {
        if (si.formats.contains(CompiledJson.Format.OBJECT)) {
            if (si.formats.contains(CompiledJson.Format.ARRAY)) {
                this.code.append("\t\t\t\t\treturn new com.dslplatform.json.runtime.FormatDescription(\n");
                this.code.append("\t\t\t\t\t\t\t").append(typeName).append(".class,\n");
                this.code.append("\t\t\t\t\t\t\tnew ObjectFormatConverter(__dsljson, ").append(typeArguments).append("),\n");
                this.code.append("\t\t\t\t\t\t\tnew ArrayFormatConverter(__dsljson, ").append(typeArguments).append("),\n");
                this.code.append("\t\t\t\t\t\t\t").append(String.valueOf(si.isObjectFormatFirst)).append(",\n");
                String typeAlias = si.deserializeName.isEmpty() ? typeName : si.deserializeName;
                this.code.append("\t\t\t\t\t\t\t\"").append(typeAlias).append("\",\n");
                this.code.append("\t\t\t\t\t\t\t__dsljson);\n");
            } else {
                this.code.append("\t\t\t\t\treturn new ObjectFormatConverter(__dsljson, ").append(typeArguments).append(");\n");
            }
        } else {
            this.code.append("\t\t\t\t\treturn new ArrayFormatConverter(__dsljson, ").append(typeArguments).append(");\n");
        }
    }

    private void asFormatConverter(StructInfo si, String name, String className, boolean binding) throws IOException {
        String content;
        this.code.append("\tpublic final static class ").append(name);
        if (si.isParameterized) {
            this.code.append('<');
            List<? extends TypeParameterElement> params = si.element.getTypeParameters();
            for (int i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    this.code.append(", ");
                }
                TypeParameterElement tpe = params.get(i);
                this.code.append(tpe.getSimpleName().toString());
                if (tpe.getBounds().isEmpty()) continue;
                this.code.append(" extends ");
                this.code.append(tpe.getBounds().get(0).toString());
                for (int x = 1; x < tpe.getBounds().size(); ++x) {
                    this.code.append(", ");
                    this.code.append(tpe.getBounds().get(x).toString());
                }
            }
            this.code.append('>');
        }
        this.code.append(" implements com.dslplatform.json.runtime.FormatConverter<");
        if (binding) {
            this.code.append(className).append(">, com.dslplatform.json.JsonReader.BindObject<");
        }
        this.code.append(className).append("> {\n");
        this.code.append("\t\tprivate final boolean alwaysSerialize;\n");
        this.code.append("\t\tprivate final com.dslplatform.json.DslJson __dsljson;\n");
        if (si.isParameterized) {
            this.code.append("\t\tprivate final java.lang.reflect.Type[] actualTypes;\n");
        }
        for (AttributeInfo attr : si.attributes.values()) {
            OptimizedConverter converter = this.context.inlinedConverters.get(attr.typeName);
            StructInfo target = this.context.structs.get(attr.typeName);
            if (!(attr.converter != null || target != null && target.converter != null || converter != null || this.isStaticEnum(attr) || attr.isJsonObject)) {
                List types = attr.collectionContent(this.context.typeSupport, this.context.structs);
                if (target != null && attr.isEnum(this.context.structs)) {
                    this.code.append("\t\tprivate final ").append(CompiledJsonAnnotationProcessor.findConverterName(target)).append(".EnumConverter converter_").append(attr.name).append(";\n");
                } else if (types != null && types.size() == 1 || attr.isGeneric && !attr.containsStructOwnerType) {
                    TypeMirror mirror;
                    content = this.extractSingleType(attr, types);
                    TypeMirror typeMirror = mirror = this.context.useLazyResolution(content) ? this.context.findType(content) : null;
                    if (mirror != null) {
                        this.createLazyReaderAndWriter(attr, mirror, "", si);
                    } else {
                        this.code.append("\t\tprivate final com.dslplatform.json.JsonReader.ReadObject<").append(content).append("> reader_").append(attr.name).append(";\n");
                        this.code.append("\t\tprivate final com.dslplatform.json.JsonWriter.WriteObject<").append(content).append("> writer_").append(attr.name).append(";\n");
                    }
                } else if (types != null && types.size() == 2) {
                    TypeMirror valueMirror;
                    TypeMirror keyMirror;
                    TypeMirror typeMirror = keyMirror = this.context.useLazyResolution((String)types.get(0)) ? this.context.findType((String)types.get(0)) : null;
                    if (keyMirror != null) {
                        this.createLazyReaderAndWriter(attr, keyMirror, "key_", si);
                    } else {
                        this.code.append("\t\tprivate final com.dslplatform.json.JsonReader.ReadObject<").append((CharSequence)types.get(0)).append("> key_reader_").append(attr.name).append(";\n");
                        this.code.append("\t\tprivate final com.dslplatform.json.JsonWriter.WriteObject<").append((CharSequence)types.get(0)).append("> key_writer_").append(attr.name).append(";\n");
                    }
                    TypeMirror typeMirror2 = valueMirror = this.context.useLazyResolution((String)types.get(1)) ? this.context.findType((String)types.get(1)) : null;
                    if (valueMirror != null) {
                        this.createLazyReaderAndWriter(attr, valueMirror, "value_", si);
                    } else {
                        this.code.append("\t\tprivate final com.dslplatform.json.JsonReader.ReadObject<").append((CharSequence)types.get(1)).append("> value_reader_").append(attr.name).append(";\n");
                        this.code.append("\t\tprivate final com.dslplatform.json.JsonWriter.WriteObject<").append((CharSequence)types.get(1)).append("> value_writer_").append(attr.name).append(";\n");
                    }
                } else {
                    this.createLazyReaderAndWriter(attr, attr.type, "", si);
                }
                if (!attr.isArray) continue;
                content = Context.extractRawType(((ArrayType)attr.type).getComponentType(), si.genericSignatures);
                this.code.append("\t\tprivate final ").append(content).append("[] emptyArray_").append(attr.name).append(";\n");
                continue;
            }
            if (converter == null || !attr.isArray || !attr.notNull) continue;
            if (converter.defaultValue != null) {
                this.code.append("\t\tprivate static final ").append(attr.typeName).append(" emptyArray_").append(attr.name);
                this.code.append(" = ").append(converter.defaultValue).append(";\n");
                continue;
            }
            String content2 = Context.extractRawType(((ArrayType)attr.type).getComponentType(), si.genericSignatures);
            this.code.append("\t\tprivate final ").append(content2).append("[] emptyArray_").append(attr.name).append(";\n");
        }
        this.code.append("\t\tpublic ").append(name).append("(com.dslplatform.json.DslJson __dsljson");
        if (si.isParameterized) {
            this.code.append(", java.lang.reflect.Type[] actualTypes");
        }
        this.code.append(") {\n");
        switch (si.objectFormatPolicy) {
            case DEFAULT: 
            case EXPLICIT: {
                this.code.append("\t\t\tthis.alwaysSerialize = !__dsljson.omitDefaults;\n");
                break;
            }
            case MINIMAL: {
                this.code.append("\t\t\tthis.alwaysSerialize = false;\n");
                break;
            }
            case FULL: {
                this.code.append("\t\t\tthis.alwaysSerialize = true;\n");
            }
        }
        this.code.append("\t\t\tthis.__dsljson = __dsljson;\n");
        if (si.isParameterized) {
            this.code.append("\t\t\tthis.actualTypes = actualTypes;\n");
        }
        for (AttributeInfo attr : si.attributes.values()) {
            boolean hasConverter = this.context.inlinedConverters.containsKey(attr.typeName);
            List types = attr.collectionContent(this.context.typeSupport, this.context.structs);
            StructInfo target = this.context.structs.get(attr.typeName);
            if (attr.converter != null || target != null && target.converter != null || hasConverter || this.isStaticEnum(attr) || attr.isJsonObject) continue;
            if (target != null && attr.isEnum(this.context.structs)) {
                this.code.append("\t\t\tthis.converter_").append(attr.name).append(" = new ").append(CompiledJsonAnnotationProcessor.findConverterName(target)).append(".EnumConverter(__dsljson);\n");
            } else if (types != null && types.size() == 1) {
                content = (String)types.get(0);
                OptimizedConverter converter = this.context.inlinedConverters.get(content);
                if (converter != null) {
                    this.code.append("\t\t\tthis.reader_").append(attr.name).append(" = ").append(converter.decoderField).append(";\n");
                    this.code.append("\t\t\tthis.writer_").append(attr.name).append(" = ").append(converter.encoderField).append(";\n");
                } else if (!this.context.useLazyResolution(content)) {
                    String type = Context.typeOrClass(Context.nonGenericObject(content), content);
                    this.code.append("\t\t\tthis.reader_").append(attr.name).append(" = __dsljson.tryFindReader(").append(type).append(");\n");
                    this.code.append("\t\t\tthis.writer_").append(attr.name).append(" = __dsljson.tryFindWriter(").append(type).append(");\n");
                }
            } else if (types != null && types.size() == 2) {
                OptimizedConverter converterKey = this.context.inlinedConverters.get(types.get(0));
                if (converterKey != null) {
                    this.code.append("\t\t\tthis.key_reader_").append(attr.name).append(" = ").append(converterKey.decoderField).append(";\n");
                    this.code.append("\t\t\tthis.key_writer_").append(attr.name).append(" = ").append(converterKey.encoderField).append(";\n");
                } else if (!this.context.useLazyResolution((String)types.get(0))) {
                    String typeKey = Context.typeOrClass(Context.nonGenericObject((String)types.get(0)), (String)types.get(0));
                    this.code.append("\t\t\tthis.key_reader_").append(attr.name).append(" = __dsljson.tryFindReader(").append(typeKey).append(");\n");
                    this.code.append("\t\t\tthis.key_writer_").append(attr.name).append(" = __dsljson.tryFindWriter(").append(typeKey).append(");\n");
                }
                OptimizedConverter converterValue = this.context.inlinedConverters.get(types.get(1));
                if (converterValue != null) {
                    this.code.append("\t\t\tthis.value_reader_").append(attr.name).append(" = ").append(converterValue.decoderField).append(";\n");
                    this.code.append("\t\t\tthis.value_writer_").append(attr.name).append(" = ").append(converterValue.encoderField).append(";\n");
                } else if (!this.context.useLazyResolution((String)types.get(1))) {
                    String typeValue = Context.typeOrClass(Context.nonGenericObject((String)types.get(1)), (String)types.get(1));
                    this.code.append("\t\t\tthis.value_reader_").append(attr.name).append(" = __dsljson.tryFindReader(").append(typeValue).append(");\n");
                    this.code.append("\t\t\tthis.value_writer_").append(attr.name).append(" = __dsljson.tryFindWriter(").append(typeValue).append(");\n");
                }
            } else if (attr.isGeneric && !attr.containsStructOwnerType) {
                String type = attr.isArray ? this.createTypeSignature(((ArrayType)attr.type).getComponentType(), attr.typeVariablesIndex, si.genericSignatures) : this.createTypeSignature(attr.type, attr.typeVariablesIndex, si.genericSignatures);
                this.code.append("\t\t\tjava.lang.reflect.Type manifest_").append(attr.name).append(" = ").append(type).append(";\n");
                this.code.append("\t\t\tthis.reader_").append(attr.name).append(" = __dsljson.tryFindReader(manifest_").append(attr.name).append(");\n");
                this.code.append("\t\t\tif (reader_").append(attr.name).append(" == null) {\n");
                this.code.append("\t\t\t\tthrow new com.dslplatform.json.ConfigurationException(\"Unable to find reader for \" + manifest_").append(attr.name);
                this.code.append(" + \". Enable runtime conversion by initializing DslJson with new DslJson<>(Settings.withRuntime().includeServiceLoader())\");\n");
                this.code.append("\t\t\t}\n");
                this.code.append("\t\t\tthis.writer_").append(attr.name).append(" = __dsljson.tryFindWriter(manifest_").append(attr.name).append(");\n");
                this.code.append("\t\t\tif (writer_").append(attr.name).append(" == null) {\n");
                this.code.append("\t\t\t\tthrow new com.dslplatform.json.ConfigurationException(\"Unable to find writer for \" + manifest_").append(attr.name);
                this.code.append(" + \". Enable runtime conversion by initializing DslJson with new DslJson<>(Settings.withRuntime().includeServiceLoader())\");\n");
                this.code.append("\t\t\t}\n");
            }
            if (!attr.isArray) continue;
            TypeMirror arrayComponentType = ((ArrayType)attr.type).getComponentType();
            this.code.append("\t\t\tthis.emptyArray_").append(attr.name).append(" = ");
            String content3 = Context.extractRawType(arrayComponentType, si.genericSignatures);
            this.code.append("(").append(content3).append("[]) java.lang.reflect.Array.newInstance((Class<?>) ");
            this.buildArrayType(arrayComponentType, attr.typeVariablesIndex, si.genericSignatures);
            this.code.append(", 0);\n");
        }
        this.code.append("\t\t}\n");
        if (binding) {
            this.code.append("\t\tpublic ").append(className).append(" read(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
            this.code.append("\t\t\tif (reader.wasNull()) return null;\n");
            this.code.append("\t\t\treturn bind(reader, ");
            if (si.annotatedFactory != null) {
                this.code.append(si.annotatedFactory.getEnclosingElement().toString()).append(".").append(si.annotatedFactory.getSimpleName()).append("());\n");
            } else {
                this.code.append("new ").append(className).append("());\n");
            }
            this.code.append("\t\t}\n");
        }
    }

    private String extractTypeSignature(AttributeInfo attr, TypeMirror type, Map<String, TypeMirror> genericSignatures) {
        if (attr.isGeneric || !attr.usedTypes.isEmpty()) {
            return this.createTypeSignature(type, attr.typeVariablesIndex, genericSignatures);
        }
        String typeName = AttributeInfo.stripAnnotations((String)type.toString());
        return Context.typeOrClass(Context.nonGenericObject(typeName), typeName);
    }

    private String extractSingleType(AttributeInfo attr, @Nullable List<String> types) {
        if (types == null || attr.isGeneric) {
            if (attr.isArray) {
                return ((ArrayType)attr.type).getComponentType().toString();
            }
            return attr.typeName;
        }
        return types.get(0);
    }

    private void createLazyReaderAndWriter(AttributeInfo attr, TypeMirror mirror, String namePrefix, StructInfo si) throws IOException {
        String type = this.extractTypeSignature(attr, mirror, si.genericSignatures);
        String typeName = attr.buildTypeName(mirror, si.genericSignatures);
        this.code.append("\t\tprivate com.dslplatform.json.JsonReader.ReadObject<").append(typeName).append("> ").append(namePrefix).append("reader_").append(attr.name).append(";\n");
        this.code.append("\t\tprivate com.dslplatform.json.JsonReader.ReadObject<").append(typeName).append("> ").append(namePrefix).append("reader_").append(attr.name).append("() {\n");
        this.code.append("\t\t\tif (").append(namePrefix).append("reader_").append(attr.name).append(" == null) {\n");
        this.code.append("\t\t\t\tjava.lang.reflect.Type manifest = ").append(type).append(";\n");
        this.code.append("\t\t\t\t").append(namePrefix).append("reader_").append(attr.name).append(" = __dsljson.tryFindReader(manifest);\n");
        this.code.append("\t\t\t\tif (").append(namePrefix).append("reader_").append(attr.name).append(" == null) {\n");
        this.code.append("\t\t\t\t\tthrow new com.dslplatform.json.ConfigurationException(\"Unable to find reader for \" + manifest + \". Enable runtime conversion by initializing DslJson with new DslJson<>(Settings.basicSetup())\");\n");
        this.code.append("\t\t\t\t}\n");
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t\treturn ").append(namePrefix).append("reader_").append(attr.name).append(";\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tprivate com.dslplatform.json.JsonWriter.WriteObject<").append(typeName).append("> ").append(namePrefix).append("writer_").append(attr.name).append(";\n");
        this.code.append("\t\tprivate com.dslplatform.json.JsonWriter.WriteObject<").append(typeName).append("> ").append(namePrefix).append("writer_").append(attr.name).append("() {\n");
        this.code.append("\t\t\tif (").append(namePrefix).append("writer_").append(attr.name).append(" == null) {\n");
        this.code.append("\t\t\t\tjava.lang.reflect.Type manifest = ").append(type).append(";\n");
        this.code.append("\t\t\t\t").append(namePrefix).append("writer_").append(attr.name).append(" = __dsljson.tryFindWriter(manifest);\n");
        this.code.append("\t\t\t\tif (").append(namePrefix).append("writer_").append(attr.name).append(" == null) {\n");
        this.code.append("\t\t\t\t\tthrow new com.dslplatform.json.ConfigurationException(\"Unable to find writer for \" + manifest + \". Enable runtime conversion by initializing DslJson with new DslJson<>(Settings.basicSetup())\");\n");
        this.code.append("\t\t\t\t}\n");
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t\treturn ").append(namePrefix).append("writer_").append(attr.name).append(";\n");
        this.code.append("\t\t}\n");
    }

    private String createTypeSignature(TypeMirror type, Map<String, Integer> typeVariableIndexes, Map<String, TypeMirror> genericSignatures) {
        StringBuilder builder = new StringBuilder();
        this.createTypeSignature(type, typeVariableIndexes, genericSignatures, builder);
        return builder.toString();
    }

    private void createTypeSignature(TypeMirror type, Map<String, Integer> typeVariableIndexes, Map<String, TypeMirror> genericSignatures, StringBuilder builder) {
        Integer index;
        String typeName = AttributeInfo.stripAnnotations((String)type.toString());
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            if (declaredType.getTypeArguments().isEmpty()) {
                builder.append(typeName).append(".class");
            } else {
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                builder.append("com.dslplatform.json.runtime.Generics.makeParameterizedType(").append(typeElement.getQualifiedName()).append(".class");
                for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                    builder.append(", ");
                    this.createTypeSignature(typeMirror, typeVariableIndexes, genericSignatures, builder);
                }
                builder.append(")");
            }
            return;
        }
        if (type.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            builder.append("com.dslplatform.json.runtime.Generics.makeArrayType(");
            this.createTypeSignature(arrayType.getComponentType(), typeVariableIndexes, genericSignatures, builder);
            builder.append(")");
            return;
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            this.createTypeSignature(wt.getExtendsBound(), typeVariableIndexes, genericSignatures, builder);
            return;
        }
        if (typeVariableIndexes.containsKey(type.toString()) && (index = typeVariableIndexes.get(type.toString())) != null && index >= 0) {
            builder.append("actualTypes[").append(index).append("]");
            return;
        }
        if (type instanceof TypeVariable) {
            if (typeVariableIndexes.containsKey(typeName) && (index = typeVariableIndexes.get(typeName)) != null && index >= 0) {
                builder.append("actualTypes[").append(index).append("]");
                return;
            }
            TypeMirror mirror = genericSignatures.get(typeName);
            if (mirror != null && mirror != type) {
                this.createTypeSignature(mirror, typeVariableIndexes, genericSignatures, builder);
                return;
            }
        }
        builder.append(typeName).append(".class");
    }

    private void buildArrayType(TypeMirror type, Map<String, Integer> typeVariableIndexes, Map<String, TypeMirror> genericSignatures) throws IOException {
        Integer index;
        String typeName = AttributeInfo.stripAnnotations((String)type.toString());
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            if (declaredType.getTypeArguments().isEmpty()) {
                this.code.append(typeName);
            } else {
                int first = typeName.indexOf(60);
                this.code.append(typeName, 0, first);
            }
            this.code.append(".class");
            return;
        }
        if (type.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            this.code.append("com.dslplatform.json.runtime.Generics.makeArrayType(");
            this.buildArrayType(arrayType.getComponentType(), typeVariableIndexes, genericSignatures);
            this.code.append(")");
            return;
        }
        if (typeVariableIndexes.containsKey(type.toString()) && (index = typeVariableIndexes.get(type.toString())) != null && index >= 0) {
            this.code.append("actualTypes[").append(Integer.toString(index)).append("]");
            return;
        }
        if (type instanceof TypeVariable) {
            if (typeVariableIndexes.containsKey(typeName) && (index = typeVariableIndexes.get(typeName)) != null && index >= 0) {
                this.code.append("actualTypes[").append(Integer.toString(index)).append("]");
                return;
            }
            TypeMirror mirror = genericSignatures.get(typeName);
            if (mirror != null) {
                this.buildArrayType(mirror, typeVariableIndexes, genericSignatures);
                return;
            }
        }
        this.code.append(typeName).append(".class");
    }

    void emptyObject(StructInfo si, String className) throws IOException {
        int i;
        this.asFormatConverter(si, "ObjectFormatConverter", className, true);
        List<AttributeInfo> sortedAttributes = Context.sortedAttributes(si, true);
        this.writeObject(si, className, sortedAttributes);
        this.code.append("\t\tpublic ").append(className).append(" bind(final com.dslplatform.json.JsonReader reader, final ");
        this.code.append(className).append(" instance) throws java.io.IOException {\n");
        this.code.append("\t\t\tif (reader.last() != '{') throw reader.newParseError(\"Expecting '{' for object start\");\n");
        this.code.append("\t\t\treader.getNextToken();\n");
        this.code.append("\t\t\tbindContent(reader, instance);\n");
        this.code.append("\t\t\treturn instance;\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic ").append(className).append(" readContent(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
        this.code.append("\t\t\t").append(className).append(" instance = ");
        if (si.annotatedFactory != null) {
            this.code.append(si.annotatedFactory.getEnclosingElement().toString()).append(".").append(si.annotatedFactory.getSimpleName()).append("();\n ");
        } else {
            this.code.append("new ").append(className).append("();\n ");
        }
        this.code.append("\t\t\tbindContent(reader, instance);\n");
        this.code.append("\t\t\treturn instance;\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic void bindContent(final com.dslplatform.json.JsonReader reader, final ");
        this.code.append(className).append(" instance) throws java.io.IOException {\n");
        this.code.append("\t\t\tif (reader.last() == '}')");
        this.checkMandatory(sortedAttributes, 0);
        for (i = 0; i < sortedAttributes.size(); ++i) {
            AttributeInfo attr = sortedAttributes.get(i);
            if (!attr.canReadInput()) continue;
            String mn = (String)si.minifiedNames.get(attr.id);
            if (i > 0) {
                this.code.append("\t\t\tif (reader.getNextToken() == '}') ");
                this.checkMandatory(sortedAttributes, i);
                this.code.append("\t\t\tif (reader.last() != ',') throw reader.newParseError(\"Expecting ',' for other mandatory properties\"); else reader.getNextToken();\n");
            }
            this.code.append("\t\t\tif (reader.fillNameWeakHash() != ").append(Integer.toString(ConverterTemplate.calcWeakHash(mn != null ? mn : attr.id)));
            this.code.append(" || !reader.wasLastName(name_").append(attr.name).append(")) { bindSlow(reader, instance, ");
            this.code.append(Integer.toString(i)).append("); return; }\n");
            this.code.append("\t\t\treader.getNextToken();\n");
            this.processPropertyValue(attr, "\t", true, si.genericSignatures);
        }
        if (si.onUnknown == CompiledJson.Behavior.FAIL) {
            if (si.discriminator.length() > 0 && !si.attributes.containsKey(si.discriminator)) {
                this.code.append("\t\t\tif (reader.getNextToken() == '}') return;\n");
                if (si.attributes.isEmpty()) {
                    this.code.append("\t\t\tif (reader.last() == '\"') {\n");
                } else {
                    this.code.append("\t\t\tif (reader.last() == ',') {\n");
                    this.code.append("\t\t\t\treader.getNextToken();\n");
                }
                this.code.append("\t\t\t\treader.fillNameWeakHash();\n");
                this.code.append("\t\t\t\tbindSlow(reader, instance, ").append(Integer.toString(sortedAttributes.size())).append(");\n");
                this.code.append("\t\t\t\treturn;\n");
                this.code.append("\t\t\t}\n");
                this.code.append("\t\t\tthrow reader.newParseError(\"Expecting '}' for object end since unknown properties are not allowed on ");
                this.code.append(className).append("\");\n");
            } else {
                this.code.append("\t\t\tif (reader.getNextToken() != '}') throw reader.newParseError(\"Expecting '}' for object end since unknown properties are not allowed on ");
                this.code.append(className).append("\");\n");
            }
        } else {
            boolean hasProperties;
            boolean hasDiscriminator = si.discriminator.length() > 0 && !si.attributes.containsKey(si.discriminator) && si.attributes.isEmpty();
            boolean bl = hasProperties = !si.attributes.isEmpty();
            if (hasDiscriminator) {
                this.code.append("\t\t\tif (reader.last() == '\"') {\n");
            } else if (hasProperties) {
                this.code.append("\t\t\tif (reader.getNextToken() != '}') {\n");
                this.code.append("\t\t\t\tif (reader.last() == ',') {\n");
                this.code.append("\t\t\t\t\treader.getNextToken();\n");
            } else {
                this.code.append("\t\t\tif (reader.last() != '\"') throw reader.newParseError(\"Expecting '}' for object end or '\\\"' for attribute start\");\n");
                this.code.append("\t\t\treader.fillNameWeakHash();\n");
                this.code.append("\t\t\tbindSlow(reader, instance, 0);\n");
            }
            if (hasDiscriminator || hasProperties) {
                this.code.append("\t\t\t\t\treader.fillNameWeakHash();\n");
                this.code.append("\t\t\t\t\tbindSlow(reader, instance, ").append(Integer.toString(sortedAttributes.size())).append(");\n");
                this.code.append("\t\t\t\t}\n");
                this.code.append("\t\t\t\tif (reader.last() != '}') throw reader.newParseError(\"Expecting '}' for object end\");\n");
                if (!hasDiscriminator) {
                    this.code.append("\t\t\t}\n");
                }
            }
        }
        this.code.append("\t\t}\n");
        this.code.append("\t\tprivate void bindSlow(final com.dslplatform.json.JsonReader reader, final ");
        this.code.append(className).append(" instance, int index) throws java.io.IOException {\n");
        for (i = 0; i < sortedAttributes.size(); ++i) {
            AttributeInfo attr = sortedAttributes.get(i);
            if (!attr.canReadInput()) continue;
            boolean nonPrimitive = attr.typeName.equals(Analysis.objectName((String)attr.typeName));
            if (!attr.mandatory && (!attr.notNull || !nonPrimitive)) continue;
            this.code.append("\t\t\tboolean __detected_").append(attr.name).append("__ = index > ").append(Integer.toString(i)).append(";\n");
        }
        this.code.append("\t\t\tswitch(reader.getLastHash()) {\n");
        this.handleSwitch(si, "\t\t\t", true);
        this.code.append("\t\t\t}\n");
        if (sortedAttributes.isEmpty()) {
            this.code.append("\t\t}\n");
            this.code.append("\t}\n");
            return;
        }
        this.code.append("\t\t\twhile (reader.last() == ','){\n");
        this.code.append("\t\t\t\treader.getNextToken();\n");
        this.code.append("\t\t\t\tswitch(reader.fillName()) {\n");
        this.handleSwitch(si, "\t\t\t\t", true);
        this.code.append("\t\t\t\t}\n");
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t\tif (reader.last() != '}') throw reader.newParseError(\"Expecting '}' for object end\");\n");
        for (AttributeInfo attr : sortedAttributes) {
            if (!attr.canReadInput()) continue;
            boolean nonPrimitive = attr.typeName.equals(Analysis.objectName((String)attr.typeName));
            String defaultValue = this.context.getDefault(attr);
            if (attr.isArray && attr.notNull) {
                defaultValue = "emptyArray_" + attr.name;
            }
            if (attr.mandatory || attr.notNull && nonPrimitive && "null".equals(defaultValue)) {
                this.code.append("\t\t\tif (!__detected_").append(attr.name).append("__) throw reader.newParseErrorAt(\"Property '");
                this.code.append(attr.name).append("' is ");
                if (attr.mandatory) {
                    this.code.append("mandatory");
                } else {
                    this.code.append("not-nullable and doesn't have a default");
                }
                this.code.append(" but was not found in JSON\", 0);\n");
                continue;
            }
            if (!attr.notNull || !nonPrimitive || attr.field == null && attr.writeMethod == null) continue;
            this.code.append("\t\t\tif (!__detected_").append(attr.name).append("__ && instance.");
            this.code.append(attr.readProperty).append(" == null) {\n");
            this.code.append("\t\t\t\tinstance.");
            if (attr.field != null) {
                this.code.append(attr.field.getSimpleName()).append(" = ").append(defaultValue).append(";\n");
            } else {
                this.code.append(attr.writeMethod.getSimpleName()).append("(").append(defaultValue).append(");\n");
            }
            this.code.append("\t\t\t}\n");
        }
        this.code.append("\t\t}\n");
        this.code.append("\t}\n");
    }

    void fromObject(StructInfo si, String className) throws IOException {
        this.asFormatConverter(si, "ObjectFormatConverter", className, false);
        this.writeObject(si, className, Context.sortedAttributes(si, true));
        List<AttributeInfo> sortedAttributes = Context.sortedAttributes(si, false);
        this.code.append("\t\tpublic ").append(className).append(" read(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
        this.code.append("\t\t\tif (reader.wasNull()) return null;\n");
        this.code.append("\t\t\telse if (reader.last() != '{') throw reader.newParseError(\"Expecting '{' for object start\");\n");
        this.code.append("\t\t\treader.getNextToken();\n");
        this.code.append("\t\t\treturn readContent(reader);\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic ").append(className).append(" readContent(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
        for (AttributeInfo attr : sortedAttributes) {
            this.code.append("\t\t\t").append(attr.typeName).append(" _").append(attr.name).append("_ = ");
            boolean nonPrimitive = attr.typeName.equals(Analysis.objectName((String)attr.typeName));
            String defaultValue = this.context.getDefault(attr);
            if (attr.isArray && attr.notNull) {
                this.code.append("emptyArray_").append(attr.name);
            } else if (this.context.isObjectInstance(attr)) {
                this.code.append("null");
            } else {
                this.code.append(this.context.getDefault(attr));
            }
            this.code.append(";\n");
            if (!attr.mandatory && (!attr.notNull || !nonPrimitive || !"null".equals(defaultValue) && !this.context.isObjectInstance(attr))) continue;
            this.code.append("\t\t\tboolean __detected_").append(attr.name).append("__ = false;\n");
        }
        this.code.append("\t\t\tif (reader.last() == '}') {\n");
        this.checkMandatory(sortedAttributes, "\t\t\t\t");
        this.returnInstance("\t\t\t\t", si, className);
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t\tswitch(reader.fillName()) {\n");
        this.handleSwitch(si, "\t\t\t", false);
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t\twhile (reader.last() == ','){\n");
        this.code.append("\t\t\t\treader.getNextToken();\n");
        this.code.append("\t\t\t\tswitch(reader.fillName()) {\n");
        this.handleSwitch(si, "\t\t\t\t", false);
        this.code.append("\t\t\t\t}\n");
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t\tif (reader.last() != '}') throw reader.newParseError(\"Expecting '}' for object end\");\n");
        this.checkMandatory(sortedAttributes, "\t\t\t");
        this.returnInstance("\t\t\t", si, className);
        this.code.append("\t\t}\n");
        this.code.append("\t}\n");
    }

    private void writeDiscriminator(StructInfo si) throws IOException {
        String name = si.deserializeName.isEmpty() ? si.binaryName.replace('$', '.') : si.deserializeName;
        this.code.append("\t\t\t\twriter.writeAscii(\"\\\"").append(si.discriminator).append("\\\":\\\"").append(name).append("\\\"");
        if (!si.attributes.isEmpty()) {
            this.code.append(",");
        }
        this.code.append("\");\n");
    }

    private void writeObject(StructInfo si, String className, List<AttributeInfo> sortedAttributes) throws IOException {
        boolean isFirst = true;
        for (AttributeInfo attr : sortedAttributes) {
            if (!attr.canWriteOutput()) continue;
            String prefix = isFirst ? "" : ",";
            isFirst = false;
            this.code.append("\t\tprivate static final byte[] quoted_").append(attr.name).append(" = \"").append(prefix);
            this.code.append("\\\"").append(attr.id).append("\\\":\".getBytes(utf8);\n");
            this.code.append("\t\tprivate static final byte[] name_").append(attr.name).append(" = \"").append(attr.id).append("\".getBytes(utf8);\n");
        }
        this.code.append("\t\tpublic final void write(final com.dslplatform.json.JsonWriter writer, final ");
        this.code.append(className).append(" instance) {\n");
        this.code.append("\t\t\tif (instance == null) writer.writeNull();\n");
        this.code.append("\t\t\telse {\n");
        this.code.append("\t\t\t\twriter.writeByte((byte)'{');\n");
        if (si.discriminator.length() > 0 && !si.attributes.containsKey(si.discriminator)) {
            this.writeDiscriminator(si);
            if (!si.attributes.isEmpty()) {
                this.code.append("\t\t\t\tif (alwaysSerialize) { writeContentFull(writer, instance); writer.writeByte((byte)'}'); }\n");
                this.code.append("\t\t\t\telse { writeContentMinimal(writer, instance); writer.getByteBuffer()[writer.size() - 1] = '}'; }\n");
            } else {
                this.code.append("\t\t\t\twriter.writeByte((byte)'}');\n");
            }
        } else {
            this.code.append("\t\t\t\tif (alwaysSerialize) { writeContentFull(writer, instance); writer.writeByte((byte)'}'); }\n");
            this.code.append("\t\t\t\telse if (writeContentMinimal(writer, instance)) writer.getByteBuffer()[writer.size() - 1] = '}';\n");
            this.code.append("\t\t\t\telse writer.writeByte((byte)'}');\n");
        }
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic void writeContentFull(final com.dslplatform.json.JsonWriter writer, final ");
        this.code.append(className).append(" instance) {\n");
        for (AttributeInfo attr : sortedAttributes) {
            if (!attr.canWriteOutput()) continue;
            this.code.append("\t\t\twriter.writeAscii(quoted_").append(attr.name).append(");\n");
            this.writeProperty(attr, false, "\t\t\t");
        }
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic boolean writeContentMinimal(final com.dslplatform.json.JsonWriter writer, final ");
        this.code.append(className).append(" instance) {\n");
        this.code.append("\t\t\tboolean hasWritten = false;\n");
        for (AttributeInfo attr : sortedAttributes) {
            if (!attr.canWriteOutput()) continue;
            String defaultValue = this.context.getDefault(attr);
            boolean checkDefaults = attr.includeToMinimal != JsonAttribute.IncludePolicy.ALWAYS;
            boolean isPrimitive = !attr.typeName.equals(Analysis.objectName((String)attr.typeName));
            String readValue = "instance." + attr.readProperty;
            if (checkDefaults) {
                this.code.append("\t\t\tif (");
                if ("null".equals(defaultValue) || isPrimitive) {
                    this.code.append(readValue).append(" != ").append(defaultValue);
                } else if (attr.notNull && attr.isArray) {
                    this.code.append(readValue).append(" != null && ").append(readValue).append(".length != 0");
                } else if (attr.notNull && (attr.isList || attr.isSet || attr.isMap)) {
                    this.code.append(readValue).append(" != null && !").append(readValue).append(".isEmpty()");
                } else {
                    StructInfo target = this.context.structs.get(attr.typeName);
                    if (target != null && (target.hasEmptyCtor() || target.hasKnownConversion() || target.annotatedFactory != null)) {
                        this.code.append(readValue).append(" != null");
                    } else {
                        this.code.append(readValue).append(" != null && !").append(defaultValue).append(".equals(").append(readValue).append(")");
                    }
                }
                this.code.append(") {\n");
            }
            String alignment = checkDefaults ? "\t\t\t\t" : "\t\t\t";
            this.code.append(alignment).append("writer.writeByte((byte)'\"'); writer.writeAscii(name_").append(attr.name).append("); writer.writeByte((byte)'\"'); writer.writeByte((byte)':');\n");
            this.writeProperty(attr, checkDefaults, alignment);
            this.code.append(alignment).append("writer.writeByte((byte)','); hasWritten = true;\n");
            if (!checkDefaults) continue;
            this.code.append("\t\t\t}");
            if (attr.notNull && !isPrimitive) {
                this.code.append(" else ");
                if (!"null".equals(defaultValue) || attr.isArray || attr.isList || attr.isSet || attr.isMap) {
                    this.code.append("if (").append(readValue).append(" == null) ");
                }
                this.code.append("throw new com.dslplatform.json.ConfigurationException(\"Property '");
                this.code.append(attr.name).append("' is not allowed to be null\");\n");
                continue;
            }
            this.code.append("\n");
        }
        this.code.append("\t\t\treturn hasWritten;\n");
        this.code.append("\t\t}\n");
    }

    private void checkMandatory(List<AttributeInfo> attributes, int start) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < attributes.size(); ++i) {
            AttributeInfo attr = attributes.get(i);
            if (!attr.canReadInput()) continue;
            boolean nonPrimitive = attr.typeName.equals(Analysis.objectName((String)attr.typeName));
            String defaultValue = this.context.getDefault(attr);
            if (attr.mandatory || attr.notNull && nonPrimitive && "null".equals(defaultValue)) {
                int length = sb.length();
                if (!attr.mandatory) {
                    sb.append("\t\t\t\tif (instance.").append(attr.readProperty).append(" == null)");
                }
                sb.append(" throw reader.newParseErrorAt(\"Property '").append(attr.name).append("' is ");
                if (attr.mandatory) {
                    sb.append("mandatory");
                } else {
                    sb.append("not-nullable and doesn't have a default");
                }
                sb.append(" but was not found in JSON\", 0);\n");
                if (!attr.mandatory) continue;
                if (length != 0) {
                    this.code.append(" { \n");
                }
                this.code.append(sb.toString());
                if (length != 0) {
                    this.code.append(" } ");
                }
                return;
            }
            if (!attr.notNull || !nonPrimitive) continue;
            if (attr.isArray) {
                defaultValue = "emptyArray_" + attr.name;
            }
            if ("null".equals(defaultValue) || attr.field == null && attr.writeMethod == null) continue;
            sb.append("\t\t\t\tif (instance.").append(attr.readProperty).append(" == null) instance.");
            if (attr.field != null) {
                sb.append(attr.field.getSimpleName()).append(" = ").append(defaultValue).append(";\n");
                continue;
            }
            sb.append(attr.writeMethod.getSimpleName()).append("(").append(defaultValue).append(");\n");
        }
        if (sb.length() > 0) {
            this.code.append(" {\n");
            this.code.append(sb.toString());
            this.code.append("\t\t\t\treturn;\n\t\t\t}\n");
        } else {
            this.code.append(" return;\n");
        }
    }

    private void checkMandatory(List<AttributeInfo> attributes, String padding) throws IOException {
        for (AttributeInfo attr : attributes) {
            if (!attr.canReadInput()) continue;
            boolean nonPrimitive = attr.typeName.equals(Analysis.objectName((String)attr.typeName));
            String defaultValue = this.context.getDefault(attr);
            if (!attr.mandatory && (!attr.notNull || !nonPrimitive || !"null".equals(defaultValue) && !this.context.isObjectInstance(attr))) continue;
            this.code.append(padding).append("if (!__detected_").append(attr.name).append("__) throw reader.newParseErrorAt(\"Property '");
            this.code.append(attr.name).append("' is ");
            if (attr.mandatory) {
                this.code.append("mandatory");
            } else {
                this.code.append("not-nullable and doesn't have a default");
            }
            this.code.append(" but was not found in JSON\", 0);\n");
        }
    }

    void emptyArray(StructInfo si, String className) throws IOException {
        this.asFormatConverter(si, "ArrayFormatConverter", className, true);
        List<AttributeInfo> sortedAttributes = Context.sortedAttributes(si, true);
        this.writeArray(className, sortedAttributes);
        this.code.append("\t\tpublic ").append(className).append(" readContent(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
        this.code.append("\t\t\t").append(className).append(" instance = ");
        if (si.annotatedFactory != null) {
            this.code.append(si.annotatedFactory.getEnclosingElement().toString()).append(".").append(si.annotatedFactory.getSimpleName()).append("();\n ");
        } else {
            this.code.append("new ").append(className).append("();\n ");
        }
        this.code.append("\t\t\tbind(reader, instance);\n");
        this.code.append("\t\t\treturn instance;\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic ").append(className).append(" bind(final com.dslplatform.json.JsonReader reader, final ");
        this.code.append(className).append(" instance) throws java.io.IOException {\n");
        this.code.append("\t\t\tif (reader.last() != '[') throw reader.newParseError(\"Expecting '[' for object start\");\n");
        int i = sortedAttributes.size();
        for (AttributeInfo attr : sortedAttributes) {
            this.code.append("\t\t\treader.getNextToken();\n");
            this.processPropertyValue(attr, "\t", true, si.genericSignatures);
            if (--i <= 0) continue;
            this.code.append("\t\t\tif (reader.getNextToken() != ',') throw reader.newParseError(\"Expecting ',' for other object elements\");\n");
        }
        this.code.append("\t\t\tif (reader.getNextToken() != ']') throw reader.newParseError(\"Expecting ']' for object end\");\n");
        this.code.append("\t\t\treturn instance;\n");
        this.code.append("\t\t}\n");
        this.code.append("\t}\n");
    }

    void fromArray(StructInfo si, String className) throws IOException {
        this.asFormatConverter(si, "ArrayFormatConverter", className, false);
        this.writeArray(className, Context.sortedAttributes(si, true));
        List<AttributeInfo> sortedAttributes = Context.sortedAttributes(si, false);
        this.code.append("\t\tpublic ").append(className).append(" read(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
        this.code.append("\t\t\tif (reader.wasNull()) return null;\n");
        this.code.append("\t\t\telse if (reader.last() != '[') throw reader.newParseError(\"Expecting '[' for object start\");\n");
        this.code.append("\t\t\treturn readContent(reader);\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic ").append(className).append(" readContent(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
        int i = sortedAttributes.size();
        for (AttributeInfo attr : sortedAttributes) {
            this.code.append("\t\t\tfinal ").append(attr.typeName).append(" _").append(attr.name).append("_;\n");
            this.code.append("\t\t\treader.getNextToken();\n");
            this.processPropertyValue(attr, "\t", false, si.genericSignatures);
            if (--i <= 0) continue;
            this.code.append("\t\t\tif (reader.getNextToken() != ',') throw reader.newParseError(\"Expecting ',' for other object elements\");\n");
        }
        this.code.append("\t\t\tif (reader.getNextToken() != ']') throw reader.newParseError(\"Expecting ']' for object end\");\n");
        this.returnInstance("\t\t\t", si, className);
        this.code.append("\t\t}\n");
        this.code.append("\t}\n");
    }

    private void returnInstance(String alignment, StructInfo info, String className) throws IOException {
        List<? extends VariableElement> params;
        this.code.append(alignment).append("return ");
        if (info.annotatedFactory == null && info.selectedConstructor() == null && info.builder != null) {
            ExecutableElement factory = info.builder.factory;
            if (factory != null) {
                this.code.append(factory.getEnclosingElement().toString()).append(".").append(factory.getSimpleName()).append("()");
            } else {
                this.code.append("new ").append(info.builder.type.toString()).append("()");
            }
            for (AttributeInfo att : info.attributes.values()) {
                this.code.append(".").append(att.writeMethod.getSimpleName()).append("(_").append(att.name).append("_)");
            }
            this.code.append(".").append(info.builder.build.getSimpleName()).append("();\n");
            return;
        }
        if (info.annotatedFactory != null) {
            this.code.append(info.annotatedFactory.getEnclosingElement().toString()).append(".").append(info.annotatedFactory.getSimpleName()).append("(");
            params = info.annotatedFactory.getParameters();
        } else {
            this.code.append("new ").append(className).append("(");
            params = info.selectedConstructor().getParameters();
        }
        int i = params.size();
        for (VariableElement variableElement : params) {
            this.code.append("_").append(variableElement.getSimpleName()).append("_");
            if (--i <= 0) continue;
            this.code.append(", ");
        }
        this.code.append(");\n");
    }

    private void writeArray(String className, List<AttributeInfo> sortedAttributes) throws IOException {
        this.code.append("\t\tpublic final void write(final com.dslplatform.json.JsonWriter writer, final ");
        this.code.append(className).append(" instance) {\n");
        this.code.append("\t\t\tif (instance == null) writer.writeNull();\n");
        this.code.append("\t\t\telse {\n");
        this.code.append("\t\t\t\twriter.writeByte((byte)'[');\n");
        this.code.append("\t\t\t\twriteContentFull(writer, instance);\n");
        this.code.append("\t\t\t\twriter.writeByte((byte)']');\n");
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic boolean writeContentMinimal(final com.dslplatform.json.JsonWriter writer, final ");
        this.code.append(className).append(" instance) {\n");
        if (sortedAttributes.isEmpty()) {
            this.code.append("\t\t\treturn false;\n");
            this.code.append("\t\t}\n");
        } else {
            this.code.append("\t\t\twriteContentFull(writer, instance);\n");
            this.code.append("\t\t\treturn true;\n");
            this.code.append("\t\t}\n");
        }
        this.code.append("\t\tpublic void writeContentFull(final com.dslplatform.json.JsonWriter writer, final ");
        this.code.append(className).append(" instance) {\n");
        int i = sortedAttributes.size();
        for (AttributeInfo attr : sortedAttributes) {
            this.writeProperty(attr, false, "\t\t\t");
            if (--i <= 0) continue;
            this.code.append("\t\t\twriter.writeByte((byte)',');\n");
        }
        this.code.append("\t\t}\n");
    }

    private void writeProperty(AttributeInfo attr, boolean checkedDefault, String alignment) throws IOException {
        boolean canBeNull;
        String readValue = "instance." + attr.readProperty;
        StructInfo target = this.context.structs.get(attr.typeName);
        String objectType = Analysis.objectName((String)attr.typeName);
        boolean bl = canBeNull = !checkedDefault && objectType.equals(attr.typeName);
        if (attr.notNull && canBeNull) {
            this.code.append(alignment).append("if (").append(readValue);
            this.code.append(" == null) throw new com.dslplatform.json.ConfigurationException(\"Property '").append(attr.name).append("' is not allowed to be null\");\n");
            this.code.append(alignment);
        } else if (canBeNull) {
            this.code.append(alignment).append("if (").append(readValue).append(" == null) writer.writeNull();\n");
            this.code.append(alignment).append("else ");
        } else {
            this.code.append(alignment);
        }
        if (attr.converter != null) {
            this.code.append(attr.converter.fullName).append(".").append(attr.converter.writer).append(".write(writer, ").append(readValue).append(");\n");
        } else if (attr.isJsonObject) {
            this.code.append(readValue).append(".serialize(writer, !alwaysSerialize);\n");
        } else if (target != null && target.converter != null) {
            this.code.append(target.converter.fullName).append(".").append(target.converter.writer).append(".write(writer, ").append(readValue).append(");\n");
        } else {
            OptimizedConverter optimizedConverter = this.context.inlinedConverters.get(attr.typeName);
            List types = attr.collectionContent(this.context.typeSupport, this.context.structs);
            if (optimizedConverter != null) {
                this.code.append(optimizedConverter.nonNullableEncoder("writer", readValue)).append(";\n");
            } else if (target != null && attr.isEnum(this.context.structs)) {
                this.enumTemplate.writeName(this.code, target, readValue, "converter_" + attr.name);
            } else if (types != null) {
                if (attr.type.toString().equals(attr.typeName) || attr.isArray) {
                    this.code.append("writer.serialize(").append(readValue);
                } else {
                    this.code.append("writer.serializeRaw(").append(readValue);
                }
                if (attr.isMap) {
                    this.code.append(", key_writer_").append(attr.name).append(this.context.useLazyResolution((String)types.get(0)) ? "()" : "");
                    this.code.append(", value_writer_").append(attr.name).append(this.context.useLazyResolution((String)types.get(1)) ? "()" : "").append(");\n");
                } else {
                    String content = this.extractSingleType(attr, types);
                    this.code.append(", writer_").append(attr.name).append(this.context.useLazyResolution(content) ? "()" : "").append(");\n");
                }
            } else if (attr.isGeneric && !attr.containsStructOwnerType) {
                String content = this.extractSingleType(attr, null);
                if (attr.isArray) {
                    this.code.append("writer.serialize(").append(readValue).append(", writer_").append(attr.name);
                    this.code.append(this.context.useLazyResolution(content) ? "()" : "").append(");\n");
                } else {
                    this.code.append("writer_").append(attr.name).append(this.context.useLazyResolution(content) ? "()" : "").append(".write(writer, ").append(readValue).append(");\n");
                }
            } else {
                this.code.append("writer_").append(attr.name).append("().write(writer, ").append(readValue).append(");\n");
            }
        }
    }

    private void handleSwitch(StructInfo si, String alignment, boolean useInstance) throws IOException {
        for (AttributeInfo attr : si.attributes.values()) {
            if (!attr.canReadInput()) continue;
            String mn = (String)si.minifiedNames.get(attr.id);
            this.code.append(alignment).append("\tcase ").append(Integer.toString(StructInfo.calcHash((String)(mn != null ? mn : attr.id)))).append(":\n");
            for (String an : attr.alternativeNames) {
                this.code.append(alignment).append("\tcase ").append(Integer.toString(StructInfo.calcHash((String)an))).append(":\n");
            }
            if (attr.fullMatch) {
                this.code.append(alignment).append("\t\tif (!reader.wasLastName(name_").append(attr.name).append(")) {\n");
                if (si.onUnknown == CompiledJson.Behavior.FAIL) {
                    this.code.append(alignment).append("\t\tthrow reader.newParseErrorWith(\"Unknown property detected\", reader.getLastName().length() + 3, \"\", \"Unknown property detected\", reader.getLastName(), \"\");\n");
                } else {
                    this.code.append(alignment).append("\t\treader.getNextToken(); reader.skip(); break;\n");
                }
                this.code.append(alignment).append("\t\t}\n");
            }
            boolean nonPrimitive = attr.typeName.equals(Analysis.objectName((String)attr.typeName));
            String defaultValue = this.context.getDefault(attr);
            if (attr.mandatory || attr.notNull && nonPrimitive && (useInstance || "null".equals(defaultValue) || this.context.isObjectInstance(attr))) {
                this.code.append(alignment).append("\t\t__detected_").append(attr.name).append("__ = true;\n");
            }
            this.code.append(alignment).append("\t\treader.getNextToken();\n");
            this.processPropertyValue(attr, alignment, useInstance, si.genericSignatures);
            this.code.append(alignment).append("\t\treader.getNextToken();\n");
            this.code.append(alignment).append("\t\tbreak;\n");
        }
        if (si.discriminator.length() > 0 && !si.attributes.containsKey(si.discriminator)) {
            String name;
            this.code.append(alignment).append("\tcase ").append(Integer.toString(StructInfo.calcHash((String)si.discriminator))).append(":\n");
            String string = name = si.deserializeName.isEmpty() ? si.binaryName.replace('$', '.') : si.deserializeName;
            if (si.onUnknown == CompiledJson.Behavior.FAIL) {
                this.code.append(alignment).append("\t\treader.getNextToken();\n");
                this.code.append(alignment).append("\t\treader.calcHash();\n");
                this.code.append(alignment).append("\t\tif (!reader.wasLastName(\"").append(name).append("\")) {\n");
                this.code.append(alignment).append("\t\t\tthrow reader.newParseErrorWith(\"Unknown property detected\", reader.getLastName().length() + 3, \"\", \"Unknown property detected\", reader.getLastName(), \"\");\n");
                this.code.append(alignment).append("\t\t}\n");
                this.code.append(alignment).append("\t\treader.getNextToken();\n");
            } else {
                this.code.append(alignment).append("\t\treader.skip();\n");
            }
            this.code.append(alignment).append("\t\tbreak;\n");
        }
        this.code.append(alignment).append("\tdefault:\n");
        if (si.onUnknown == CompiledJson.Behavior.FAIL) {
            this.code.append(alignment).append("\t\tString lastName = reader.getLastName();\n");
            this.code.append(alignment).append("\t\tthrow reader.newParseErrorWith(\"Unknown property detected\", lastName.length() + 3, \"\", \"Unknown property detected\", lastName, \"\");\n");
        } else {
            this.code.append(alignment).append("\t\treader.getNextToken();\n");
            this.code.append(alignment).append("\t\treader.skip();\n");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processPropertyValue(AttributeInfo attr, String alignment, boolean useInstance, Map<String, TypeMirror> genericSignatures) throws IOException {
        if (attr.notNull) {
            this.code.append(alignment).append("\t\tif (reader.wasNull()) throw reader.newParseErrorAt(\"Property '").append(attr.name).append("' is not allowed to be null\", 0);\n");
        }
        OptimizedConverter optimizedConverter = this.context.inlinedConverters.get(attr.typeName);
        String assignmentEnding = useInstance && attr.field == null ? ");\n" : ";\n";
        StructInfo target = this.context.structs.get(attr.typeName);
        if (attr.isJsonObject && attr.converter == null && target != null) {
            if (!attr.notNull) {
                this.code.append(alignment).append("\t\tif (reader.wasNull()) ");
                if (useInstance) {
                    this.code.append("instance.");
                    if (attr.field != null) {
                        this.code.append(attr.field.getSimpleName()).append(" = null;\n");
                    } else {
                        if (attr.writeMethod == null) throw new RuntimeException("Unexpected code path in JsonObject. Please report this bug");
                        this.code.append(attr.writeMethod.getSimpleName()).append("(null);\n");
                    }
                } else {
                    this.code.append("_").append(attr.name).append("_ = null;\n");
                }
            }
            this.code.append(alignment).append("\t\telse if (reader.last() == '{') {\n");
            this.code.append(alignment).append("\t\t\treader.getNextToken();\n");
            if (useInstance) {
                this.code.append(alignment).append("\t\t\tinstance.");
                if (attr.field != null) {
                    this.code.append(attr.field.getSimpleName()).append(" = ");
                } else {
                    if (attr.writeMethod == null) throw new RuntimeException("Unexpected code path in JsonObject. Please report this bug");
                    this.code.append(attr.writeMethod.getSimpleName()).append("(");
                }
                this.code.append(attr.typeName).append(".").append(target.jsonObjectReaderPath).append(".deserialize(reader)").append(assignmentEnding);
            } else {
                this.code.append(alignment).append("\t\t\t_").append(attr.name).append("_ = ").append(attr.typeName);
                this.code.append(".").append(target.jsonObjectReaderPath).append(".deserialize(reader);\n");
            }
            this.code.append(alignment).append("\t\t} else throw reader.newParseError(\"Expecting '{' as start for '").append(attr.name).append("'\");\n");
            return;
        } else if ((target == null || target.converter == null) && attr.converter == null && optimizedConverter != null && optimizedConverter.defaultValue == null && !attr.notNull && optimizedConverter.hasNonNullableMethod()) {
            if (useInstance) {
                if (attr.field == null && attr.writeMethod == null) {
                    throw new RuntimeException("Unexpected code path for optimized converter. Please report this bug");
                }
                this.code.append(alignment).append("\t\tif (reader.wasNull()) instance.");
                if (attr.field != null) {
                    this.code.append(attr.field.getSimpleName()).append(" = null;\n");
                } else {
                    this.code.append(attr.writeMethod.getSimpleName()).append("(null);\n");
                }
                this.code.append(alignment).append("\t\telse instance.");
                if (attr.field != null) {
                    this.code.append(attr.field.getSimpleName()).append(" = ");
                } else {
                    this.code.append(attr.writeMethod.getSimpleName()).append("(");
                }
            } else {
                this.code.append(alignment).append("\t\t_").append(attr.name).append("_ = reader.wasNull() ? null : ");
            }
            this.code.append(optimizedConverter.nonNullableDecoder()).append("(reader)").append(assignmentEnding);
            return;
        } else {
            if (useInstance) {
                this.code.append(alignment).append("\t\tinstance.");
                if (attr.field != null) {
                    this.code.append(attr.field.getSimpleName()).append(" = ");
                } else if (attr.writeMethod != null) {
                    this.code.append(attr.writeMethod.getSimpleName()).append("(");
                } else {
                    if (attr.readMethod == null || !attr.isList && !attr.isSet) throw new RuntimeException("Unexpected code path. Please report this bug");
                    this.code.append(attr.readMethod.getSimpleName()).append("().addAll(");
                }
            } else {
                this.code.append(alignment).append("\t\t_").append(attr.name).append("_ = ");
            }
            List types = attr.collectionContent(this.context.typeSupport, this.context.structs);
            if (attr.converter != null) {
                this.code.append(attr.converter.fullName).append(".").append(attr.converter.reader).append(".read(reader)");
            } else if (target != null && target.converter != null) {
                this.code.append(target.converter.fullName).append(".").append(target.converter.reader).append(".read(reader)");
            } else if (optimizedConverter != null) {
                boolean isPrimitive;
                boolean bl = isPrimitive = !attr.typeName.equals(Analysis.objectName((String)attr.typeName));
                if (attr.notNull || isPrimitive) {
                    this.code.append(optimizedConverter.nonNullableDecoder()).append("(reader)");
                } else {
                    this.code.append(optimizedConverter.decoderField).append(".read(reader)");
                }
            } else if (target != null && attr.isEnum(this.context.structs)) {
                if (!attr.notNull) {
                    this.code.append("reader.wasNull() ? null : ");
                }
                if (this.enumTemplate.isStatic(target)) {
                    this.code.append(CompiledJsonAnnotationProcessor.findConverterName(target)).append(".EnumConverter.readStatic(reader)");
                } else {
                    this.code.append("converter_").append(attr.name).append(".read(reader)");
                }
            } else if (types != null) {
                this.context.serializeKnownCollection(attr, types, genericSignatures);
            } else if (attr.isGeneric && !attr.containsStructOwnerType) {
                if (attr.isArray) {
                    String content = Context.extractRawType(((ArrayType)attr.type).getComponentType(), genericSignatures);
                    this.code.append("(").append(content).append("[])reader.readArray(reader_").append(attr.name);
                    this.code.append(", emptyArray_").append(attr.name).append(")");
                } else {
                    this.code.append("reader_").append(attr.name).append(".read(reader)");
                }
            } else {
                this.code.append("reader_").append(attr.name).append("().read(reader)");
            }
            this.code.append(assignmentEnding);
        }
    }

    private static int calcWeakHash(String name) {
        int hash = 0;
        for (int i = 0; i < name.length(); ++i) {
            hash += (byte)name.charAt(i);
        }
        return hash;
    }
}

