/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.request;

import android.support.annotation.NonNull;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.base.Params;
import com.d.lib.aster.callback.ProgressCallback;
import com.d.lib.aster.callback.UploadCallback;
import com.d.lib.aster.integration.okhttp3.MediaTypes;
import com.d.lib.aster.integration.okhttp3.OkHttpApi;
import com.d.lib.aster.integration.okhttp3.OkHttpClient;
import com.d.lib.aster.integration.okhttp3.body.InputStreamRequestBody;
import com.d.lib.aster.integration.okhttp3.body.UploadProgressRequestBody;
import com.d.lib.aster.integration.okhttp3.func.ApiTransformer;
import com.d.lib.aster.request.IUploadRequest;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.util.Utils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UploadRequest
extends IUploadRequest<UploadRequest, OkHttpClient> {
    protected List<MultipartBody.Part> mMultipartBodyParts = new ArrayList<MultipartBody.Part>();
    protected Call mCall;
    protected Observable<Response> mObservable;
    protected UploadCallback mUploadCallback;

    public UploadRequest(String url) {
        super(url);
    }

    public UploadRequest(String url, Config config) {
        super(url, config);
    }

    protected OkHttpClient getClient() {
        return OkHttpClient.create(2, this.mConfig.log(false));
    }

    protected void prepare() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (MultipartBody.Part part : this.mMultipartBodyParts) {
            builder.addPart(part);
        }
        Object requestBody = this.mUploadCallback != null ? new UploadProgressRequestBody((RequestBody)builder.build(), (ProgressCallback)this.mUploadCallback) : builder.build();
        OkHttpApi.Callable callable = this.getClient().create().postBody(this.mUrl, (RequestBody)requestBody);
        this.mCall = callable.call;
        this.mObservable = callable.observable;
    }

    public <T> void request(@NonNull UploadCallback<T> callback) {
        this.mUploadCallback = callback;
        this.prepare();
        ApiTransformer.requestUpload(this.mCall, this.mObservable, this.mConfig, callback, this.mTag);
    }

    public UploadRequest addParam(String paramKey, String paramValue) {
        if (paramKey != null && paramValue != null) {
            this.mParams.put((Object)paramKey, (Object)paramValue);
            this.mMultipartBodyParts.add(MultipartBody.Part.createFormData((String)paramKey, (String)paramValue));
        }
        return this;
    }

    public UploadRequest addParam(Params params) {
        if (params != null && params.size() > 0) {
            this.mParams.putAll((Map)params);
            for (Map.Entry entry : params.entrySet()) {
                this.mMultipartBodyParts.add(MultipartBody.Part.createFormData((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
        }
        return this;
    }

    public UploadRequest addFile(String name, String filename, File file) {
        return this.addFile(name, filename, file, null);
    }

    public UploadRequest addFile(String name, String filename, File file, ProgressCallback callback) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)Utils.guessMimeType((String)file.getName())), (File)file);
        MultipartBody.Part part = callback != null ? MultipartBody.Part.createFormData((String)name, (String)filename, new UploadProgressRequestBody(requestBody, callback)) : MultipartBody.Part.createFormData((String)name, (String)filename, (RequestBody)requestBody);
        this.mMultipartBodyParts.add(part);
        return this;
    }

    public UploadRequest addImageFile(String name, String filename, File file) {
        return this.addImageFile(name, filename, file, null);
    }

    public UploadRequest addImageFile(String name, String filename, File file, ProgressCallback callback) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.IMAGE_TYPE, (File)file);
        MultipartBody.Part part = callback != null ? MultipartBody.Part.createFormData((String)name, (String)filename, new UploadProgressRequestBody(requestBody, callback)) : MultipartBody.Part.createFormData((String)name, (String)filename, (RequestBody)requestBody);
        this.mMultipartBodyParts.add(part);
        return this;
    }

    public UploadRequest addBytes(String name, String filename, byte[] bytes) {
        return this.addBytes(name, filename, bytes, null);
    }

    public UploadRequest addBytes(String name, String filename, byte[] bytes, ProgressCallback callback) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.APPLICATION_OCTET_STREAM_TYPE, (byte[])bytes);
        MultipartBody.Part part = callback != null ? MultipartBody.Part.createFormData((String)name, (String)filename, new UploadProgressRequestBody(requestBody, callback)) : MultipartBody.Part.createFormData((String)name, (String)filename, (RequestBody)requestBody);
        this.mMultipartBodyParts.add(part);
        return this;
    }

    public UploadRequest addStream(String name, String filename, InputStream inputStream) {
        return this.addStream(name, filename, inputStream, null);
    }

    public UploadRequest addStream(String name, String filename, InputStream inputStream, ProgressCallback callback) {
        RequestBody requestBody = InputStreamRequestBody.create(MediaTypes.APPLICATION_OCTET_STREAM_TYPE, inputStream);
        MultipartBody.Part part = callback != null ? MultipartBody.Part.createFormData((String)name, (String)filename, new UploadProgressRequestBody(requestBody, callback)) : MultipartBody.Part.createFormData((String)name, (String)filename, (RequestBody)requestBody);
        this.mMultipartBodyParts.add(part);
        return this;
    }

    public UploadRequest addPart(Object part) {
        this.mMultipartBodyParts.add((MultipartBody.Part)part);
        return this;
    }

    public static class Singleton
    extends IUploadRequest.Singleton<Singleton, OkHttpClient> {
        protected List<MultipartBody.Part> mMultipartBodyParts = new ArrayList<MultipartBody.Part>();
        protected Call mCall;
        protected Observable<Response> mObservable;
        protected UploadCallback mUploadCallback;

        public Singleton(String url) {
            super(url);
        }

        protected OkHttpClient getClient() {
            return OkHttpClient.getDefault(2);
        }

        protected void prepare() {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            for (MultipartBody.Part part : this.mMultipartBodyParts) {
                builder.addPart(part);
            }
            Object requestBody = this.mUploadCallback != null ? new UploadProgressRequestBody((RequestBody)builder.build(), (ProgressCallback)this.mUploadCallback) : builder.build();
            OkHttpApi.Callable callable = this.getClient().create().postBody(this.mUrl, (RequestBody)requestBody);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
        }

        public <T> void request(UploadCallback<T> callback) {
            this.mUploadCallback = callback;
            this.prepare();
            ApiTransformer.requestUpload(this.mCall, this.mObservable, this.getClient().getHttpConfig(), callback, this.mTag);
        }

        public Singleton addParam(String paramKey, String paramValue) {
            if (paramKey != null && paramValue != null) {
                this.mParams.put((Object)paramKey, (Object)paramValue);
                this.mMultipartBodyParts.add(MultipartBody.Part.createFormData((String)paramKey, (String)paramValue));
            }
            return this;
        }

        public Singleton addParam(Params params) {
            if (params != null && params.size() > 0) {
                this.mParams.putAll((Map)params);
                for (Map.Entry entry : params.entrySet()) {
                    this.mMultipartBodyParts.add(MultipartBody.Part.createFormData((String)((String)entry.getKey()), (String)((String)entry.getValue())));
                }
            }
            return this;
        }

        public Singleton addFile(String name, String filename, File file) {
            return this.addFile(name, filename, file, null);
        }

        public Singleton addFile(String name, String filename, File file, ProgressCallback callback) {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)Utils.guessMimeType((String)file.getName())), (File)file);
            MultipartBody.Part part = callback != null ? MultipartBody.Part.createFormData((String)name, (String)filename, new UploadProgressRequestBody(requestBody, callback)) : MultipartBody.Part.createFormData((String)name, (String)filename, (RequestBody)requestBody);
            this.mMultipartBodyParts.add(part);
            return this;
        }

        public Singleton addImageFile(String name, String filename, File file) {
            return this.addImageFile(name, filename, file, null);
        }

        public Singleton addImageFile(String name, String filename, File file, ProgressCallback callback) {
            RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.IMAGE_TYPE, (File)file);
            MultipartBody.Part part = callback != null ? MultipartBody.Part.createFormData((String)name, (String)filename, new UploadProgressRequestBody(requestBody, callback)) : MultipartBody.Part.createFormData((String)name, (String)filename, (RequestBody)requestBody);
            this.mMultipartBodyParts.add(part);
            return this;
        }

        public Singleton addBytes(String name, String filename, byte[] bytes) {
            return this.addBytes(name, filename, bytes, null);
        }

        public Singleton addBytes(String name, String filename, byte[] bytes, ProgressCallback callback) {
            RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.APPLICATION_OCTET_STREAM_TYPE, (byte[])bytes);
            MultipartBody.Part part = callback != null ? MultipartBody.Part.createFormData((String)name, (String)filename, new UploadProgressRequestBody(requestBody, callback)) : MultipartBody.Part.createFormData((String)name, (String)filename, (RequestBody)requestBody);
            this.mMultipartBodyParts.add(part);
            return this;
        }

        public Singleton addStream(String name, String filename, InputStream inputStream) {
            return this.addStream(name, filename, inputStream, null);
        }

        public Singleton addStream(String name, String filename, InputStream inputStream, ProgressCallback callback) {
            RequestBody requestBody = InputStreamRequestBody.create(MediaTypes.APPLICATION_OCTET_STREAM_TYPE, inputStream);
            MultipartBody.Part part = callback != null ? MultipartBody.Part.createFormData((String)name, (String)filename, new UploadProgressRequestBody(requestBody, callback)) : MultipartBody.Part.createFormData((String)name, (String)filename, (RequestBody)requestBody);
            this.mMultipartBodyParts.add(part);
            return this;
        }

        public Singleton addPart(Object part) {
            this.mMultipartBodyParts.add((MultipartBody.Part)part);
            return this;
        }
    }
}

