/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.observer;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.d.lib.aster.callback.UploadCallback;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.observer.AbsObserver;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.util.ULog;
import com.d.lib.aster.util.Utils;
import okhttp3.Call;

public class UploadObserver<R>
extends AbsObserver<R> {
    private R mData;
    @NonNull
    private final UploadCallback<R> mCallback;
    private final Object mTag;

    public UploadObserver(@Nullable Call call, @Nullable UploadCallback<R> callback, Object tag) {
        if (callback == null) {
            throw new NullPointerException("This callback must not be null!");
        }
        this.mCall = call;
        this.mCallback = callback;
        this.mTag = tag;
    }

    public void cancel() {
        ULog.e((String)"Request cancelled.");
        this.dispose();
        Observable.executeMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UploadObserver.this.mCallback.onCancel();
            }
        });
    }

    public void onNext(R r) {
        RequestManagerImpl.getIns().remove(this.mTag);
        Utils.printThread((String)"Aster_thread uploadOnNext");
        this.mData = r;
        this.mCallback.onSuccess(r);
    }

    @Override
    public void onError(Throwable e) {
        RequestManagerImpl.getIns().remove(this.mTag);
        if (this.isDisposed()) {
            return;
        }
        super.onError(e);
        this.mCallback.onError(e);
    }

    public R getData() {
        return this.mData;
    }
}

