/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.interceptor;

import android.content.Context;
import android.support.annotation.NonNull;
import com.d.lib.aster.interceptor.IInterceptor;
import com.d.lib.aster.util.NetworkUtils;
import java.io.IOException;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OfflineCacheInterceptor
implements Interceptor,
IInterceptor<Interceptor.Chain, Response> {
    private Context mContext;
    private String mCacheControlValue;

    public OfflineCacheInterceptor(Context context) {
        this(context, 86400);
    }

    public OfflineCacheInterceptor(Context context, int cacheControlValue) {
        this.mContext = context;
        this.mCacheControlValue = String.format("max-stale=%d", cacheControlValue);
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (!NetworkUtils.isConnected((Context)this.mContext)) {
            request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
            Response response = chain.proceed(request);
            return response.newBuilder().header("Cache-Control", "public, only-if-cached, " + this.mCacheControlValue).removeHeader("Pragma").build();
        }
        return chain.proceed(request);
    }
}

