/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.func;

import android.support.annotation.NonNull;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.callback.AsyncCallback;
import com.d.lib.aster.callback.ProgressCallback;
import com.d.lib.aster.callback.SimpleCallback;
import com.d.lib.aster.callback.UploadCallback;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.func.ApiFunc;
import com.d.lib.aster.integration.okhttp3.func.ApiRetryFunc;
import com.d.lib.aster.integration.okhttp3.func.MapFunc;
import com.d.lib.aster.integration.okhttp3.observer.ApiObserver;
import com.d.lib.aster.integration.okhttp3.observer.AsyncApiObserver;
import com.d.lib.aster.integration.okhttp3.observer.DownloadObserver;
import com.d.lib.aster.integration.okhttp3.observer.UploadObserver;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.Observer;
import com.d.lib.aster.scheduler.schedule.Schedulers;
import com.d.lib.aster.util.Utils;
import okhttp3.Call;
import okhttp3.Response;

public class ApiTransformer {
    public static <T> void request(Call call, final Observable<Response> observable, Config config, final SimpleCallback<T> callback, Object tag) {
        ApiObserver<T> disposableObserver = new ApiObserver<T>(call, callback, tag);
        if (tag != null) {
            RequestManagerImpl.getIns().add(tag, (Observer)disposableObserver);
        }
        observable.subscribeOn(Schedulers.io()).map(new ApiFunc(Utils.getFirstCls(callback))).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc<T>(disposableObserver, config.retryCount, config.retryDelayMillis, new ApiRetryFunc.OnRetry<T>(){

            @Override
            @NonNull
            public Observable.Observe<T> observe() {
                return observable.subscribeOn(Schedulers.io()).map(new ApiFunc(Utils.getFirstCls((Object)callback))).observeOn(Schedulers.mainThread());
            }
        }));
    }

    public static <T, R> void requestAsync(Call call, final Observable<Response> observable, Config config, final AsyncCallback<T, R> callback, Object tag) {
        AsyncApiObserver<T, R> disposableObserver = new AsyncApiObserver<T, R>(call, callback, tag);
        if (tag != null) {
            RequestManagerImpl.getIns().add(tag, (Observer)disposableObserver);
        }
        observable.subscribeOn(Schedulers.io()).map(new ApiFunc(Utils.getFirstCls(callback))).map(new MapFunc<T, R>(callback)).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc(disposableObserver, config.retryCount, config.retryDelayMillis, new ApiRetryFunc.OnRetry<R>(){

            @Override
            @NonNull
            public Observable.Observe<R> observe() {
                return observable.subscribeOn(Schedulers.io()).map(new ApiFunc(Utils.getFirstCls((Object)callback))).map(new MapFunc(callback)).observeOn(Schedulers.mainThread());
            }
        }));
    }

    public static void requestDownload(Call call, final Observable<Response> observable, Config config, String path, String name, final ProgressCallback callback, Object tag) {
        if (callback != null) {
            Observable.executeMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onStart();
                }
            });
        }
        DownloadObserver disposableObserver = new DownloadObserver(call, path, name, callback, tag);
        if (tag != null) {
            RequestManagerImpl.getIns().add(tag, (Observer)disposableObserver);
        }
        observable.subscribeOn(Schedulers.io()).observeOn(Schedulers.defaultThread()).subscribe(new ApiRetryFunc<Response>(disposableObserver, config.retryCount, config.retryDelayMillis, new ApiRetryFunc.OnRetry<Response>(){

            @Override
            @NonNull
            public Observable.Observe<Response> observe() {
                return observable.subscribeOn(Schedulers.io()).observeOn(Schedulers.io());
            }
        }));
    }

    public static <T> void requestUpload(Call call, final Observable<Response> observable, Config config, final UploadCallback<T> callback, Object tag) {
        UploadObserver<T> disposableObserver = new UploadObserver<T>(call, callback, tag);
        if (tag != null) {
            RequestManagerImpl.getIns().add(tag, (Observer)disposableObserver);
        }
        observable.subscribeOn(Schedulers.io()).map(new ApiFunc(Utils.getFirstCls(callback))).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc<T>(disposableObserver, config.retryCount, config.retryDelayMillis, new ApiRetryFunc.OnRetry<T>(){

            @Override
            @NonNull
            public Observable.Observe<T> observe() {
                return observable.subscribeOn(Schedulers.io()).map(new ApiFunc(Utils.getFirstCls((Object)callback))).observeOn(Schedulers.mainThread());
            }
        }));
    }
}

