/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3;

import android.support.annotation.NonNull;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.base.IClient;
import com.d.lib.aster.integration.okhttp3.OkHttpApi;
import com.d.lib.aster.integration.okhttp3.interceptor.HeadersInterceptor;
import com.d.lib.aster.interceptor.IHeadersInterceptor;
import com.d.lib.aster.interceptor.IInterceptor;
import com.d.lib.aster.util.ULog;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class OkHttpClient
extends IClient {
    private okhttp3.OkHttpClient mClient;
    private OkHttpApi mOkHttpApi;

    private OkHttpClient(int type, @NonNull Config config) {
        super(type, config);
        this.mClient = OkHttpClient.getClient(config);
        this.mOkHttpApi = new OkHttpApi(this.mClient);
    }

    @NonNull
    public okhttp3.OkHttpClient getClient() {
        return this.mClient;
    }

    @NonNull
    public OkHttpApi create() {
        return this.mOkHttpApi;
    }

    public static OkHttpClient create(int type, @NonNull Config config) {
        return new OkHttpClient(type, config);
    }

    @NonNull
    public static OkHttpClient getDefault(int type) {
        if (type == 1) {
            return Transfer.DOWNLOAD;
        }
        if (type == 2) {
            return Transfer.UPLOAD;
        }
        return Default.INSTANCE;
    }

    @NonNull
    public static okhttp3.OkHttpClient getClient(@NonNull Config config) {
        return OkHttpClient.getOkHttpClient(config.headers, config.onHeadInterceptor, config.connectTimeout != -1L ? config.connectTimeout : Config.getDefault().connectTimeout, config.readTimeout != -1L ? config.readTimeout : Config.getDefault().readTimeout, config.writeTimeout != -1L ? config.writeTimeout : Config.getDefault().writeTimeout, config.sslSocketFactory, config.interceptors, config.networkInterceptors, config.log);
    }

    private static okhttp3.OkHttpClient getOkHttpClient(Map<String, String> headers, IHeadersInterceptor.OnHeadInterceptor onHeadInterceptor, long connectTimeout, long readTimeout, long writeTimeout, SSLSocketFactory sslSocketFactory, ArrayList<IInterceptor> interceptors, ArrayList<IInterceptor> networkInterceptors, boolean log) {
        OkHttpClient.Builder builder = new okhttp3.OkHttpClient().newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS);
        if (sslSocketFactory != null) {
            builder.sslSocketFactory(sslSocketFactory);
        }
        if (headers != null && headers.size() > 0 || onHeadInterceptor != null) {
            builder.addInterceptor((Interceptor)new HeadersInterceptor(headers).setOnHeadInterceptor(onHeadInterceptor));
        }
        if (interceptors != null && interceptors.size() > 0) {
            for (IInterceptor interceptor : interceptors) {
                builder.addInterceptor((Interceptor)interceptor);
            }
        }
        if (log) {
            builder.addInterceptor((Interceptor)OkHttpClient.getOkHttpLog());
        }
        if (networkInterceptors != null && networkInterceptors.size() > 0) {
            for (IInterceptor networkInterceptor : networkInterceptors) {
                builder.addNetworkInterceptor((Interceptor)networkInterceptor);
            }
        }
        return builder.build();
    }

    private static HttpLoggingInterceptor getOkHttpLog() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String s) {
                ULog.d((String)(Config.Default.TAG_LOG + s));
            }
        });
        loggingInterceptor.setLevel(OkHttpClient.getLoggingLevel());
        return loggingInterceptor;
    }

    @NonNull
    private static HttpLoggingInterceptor.Level getLoggingLevel() {
        HttpLoggingInterceptor.Level level = Config.Level.BODY == Config.Default.LOG_LEVEL ? HttpLoggingInterceptor.Level.BODY : (Config.Level.HEADERS == Config.Default.LOG_LEVEL ? HttpLoggingInterceptor.Level.HEADERS : (Config.Level.BASIC == Config.Default.LOG_LEVEL ? HttpLoggingInterceptor.Level.BASIC : HttpLoggingInterceptor.Level.NONE));
        return level;
    }

    private static class Transfer {
        private static final OkHttpClient DOWNLOAD = OkHttpClient.create(1, Config.getDefault().log(false));
        private static final OkHttpClient UPLOAD = OkHttpClient.create(2, Config.getDefault().log(false));

        private Transfer() {
        }
    }

    private static class Default {
        private static final OkHttpClient INSTANCE = OkHttpClient.create(0, Config.getDefault().log(true));

        private Default() {
        }
    }
}

