/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.func;

import android.support.annotation.NonNull;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.retry.IRetry;
import com.d.lib.aster.retry.RetryException;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.DisposableObserver;
import com.d.lib.aster.scheduler.callback.Observer;
import com.d.lib.aster.utils.ULog;
import com.d.lib.aster.utils.Util;

public class ApiRetryFunc<T>
extends DisposableObserver<T>
implements IRetry {
    private final OnRetry<T> mObserve;
    private final DisposableObserver<T> mDisposableObserver;
    private final int mMaxRetries;
    private final long mRetryDelayMillis;
    private int mRetryCount;

    public ApiRetryFunc(@NonNull DisposableObserver<T> disposableObserver, int maxRetries, long retryDelayMillis, @NonNull OnRetry<T> observe) {
        this.mObserve = observe;
        this.mDisposableObserver = disposableObserver;
        this.mMaxRetries = maxRetries != -1 ? maxRetries : Config.getDefault().retryCount;
        this.mRetryDelayMillis = retryDelayMillis != -1L ? retryDelayMillis : Config.getDefault().retryDelayMillis;
    }

    public void onNext(@NonNull T result) {
        this.mDisposableObserver.onNext(result);
    }

    public void retry() {
        ++this.mRetryCount;
        ULog.d((String)("Get response data error, it will try after " + this.mRetryDelayMillis + " millisecond, retry count " + this.mRetryCount + "/" + this.mMaxRetries));
        Observable.postMainDelayed((Runnable)new Runnable(){

            @Override
            public void run() {
                Util.printThread((String)"Aster_thread retryApply");
                ApiRetryFunc.this.mObserve.observe().subscribe((Observer)ApiRetryFunc.this);
            }
        }, (long)this.mRetryDelayMillis);
    }

    public void onError(Throwable e) {
        if (this.mRetryCount < this.mMaxRetries && e instanceof RetryException) {
            Util.printThread((String)"Aster_thread retryInit");
            ((RetryException)e).run((IRetry)this);
            return;
        }
        this.mDisposableObserver.onError(e);
    }

    public static interface OnRetry<T> {
        @NonNull
        public Observable.Observe<T> observe();
    }
}

