/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.request;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.base.Params;
import com.d.lib.aster.callback.ProgressCallback;
import com.d.lib.aster.integration.okhttp3.OkHttpApi;
import com.d.lib.aster.integration.okhttp3.OkHttpClient;
import com.d.lib.aster.integration.okhttp3.func.ApiTransformer;
import com.d.lib.aster.request.IDownloadRequest;
import com.d.lib.aster.scheduler.Observable;
import okhttp3.Call;
import okhttp3.Response;

public class DownloadRequest
extends IDownloadRequest<DownloadRequest, OkHttpClient> {
    protected Call mCall;
    protected Observable<Response> mObservable;

    public DownloadRequest(String url) {
        super(url, null);
    }

    public DownloadRequest(String url, Params params) {
        super(url, params);
    }

    public DownloadRequest(String url, Params params, Config config) {
        super(url, params, config);
    }

    protected OkHttpClient getClient() {
        return OkHttpClient.create(1, this.mConfig.log(false));
    }

    protected void prepare() {
        OkHttpApi.Callable callable = this.mParams != null && this.mParams.size() > 0 ? this.getClient().create().get(this.mUrl, this.mParams) : this.getClient().create().get(this.mUrl);
        this.mCall = callable.call;
        this.mObservable = callable.observable;
    }

    public void request(@NonNull String path, @NonNull String name, @NonNull ProgressCallback callback) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("This path can not be empty!");
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("This name can not be empty!");
        }
        if (callback == null) {
            throw new NullPointerException("This callback must not be null!");
        }
        this.prepare();
        ApiTransformer.requestDownload(this.mCall, this.mObservable, this.mConfig, path, name, callback, this.mTag);
    }

    public static class Singleton
    extends IDownloadRequest.Singleton<Singleton, OkHttpClient> {
        protected Observable<Response> mObservable;
        protected Call mCall;

        public Singleton(String url) {
            super(url);
        }

        public Singleton(String url, Params params) {
            super(url, params);
        }

        protected OkHttpClient getClient() {
            return OkHttpClient.getDefault(1);
        }

        protected void prepare() {
            OkHttpApi.Callable callable = this.mParams != null && this.mParams.size() > 0 ? this.getClient().create().get(this.mUrl, this.mParams) : this.getClient().create().get(this.mUrl);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
        }

        public void request(@NonNull String path, @NonNull String name, @NonNull ProgressCallback callback) {
            if (TextUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("This path can not be empty!");
            }
            if (TextUtils.isEmpty((CharSequence)name)) {
                throw new IllegalArgumentException("This name can not be empty!");
            }
            if (callback == null) {
                throw new NullPointerException("This callback must not be null!");
            }
            this.prepare();
            ApiTransformer.requestDownload(this.mCall, this.mObservable, this.getClient().getHttpConfig(), path, name, callback, this.mTag);
        }
    }
}

