/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.request;

import com.d.lib.aster.base.Config;
import com.d.lib.aster.base.Params;
import com.d.lib.aster.callback.AsyncCallback;
import com.d.lib.aster.callback.SimpleCallback;
import com.d.lib.aster.integration.okhttp3.MediaTypes;
import com.d.lib.aster.integration.okhttp3.OkHttpClient;
import com.d.lib.aster.integration.okhttp3.func.ApiFunc;
import com.d.lib.aster.integration.okhttp3.func.ApiTransformer;
import com.d.lib.aster.request.IBodyRequest;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.schedule.Schedulers;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class BodyRequest<HR extends BodyRequest>
extends IBodyRequest<HR, OkHttpClient, RequestBody, MediaType> {
    protected Call mCall;
    protected Observable<Response> mObservable;

    public BodyRequest(String url) {
        super(url);
    }

    public BodyRequest(String url, Params params) {
        super(url, params);
    }

    public BodyRequest(String url, Params params, Config config) {
        super(url, params, config);
    }

    protected OkHttpClient getClient() {
        return OkHttpClient.create(0, this.mConfig.log(true));
    }

    public <T> void request(SimpleCallback<T> callback) {
        this.prepare();
        ApiTransformer.request(this.mCall, this.mObservable, this.mConfig, callback, this.mTag);
    }

    public <T, R> void request(AsyncCallback<T, R> callback) {
        this.prepare();
        ApiTransformer.requestAsync(this.mCall, this.mObservable, this.mConfig, callback, this.mTag);
    }

    public <T> Observable.Observe<T> observable(Class<T> clazz) {
        this.prepare();
        return this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(clazz));
    }

    public HR setRequestBody(RequestBody requestBody) {
        this.mRequestBody = requestBody;
        return (HR)((Object)this);
    }

    public HR setString(String string) {
        this.mContent = string;
        this.mMediaType = MediaTypes.TEXT_PLAIN_TYPE;
        return (HR)((Object)this);
    }

    public HR setJson(String json) {
        this.mContent = json;
        this.mMediaType = MediaTypes.APPLICATION_JSON_TYPE;
        return (HR)((Object)this);
    }

    public static abstract class Singleton<HRF extends Singleton>
    extends IBodyRequest.Singleton<HRF, OkHttpClient, RequestBody, MediaType> {
        protected Call mCall;
        protected Observable<Response> mObservable;

        public Singleton(String url) {
            super(url);
        }

        public Singleton(String url, Params params) {
            super(url, params);
        }

        protected OkHttpClient getClient() {
            return OkHttpClient.getDefault(0);
        }

        public <T> void request(SimpleCallback<T> callback) {
            this.prepare();
            ApiTransformer.request(this.mCall, this.mObservable, this.getClient().getHttpConfig(), callback, this.mTag);
        }

        public <T, R> void request(AsyncCallback<T, R> callback) {
            this.prepare();
            ApiTransformer.requestAsync(this.mCall, this.mObservable, this.getClient().getHttpConfig(), callback, this.mTag);
        }

        public <T> Observable.Observe<T> observable(Class<T> clazz) {
            this.prepare();
            return this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(clazz));
        }

        public HRF setRequestBody(RequestBody requestBody) {
            this.mRequestBody = requestBody;
            return (HRF)((Object)this);
        }

        public HRF setString(String string) {
            this.mContent = string;
            this.mMediaType = MediaTypes.TEXT_PLAIN_TYPE;
            return (HRF)((Object)this);
        }

        public HRF setJson(String json) {
            this.mContent = json;
            this.mMediaType = MediaTypes.APPLICATION_JSON_TYPE;
            return (HRF)((Object)this);
        }
    }
}

