/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.observer;

import android.support.annotation.Nullable;
import com.d.lib.aster.callback.AsyncCallback;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.observer.AbsObserver;
import okhttp3.Call;

public class AsyncApiObserver<T, R>
extends AbsObserver<R> {
    private R mData;
    private final AsyncCallback<T, R> mCallback;
    private final Object mTag;

    public AsyncApiObserver(@Nullable Call call, @Nullable AsyncCallback<T, R> callback, Object tag) {
        if (callback == null) {
            throw new NullPointerException("This callback must not be null!");
        }
        this.mCall = call;
        this.mCallback = callback;
        this.mTag = tag;
    }

    public void onNext(R r) {
        RequestManagerImpl.getIns().remove(this.mTag);
        if (this.isDisposed()) {
            return;
        }
        this.mData = r;
        this.mCallback.onSuccess(r);
    }

    @Override
    public void onError(Throwable e) {
        RequestManagerImpl.getIns().remove(this.mTag);
        if (this.isDisposed()) {
            return;
        }
        super.onError(e);
        this.mCallback.onError(e);
    }

    public R getData() {
        return this.mData;
    }
}

