/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.interceptor;

import android.support.annotation.NonNull;
import com.d.lib.aster.interceptor.IHeadersInterceptor;
import com.d.lib.aster.interceptor.IInterceptor;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeadersInterceptor
extends IHeadersInterceptor
implements Interceptor,
IInterceptor<Interceptor.Chain, Response> {
    public HeadersInterceptor(Map<String, String> headers) {
        super(headers);
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        if (this.mHeaders != null && this.mHeaders.size() > 0) {
            Set keys = this.mHeaders.keySet();
            for (String headerKey : keys) {
                builder.addHeader(headerKey, (String)this.mHeaders.get(headerKey));
            }
        }
        if (this.mOnHeadInterceptor != null) {
            LinkedHashMap headers = new LinkedHashMap();
            this.mOnHeadInterceptor.intercept(headers);
            if (headers.size() > 0) {
                Set keys = headers.keySet();
                for (String headerKey : keys) {
                    builder.addHeader(headerKey, (String)headers.get(headerKey));
                }
            }
        }
        return chain.proceed(builder.build());
    }
}

