/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3;

import android.accounts.NetworkErrorException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.d.lib.aster.base.Params;
import com.d.lib.aster.callback.SimpleCallback;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.Task;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;

public class OkHttpApi {
    private Impl mImpl;

    public OkHttpApi(OkHttpClient mClient) {
        this.mImpl = new Impl(mClient);
    }

    public Impl getImpl() {
        return this.mImpl;
    }

    public Callable get(String url) {
        return this.get(url, null);
    }

    public Callable get(String url, @Nullable Params params) {
        String realUrl = params != null ? url + "?" + params.getRequestParamsString() : url;
        Call call = this.getImpl().getImpl(realUrl);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable post(String url) {
        return this.post(url, null);
    }

    public Callable post(String url, @Nullable Params params) {
        Call call = this.getImpl().postImpl(url, params);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable postBody(String url, RequestBody requestBody) {
        Call call = this.getImpl().postBodyImpl(url, requestBody);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable put(String url) {
        return this.put(url, null);
    }

    public Callable put(String url, @Nullable Params params) {
        Call call = this.getImpl().putImpl(url, params);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable putBody(String url, RequestBody requestBody) {
        Call call = this.getImpl().putBodyImpl(url, requestBody);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable head(String url) {
        Call call = this.getImpl().headImpl(url);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable delete(String url) {
        return this.delete(url, null);
    }

    public Callable delete(String url, Params params) {
        Call call = this.getImpl().deleteImpl(url, params);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable deleteBody(String url, RequestBody requestBody) {
        Call call = this.getImpl().deleteBodyIml(url, requestBody);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable options(String url) {
        return this.options(url, null);
    }

    public Callable options(String url, Params params) {
        Call call = this.getImpl().optionsImpl(url, params);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable optionsBody(String url, RequestBody requestBody) {
        Call call = this.getImpl().optionsBodyImpl(url, requestBody);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable patch(String url) {
        return this.patch(url, null);
    }

    public Callable patch(String url, Params params) {
        Call call = this.getImpl().patchImpl(url, params);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    public Callable patchBody(String url, RequestBody requestBody) {
        Call call = this.getImpl().patchBodyImpl(url, requestBody);
        Observable<Response> observable = this.getObservable(call);
        return new Callable(call, observable);
    }

    @NonNull
    private Observable<Response> getObservable(final Call call) {
        return Observable.create((Task)new Task<Response>(){

            public Response run() throws Exception {
                try {
                    return call.execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
    }

    private void checkSuccessful(@NonNull Response response) throws Exception {
        if (!response.isSuccessful()) {
            throw new NetworkErrorException(!TextUtils.isEmpty((CharSequence)response.message()) ? "Request is not successful for " + response.message() : "Request is not successful.");
        }
    }

    static class Impl {
        private OkHttpClient mClient;

        public Impl(OkHttpClient client) {
            this.mClient = client;
        }

        private Call getImpl(String url) {
            Request request = new Request.Builder().url(url).build();
            return this.mClient.newCall(request);
        }

        private Call postImpl(String url, @Nullable Params params) {
            RequestBody requestBody = this.getRequestBody(params);
            return this.postBodyImpl(url, requestBody);
        }

        private Call postBodyImpl(String url, @NonNull RequestBody requestBody) {
            Request request = new Request.Builder().url(url).post(requestBody).build();
            return this.mClient.newCall(request);
        }

        private Call putImpl(String url, @Nullable Params params) {
            RequestBody requestBody = this.getRequestBody(params);
            return this.putBodyImpl(url, requestBody);
        }

        private Call putBodyImpl(String url, @NonNull RequestBody requestBody) {
            Request request = new Request.Builder().url(url).put(requestBody).build();
            return this.mClient.newCall(request);
        }

        private Call headImpl(String url) {
            Request request = new Request.Builder().url(url).head().build();
            return this.mClient.newCall(request);
        }

        private Call deleteImpl(String url, @Nullable Params params) {
            RequestBody requestBody = this.getRequestBody(params);
            return this.deleteBodyIml(url, requestBody);
        }

        private Call deleteBodyIml(String url, @Nullable RequestBody requestBody) {
            Request request = new Request.Builder().url(url).delete(requestBody).build();
            return this.mClient.newCall(request);
        }

        private Call optionsImpl(String url, @Nullable Params params) {
            RequestBody requestBody = this.getRequestBody(params);
            return this.optionsBodyImpl(url, requestBody);
        }

        private Call optionsBodyImpl(String url, @Nullable RequestBody requestBody) {
            Request request = new Request.Builder().url(url).method("OPTIONS", requestBody).build();
            return this.mClient.newCall(request);
        }

        private Call patchImpl(String url, @Nullable Params params) {
            RequestBody requestBody = this.getRequestBody(params);
            return this.patchBodyImpl(url, requestBody);
        }

        private Call patchBodyImpl(String url, @NonNull RequestBody requestBody) {
            Request request = new Request.Builder().url(url).patch(requestBody).build();
            return this.mClient.newCall(request);
        }

        @NonNull
        private RequestBody getRequestBody(@Nullable Params params) {
            if (params == null) {
                return RequestBody.create(null, (byte[])Util.EMPTY_BYTE_ARRAY);
            }
            FormBody.Builder builder = new FormBody.Builder();
            for (Map.Entry entry : params.entrySet()) {
                builder.add((String)entry.getKey(), (String)entry.getValue());
            }
            return builder.build();
        }

        @Deprecated
        private void enqueue(@NonNull Call call, final @Nullable SimpleCallback<Response> callback) {
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (callback != null) {
                        callback.onError((Throwable)e);
                    }
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (callback != null) {
                        callback.onSuccess((Object)response);
                    }
                }
            });
        }
    }

    public static final class Callable {
        public final Call call;
        public final Observable<Response> observable;

        public Callable(Call call, Observable<Response> observable) {
            this.call = call;
            this.observable = observable;
        }
    }
}

