/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.body;

import android.support.annotation.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class InputStreamRequestBody
extends RequestBody {
    private final MediaType mediaType;
    private final InputStream inputStream;

    public static RequestBody create(MediaType mediaType, InputStream inputStream) {
        return new InputStreamRequestBody(mediaType, inputStream);
    }

    public InputStreamRequestBody(MediaType mediaType, InputStream inputStream) {
        this.mediaType = mediaType;
        this.inputStream = inputStream;
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public long contentLength() {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void writeTo(@NonNull BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((InputStream)this.inputStream);
            sink.writeAll(source);
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }
}

