/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.request;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.callback.ProgressCallback;
import com.d.lib.aster.callback.SimpleCallback;
import com.d.lib.aster.integration.okhttp3.MediaTypes;
import com.d.lib.aster.integration.okhttp3.OkHttpApi;
import com.d.lib.aster.integration.okhttp3.OkHttpClient;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.body.UploadProgressRequestBody;
import com.d.lib.aster.integration.okhttp3.func.ApiRetryFunc;
import com.d.lib.aster.integration.okhttp3.observer.UploadObserver;
import com.d.lib.aster.request.IUploadRequest;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.Observer;
import com.d.lib.aster.scheduler.schedule.Schedulers;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class UploadRequest
extends IUploadRequest<UploadRequest, OkHttpClient> {
    protected List<MultipartBody.Part> mMultipartBodyParts = new ArrayList<MultipartBody.Part>();
    protected Call mCall;
    protected Observable<ResponseBody> mObservable;

    public UploadRequest(String url) {
        super(url);
    }

    public UploadRequest(String url, Config config) {
        super(url, config);
    }

    protected OkHttpClient getClient() {
        return OkHttpClient.create(2, this.mConfig.log(false));
    }

    protected void prepare() {
        if (this.mParams != null && this.mParams.size() > 0) {
            ArrayList<MultipartBody.Part> formParts = new ArrayList<MultipartBody.Part>();
            for (Map.Entry entry : this.mParams.entrySet()) {
                if (entry == null) continue;
                formParts.add(MultipartBody.Part.createFormData((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
            this.mMultipartBodyParts.addAll(0, formParts);
        }
        OkHttpApi.Callable callable = this.getClient().create().upload(this.mUrl, this.mMultipartBodyParts);
        this.mCall = callable.call;
        this.mObservable = callable.observable;
    }

    public void request() {
        this.request(null);
    }

    public <R> void request(@Nullable SimpleCallback<R> callback) {
        this.prepare();
        UploadRequest.requestImpl(this.mObservable, this.getClient().getHttpConfig(), this.mTag, this.mMultipartBodyParts, this.mCall, callback);
    }

    private static void requestImpl(final Observable<ResponseBody> observable, Config config, Object tag, List<MultipartBody.Part> multipartBodyParts, Call call, SimpleCallback<ResponseBody> callback) {
        UploadObserver disposableObserver = new UploadObserver(tag, multipartBodyParts, call, callback);
        if (tag != null) {
            RequestManagerImpl.getIns().add(tag, (Observer)disposableObserver);
        }
        observable.subscribeOn(Schedulers.io()).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc<ResponseBody>(disposableObserver, config.retryCount, config.retryDelayMillis, new ApiRetryFunc.OnRetry<ResponseBody>(){

            @Override
            @NonNull
            public Observable.Observe<ResponseBody> observe() {
                return observable.subscribeOn(Schedulers.io()).observeOn(Schedulers.mainThread());
            }
        }));
    }

    public UploadRequest addParam(String paramKey, String paramValue) {
        if (paramKey != null && paramValue != null) {
            this.mParams.put((Object)paramKey, (Object)paramValue);
        }
        return this;
    }

    public UploadRequest addFile(String key, File file) {
        return this.addFile(key, file, null);
    }

    public UploadRequest addFile(String key, File file, ProgressCallback callback) {
        if (key == null || file == null) {
            return this;
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.APPLICATION_OCTET_STREAM_TYPE, (File)file);
        if (callback != null) {
            UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, callback);
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)uploadProgressRequestBody);
            this.mMultipartBodyParts.add(part);
        } else {
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)requestBody);
            this.mMultipartBodyParts.add(part);
        }
        return this;
    }

    public UploadRequest addImageFile(String key, File file) {
        return this.addImageFile(key, file, null);
    }

    public UploadRequest addImageFile(String key, File file, ProgressCallback callback) {
        if (key == null || file == null) {
            return this;
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.IMAGE_TYPE, (File)file);
        if (callback != null) {
            UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, callback);
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)uploadProgressRequestBody);
            this.mMultipartBodyParts.add(part);
        } else {
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)requestBody);
            this.mMultipartBodyParts.add(part);
        }
        return this;
    }

    public UploadRequest addBytes(String key, byte[] bytes, String name) {
        return this.addBytes(key, bytes, name, null);
    }

    public UploadRequest addBytes(String key, byte[] bytes, String name, ProgressCallback callback) {
        if (key == null || bytes == null || name == null) {
            return this;
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.APPLICATION_OCTET_STREAM_TYPE, (byte[])bytes);
        if (callback != null) {
            UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, callback);
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)name, (RequestBody)uploadProgressRequestBody);
            this.mMultipartBodyParts.add(part);
        } else {
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)name, (RequestBody)requestBody);
            this.mMultipartBodyParts.add(part);
        }
        return this;
    }

    public UploadRequest addStream(String key, InputStream inputStream, String name) {
        return this.addStream(key, inputStream, name, null);
    }

    public UploadRequest addStream(String key, InputStream inputStream, String name, ProgressCallback callback) {
        if (key == null || inputStream == null || name == null) {
            return this;
        }
        RequestBody requestBody = UploadRequest.create(MediaTypes.APPLICATION_OCTET_STREAM_TYPE, inputStream);
        if (callback != null) {
            UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, callback);
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)name, (RequestBody)uploadProgressRequestBody);
            this.mMultipartBodyParts.add(part);
        } else {
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)name, (RequestBody)requestBody);
            this.mMultipartBodyParts.add(part);
        }
        return this;
    }

    private static RequestBody create(final MediaType mediaType, final InputStream inputStream) {
        return new RequestBody(){

            public MediaType contentType() {
                return mediaType;
            }

            public long contentLength() {
                try {
                    return inputStream.available();
                }
                catch (IOException e) {
                    return 0L;
                }
            }

            public void writeTo(@NonNull BufferedSink sink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source((InputStream)inputStream);
                    sink.writeAll(source);
                }
                finally {
                    Util.closeQuietly((Closeable)source);
                }
            }
        };
    }

    public static class Singleton
    extends IUploadRequest.Singleton<Singleton, OkHttpClient> {
        protected List<MultipartBody.Part> mMultipartBodyParts = new ArrayList<MultipartBody.Part>();
        protected Call mCall;
        protected Observable<ResponseBody> mObservable;

        public Singleton(String url) {
            super(url);
        }

        protected OkHttpClient getClient() {
            return OkHttpClient.getDefault(2);
        }

        protected void prepare() {
            if (this.mParams != null && this.mParams.size() > 0) {
                ArrayList<MultipartBody.Part> formParts = new ArrayList<MultipartBody.Part>();
                for (Map.Entry entry : this.mParams.entrySet()) {
                    if (entry == null) continue;
                    formParts.add(MultipartBody.Part.createFormData((String)((String)entry.getKey()), (String)((String)entry.getValue())));
                }
                this.mMultipartBodyParts.addAll(0, formParts);
            }
            OkHttpApi.Callable callable = this.getClient().create().upload(this.mUrl, this.mMultipartBodyParts);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
        }

        public void request() {
            this.request(null);
        }

        public <R> void request(SimpleCallback<R> callback) {
            this.prepare();
            UploadRequest.requestImpl((Observable<ResponseBody>)this.mObservable, this.getClient().getHttpConfig(), this.mTag, this.mMultipartBodyParts, this.mCall, (SimpleCallback<ResponseBody>)callback);
        }

        public Singleton addParam(String paramKey, String paramValue) {
            if (paramKey != null && paramValue != null) {
                this.mParams.put((Object)paramKey, (Object)paramValue);
            }
            return this;
        }

        public Singleton addFile(String key, File file) {
            return this.addFile(key, file, null);
        }

        public Singleton addFile(String key, File file, ProgressCallback callback) {
            if (key == null || file == null) {
                return this;
            }
            RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.APPLICATION_OCTET_STREAM_TYPE, (File)file);
            if (callback != null) {
                UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, callback);
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)uploadProgressRequestBody);
                this.mMultipartBodyParts.add(part);
            } else {
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)requestBody);
                this.mMultipartBodyParts.add(part);
            }
            return this;
        }

        public Singleton addImageFile(String key, File file) {
            return this.addImageFile(key, file, null);
        }

        public Singleton addImageFile(String key, File file, ProgressCallback callback) {
            if (key == null || file == null) {
                return this;
            }
            RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.IMAGE_TYPE, (File)file);
            if (callback != null) {
                UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, callback);
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)uploadProgressRequestBody);
                this.mMultipartBodyParts.add(part);
            } else {
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)requestBody);
                this.mMultipartBodyParts.add(part);
            }
            return this;
        }

        public Singleton addBytes(String key, byte[] bytes, String name) {
            return this.addBytes(key, bytes, name, null);
        }

        public Singleton addBytes(String key, byte[] bytes, String name, ProgressCallback callback) {
            if (key == null || bytes == null || name == null) {
                return this;
            }
            RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.APPLICATION_OCTET_STREAM_TYPE, (byte[])bytes);
            if (callback != null) {
                UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, callback);
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)name, (RequestBody)uploadProgressRequestBody);
                this.mMultipartBodyParts.add(part);
            } else {
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)name, (RequestBody)requestBody);
                this.mMultipartBodyParts.add(part);
            }
            return this;
        }

        public Singleton addStream(String key, InputStream inputStream, String name) {
            return this.addStream(key, inputStream, name, null);
        }

        public Singleton addStream(String key, InputStream inputStream, String name, ProgressCallback callback) {
            if (key == null || inputStream == null || name == null) {
                return this;
            }
            RequestBody requestBody = UploadRequest.create(MediaTypes.APPLICATION_OCTET_STREAM_TYPE, inputStream);
            if (callback != null) {
                UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, callback);
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)name, (RequestBody)uploadProgressRequestBody);
                this.mMultipartBodyParts.add(part);
            } else {
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)name, (RequestBody)requestBody);
                this.mMultipartBodyParts.add(part);
            }
            return this;
        }
    }
}

