/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.request;

import android.support.annotation.NonNull;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.base.Params;
import com.d.lib.aster.callback.AsyncCallback;
import com.d.lib.aster.callback.SimpleCallback;
import com.d.lib.aster.integration.okhttp3.OkHttpClient;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.func.ApiFunc;
import com.d.lib.aster.integration.okhttp3.func.ApiRetryFunc;
import com.d.lib.aster.integration.okhttp3.func.MapFunc;
import com.d.lib.aster.integration.okhttp3.observer.ApiObserver;
import com.d.lib.aster.integration.okhttp3.observer.AsyncApiObserver;
import com.d.lib.aster.request.IHttpRequest;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.Observer;
import com.d.lib.aster.scheduler.schedule.Schedulers;
import com.d.lib.aster.utils.Util;
import okhttp3.Call;
import okhttp3.ResponseBody;

public abstract class HttpRequest<HR extends HttpRequest>
extends IHttpRequest<HR, OkHttpClient> {
    protected Call mCall;
    protected Observable<ResponseBody> mObservable;

    public HttpRequest(String url) {
        super(url);
    }

    public HttpRequest(String url, Params params) {
        super(url, params);
    }

    public HttpRequest(String url, Params params, Config config) {
        super(url, params, config);
    }

    protected OkHttpClient getClient() {
        return OkHttpClient.create(0, this.mConfig.log(true));
    }

    public <T> void request(final SimpleCallback<T> callback) {
        this.prepare();
        ApiObserver<T> disposableObserver = new ApiObserver<T>(this.mTag, this.mCall, callback);
        if (this.mTag != null) {
            RequestManagerImpl.getIns().add(this.mTag, (Observer)disposableObserver);
        }
        this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls(callback))).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc<T>(disposableObserver, this.mConfig.retryCount, this.mConfig.retryDelayMillis, new ApiRetryFunc.OnRetry<T>(){

            @Override
            @NonNull
            public Observable.Observe<T> observe() {
                return HttpRequest.this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls((Object)callback))).observeOn(Schedulers.mainThread());
            }
        }));
    }

    public <T, R> void request(final AsyncCallback<T, R> callback) {
        this.prepare();
        AsyncApiObserver<T, R> disposableObserver = new AsyncApiObserver<T, R>(this.mTag, this.mCall, callback);
        if (this.mTag != null) {
            RequestManagerImpl.getIns().add(this.mTag, (Observer)disposableObserver);
        }
        this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls(callback))).map(new MapFunc<T, R>(callback)).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc(disposableObserver, this.mConfig.retryCount, this.mConfig.retryDelayMillis, new ApiRetryFunc.OnRetry<R>(){

            @Override
            @NonNull
            public Observable.Observe<R> observe() {
                return HttpRequest.this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls((Object)callback))).map(new MapFunc(callback)).observeOn(Schedulers.mainThread());
            }
        }));
    }

    public <T> Observable.Observe<T> observable(Class<T> clazz) {
        this.prepare();
        return this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(clazz));
    }

    public static abstract class Singleton<HRF extends Singleton>
    extends IHttpRequest.Singleton<HRF, OkHttpClient> {
        protected Call mCall;
        protected Observable<ResponseBody> mObservable;

        public Singleton(String url) {
            super(url);
        }

        public Singleton(String url, Params params) {
            super(url, params);
        }

        public Singleton(String url, Params params, Config config) {
            super(url, params, config);
        }

        protected OkHttpClient getClient() {
            return OkHttpClient.getDefault(0);
        }

        public <T> void request(final SimpleCallback<T> callback) {
            this.prepare();
            ApiObserver<T> disposableObserver = new ApiObserver<T>(this.mTag, this.mCall, callback);
            if (this.mTag != null) {
                RequestManagerImpl.getIns().add(this.mTag, (Observer)disposableObserver);
            }
            this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls(callback))).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc<T>(disposableObserver, this.getClient().getHttpConfig().retryCount, this.getClient().getHttpConfig().retryDelayMillis, new ApiRetryFunc.OnRetry<T>(){

                @Override
                @NonNull
                public Observable.Observe<T> observe() {
                    return Singleton.this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls((Object)callback))).observeOn(Schedulers.mainThread());
                }
            }));
        }

        public <T, R> void request(final AsyncCallback<T, R> callback) {
            this.prepare();
            AsyncApiObserver<T, R> disposableObserver = new AsyncApiObserver<T, R>(this.mTag, this.mCall, callback);
            if (this.mTag != null) {
                RequestManagerImpl.getIns().add(this.mTag, (Observer)disposableObserver);
            }
            this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls(callback))).map(new MapFunc<T, R>(callback)).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc(disposableObserver, this.getClient().getHttpConfig().retryCount, this.getClient().getHttpConfig().retryDelayMillis, new ApiRetryFunc.OnRetry<R>(){

                @Override
                @NonNull
                public Observable.Observe<R> observe() {
                    return Singleton.this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls((Object)callback))).map(new MapFunc(callback)).observeOn(Schedulers.mainThread());
                }
            }));
        }

        public <T> Observable.Observe<T> observable(Class<T> clazz) {
            this.prepare();
            return this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(clazz));
        }
    }
}

