/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.observer;

import android.support.annotation.Nullable;
import com.d.lib.aster.callback.SimpleCallback;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.body.UploadProgressRequestBody;
import com.d.lib.aster.integration.okhttp3.observer.AbsObserver;
import com.d.lib.aster.utils.ULog;
import com.d.lib.aster.utils.Util;
import java.util.List;
import okhttp3.Call;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class UploadObserver
extends AbsObserver<ResponseBody> {
    private List<MultipartBody.Part> mMultipartBodyParts;
    private final Object mTag;
    private final SimpleCallback<ResponseBody> mCallback;

    public UploadObserver(Object tag, @Nullable List<MultipartBody.Part> multipartBodyParts, @Nullable Call call, @Nullable SimpleCallback<ResponseBody> callback) {
        this.mTag = tag;
        this.mMultipartBodyParts = multipartBodyParts;
        this.mCall = call;
        this.mCallback = callback;
    }

    public void cancel() {
        ULog.e((String)"Request cancelled.");
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.mMultipartBodyParts != null) {
            for (MultipartBody.Part part : this.mMultipartBodyParts) {
                RequestBody body = part.body();
                if (body == null || !(body instanceof UploadProgressRequestBody)) continue;
                ((UploadProgressRequestBody)body).dispose();
            }
        }
        super.dispose();
    }

    public void onNext(ResponseBody o) {
        RequestManagerImpl.getIns().remove(this.mTag);
        Util.printThread((String)"Aster_thread uploadOnNext");
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onSuccess((Object)o);
    }

    @Override
    public void onError(Throwable e) {
        RequestManagerImpl.getIns().remove(this.mTag);
        if (this.isDisposed()) {
            return;
        }
        super.onError(e);
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onError(e);
    }
}

