/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.observer;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.d.lib.aster.callback.ProgressCallback;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.observer.AbsObserver;
import com.d.lib.aster.scheduler.Observable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import okhttp3.Call;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;

public class DownloadObserver
extends AbsObserver<ResponseBody> {
    private static final int MIN_DELAY_TIME = 1000;
    private final String mPath;
    private final String mName;
    private final Object mTag;
    private final DownloadModel mDownModel = new DownloadModel();
    private final ProgressCallback mCallback;

    public DownloadObserver(String path, String name, @Nullable Object tag, @Nullable Call call, @Nullable ProgressCallback callback) {
        this.mPath = path;
        this.mName = name;
        this.mTag = tag;
        this.mCall = call;
        this.mCallback = callback;
    }

    @NonNull
    private File createFile() {
        File dir = new File(this.mPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir.getPath() + File.separator + this.mName);
    }

    public void cancel() {
        this.dispose();
        if (this.mCallback == null) {
            return;
        }
        Observable.executeMain((Runnable)new Runnable(){

            @Override
            public void run() {
                DownloadObserver.this.mCallback.onCancel();
            }
        });
    }

    public void onNext(ResponseBody responseBody) {
        this.saveFile(responseBody, this.createFile());
    }

    @Override
    public void onError(Throwable e) {
        super.onError(e);
        this.onErrorImpl(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(@NonNull ResponseBody resp, @NonNull File file) {
        InputStream inputStream = null;
        RandomAccessFile outputStream = null;
        try {
            int readLen;
            int currentLength = 0;
            byte[] buffer = new byte[4096];
            long lastTime = 0L;
            inputStream = resp.byteStream();
            outputStream = new RandomAccessFile(file, "rw");
            outputStream.seek(0L);
            this.mDownModel.totalLength = resp.contentLength();
            this.onProgressImpl(this.mDownModel.currentLength, this.mDownModel.totalLength);
            while ((readLen = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, readLen);
                this.mDownModel.currentLength = currentLength += readLen;
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastTime < 1000L && lastTime != 0L) continue;
                lastTime = currentTime;
                this.onProgressImpl(this.mDownModel.currentLength, this.mDownModel.totalLength);
            }
            this.onSuccessImpl();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                this.onErrorImpl(e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(inputStream);
                Util.closeQuietly(outputStream);
                Util.closeQuietly((Closeable)resp);
                throw throwable;
            }
            Util.closeQuietly((Closeable)inputStream);
            Util.closeQuietly(outputStream);
            Util.closeQuietly((Closeable)resp);
        }
        Util.closeQuietly((Closeable)inputStream);
        Util.closeQuietly((Closeable)outputStream);
        Util.closeQuietly((Closeable)resp);
    }

    private void onProgressImpl(final long currentLength, final long totalLength) {
        if (this.mCallback == null) {
            return;
        }
        Observable.executeMain((Runnable)new Runnable(){

            @Override
            public void run() {
                DownloadObserver.this.mCallback.onProgress(currentLength, totalLength);
            }
        });
    }

    private void onErrorImpl(final Throwable e) {
        RequestManagerImpl.getIns().remove(this.mTag);
        if (this.isDisposed()) {
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        Observable.executeMain((Runnable)new Runnable(){

            @Override
            public void run() {
                DownloadObserver.this.mCallback.onError(e);
            }
        });
    }

    private void onSuccessImpl() {
        RequestManagerImpl.getIns().remove(this.mTag);
        if (this.mCallback == null) {
            return;
        }
        Observable.executeMain((Runnable)new Runnable(){

            @Override
            public void run() {
                DownloadObserver.this.mCallback.onSuccess();
            }
        });
    }

    public static class DownloadModel {
        public long currentLength;
        public long totalLength;
    }
}

