/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.request;

import android.support.annotation.NonNull;
import com.d.lib.aster.base.Params;
import com.d.lib.aster.callback.AsyncCallback;
import com.d.lib.aster.callback.SimpleCallback;
import com.d.lib.aster.integration.okhttp3.MediaTypes;
import com.d.lib.aster.integration.okhttp3.OkHttpApi;
import com.d.lib.aster.integration.okhttp3.OkHttpClient;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.func.ApiFunc;
import com.d.lib.aster.integration.okhttp3.func.ApiRetryFunc;
import com.d.lib.aster.integration.okhttp3.func.MapFunc;
import com.d.lib.aster.integration.okhttp3.observer.ApiObserver;
import com.d.lib.aster.integration.okhttp3.observer.AsyncApiObserver;
import com.d.lib.aster.interceptor.IHeadersInterceptor;
import com.d.lib.aster.interceptor.IInterceptor;
import com.d.lib.aster.request.IPostRequest;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.Observer;
import com.d.lib.aster.scheduler.schedule.Schedulers;
import com.d.lib.aster.utils.Util;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;

public class PostRequest
extends IPostRequest<PostRequest, OkHttpClient> {
    protected Call mCall;
    protected Observable<ResponseBody> mObservable;
    private Map<String, Object> mForms = new LinkedHashMap<String, Object>();
    private RequestBody mRequestBody;
    private MediaType mMediaType;
    private String mContent;

    public PostRequest(String url) {
        super(url);
    }

    public PostRequest(String url, Params params) {
        super(url, params);
    }

    protected OkHttpClient getClient() {
        return OkHttpClient.create(0, this.mConfig.log(true));
    }

    protected void prepare() {
        if (this.mForms != null && this.mForms.size() > 0) {
            if (this.mParams != null && this.mParams.size() > 0) {
                for (Map.Entry entry : this.mParams.entrySet()) {
                    if (entry == null) continue;
                    this.mForms.put((String)entry.getKey(), entry.getValue());
                }
            }
            OkHttpApi.Callable callable = this.getClient().create().postForm(this.mUrl, this.mForms);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
            return;
        }
        if (this.mRequestBody != null) {
            OkHttpApi.Callable callable = this.getClient().create().postBody(this.mUrl, this.mRequestBody);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
            return;
        }
        if (this.mContent != null && this.mMediaType != null) {
            this.mRequestBody = RequestBody.create((MediaType)this.mMediaType, (String)this.mContent);
            OkHttpApi.Callable callable = this.getClient().create().postBody(this.mUrl, this.mRequestBody);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
            return;
        }
        if (this.mParams != null && this.mParams.size() > 0) {
            OkHttpApi.Callable callable = this.getClient().create().post(this.mUrl, this.mParams);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
            return;
        }
        OkHttpApi.Callable callable = this.getClient().create().post(this.mUrl);
        this.mCall = callable.call;
        this.mObservable = callable.observable;
    }

    public <T> void request(final SimpleCallback<T> callback) {
        this.prepare();
        ApiObserver<T> disposableObserver = new ApiObserver<T>(this.mTag, this.mCall, callback);
        if (this.mTag != null) {
            RequestManagerImpl.getIns().add(this.mTag, (Observer)disposableObserver);
        }
        this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls(callback))).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc<T>(disposableObserver, this.mConfig.retryCount, this.mConfig.retryDelayMillis, new ApiRetryFunc.OnRetry<T>(){

            @Override
            @NonNull
            public Observable.Observe<T> observe() {
                return PostRequest.this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls((Object)callback))).observeOn(Schedulers.mainThread());
            }
        }));
    }

    public <T, R> void request(final AsyncCallback<T, R> callback) {
        this.prepare();
        AsyncApiObserver<T, R> disposableObserver = new AsyncApiObserver<T, R>(this.mTag, this.mCall, callback);
        if (this.mTag != null) {
            RequestManagerImpl.getIns().add(this.mTag, (Observer)disposableObserver);
        }
        this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls(callback))).map(new MapFunc<T, R>(callback)).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc(disposableObserver, this.mConfig.retryCount, this.mConfig.retryDelayMillis, new ApiRetryFunc.OnRetry<R>(){

            @Override
            @NonNull
            public Observable.Observe<R> observe() {
                return PostRequest.this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls((Object)callback))).map(new MapFunc(callback)).observeOn(Schedulers.mainThread());
            }
        }));
    }

    public <T> Observable.Observe<T> observable(Class<T> clazz) {
        this.prepare();
        return this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(clazz));
    }

    public PostRequest addForm(String formKey, Object formValue) {
        if (formKey != null && formValue != null) {
            this.mForms.put(formKey, formValue);
        }
        return this;
    }

    public PostRequest setRequestBody(RequestBody requestBody) {
        this.mRequestBody = requestBody;
        return this;
    }

    public PostRequest setString(String string) {
        this.mContent = string;
        this.mMediaType = MediaTypes.TEXT_PLAIN_TYPE;
        return this;
    }

    public PostRequest setString(String string, MediaType mediaType) {
        this.mContent = string;
        this.mMediaType = mediaType;
        return this;
    }

    public PostRequest setJson(String json) {
        this.mContent = json;
        this.mMediaType = MediaTypes.APPLICATION_JSON_TYPE;
        return this;
    }

    public PostRequest setJson(JSONObject jsonObject) {
        this.mContent = jsonObject.toString();
        this.mMediaType = MediaTypes.APPLICATION_JSON_TYPE;
        return this;
    }

    public PostRequest setJson(JSONArray jsonArray) {
        this.mContent = jsonArray.toString();
        this.mMediaType = MediaTypes.APPLICATION_JSON_TYPE;
        return this;
    }

    public PostRequest baseUrl(String baseUrl) {
        return (PostRequest)super.baseUrl(baseUrl);
    }

    public PostRequest headers(Map<String, String> headers) {
        return (PostRequest)super.headers(headers);
    }

    public PostRequest headers(IHeadersInterceptor.OnHeadInterceptor onHeadInterceptor) {
        return (PostRequest)super.headers(onHeadInterceptor);
    }

    public PostRequest connectTimeout(long timeout) {
        return (PostRequest)super.connectTimeout(timeout);
    }

    public PostRequest readTimeout(long timeout) {
        return (PostRequest)super.readTimeout(timeout);
    }

    public PostRequest writeTimeout(long timeout) {
        return (PostRequest)super.writeTimeout(timeout);
    }

    public PostRequest sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        return (PostRequest)super.sslSocketFactory(sslSocketFactory);
    }

    public PostRequest addInterceptor(IInterceptor interceptor) {
        return (PostRequest)super.addInterceptor(interceptor);
    }

    public PostRequest addNetworkInterceptors(IInterceptor interceptor) {
        return (PostRequest)super.addNetworkInterceptors(interceptor);
    }

    public PostRequest retryCount(int retryCount) {
        return (PostRequest)super.retryCount(retryCount);
    }

    public PostRequest retryDelayMillis(long retryDelayMillis) {
        return (PostRequest)super.retryDelayMillis(retryDelayMillis);
    }

    public static class Singleton
    extends IPostRequest.Singleton<Singleton, OkHttpClient> {
        protected Call mCall;
        protected Observable<ResponseBody> mObservable;
        private Map<String, Object> mForms = new LinkedHashMap<String, Object>();
        private RequestBody mRequestBody;
        private MediaType mMediaType;
        private String mContent;

        public Singleton(String url) {
            super(url);
        }

        public Singleton(String url, Params params) {
            super(url, params);
        }

        protected OkHttpClient getClient() {
            return OkHttpClient.getDefault(0);
        }

        protected void prepare() {
            if (this.mForms != null && this.mForms.size() > 0) {
                if (this.mParams != null && this.mParams.size() > 0) {
                    for (Map.Entry entry : this.mParams.entrySet()) {
                        if (entry == null) continue;
                        this.mForms.put((String)entry.getKey(), entry.getValue());
                    }
                }
                OkHttpApi.Callable callable = this.getClient().create().postForm(this.mUrl, this.mForms);
                this.mCall = callable.call;
                this.mObservable = callable.observable;
                return;
            }
            if (this.mRequestBody != null) {
                OkHttpApi.Callable callable = this.getClient().create().postBody(this.mUrl, this.mRequestBody);
                this.mCall = callable.call;
                this.mObservable = callable.observable;
                return;
            }
            if (this.mContent != null && this.mMediaType != null) {
                this.mRequestBody = RequestBody.create((MediaType)this.mMediaType, (String)this.mContent);
                OkHttpApi.Callable callable = this.getClient().create().postBody(this.mUrl, this.mRequestBody);
                this.mCall = callable.call;
                this.mObservable = callable.observable;
                return;
            }
            if (this.mParams != null && this.mParams.size() > 0) {
                OkHttpApi.Callable callable = this.getClient().create().post(this.mUrl, this.mParams);
                this.mCall = callable.call;
                this.mObservable = callable.observable;
                return;
            }
            OkHttpApi.Callable callable = this.getClient().create().post(this.mUrl);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
        }

        public <T> void request(final SimpleCallback<T> callback) {
            this.prepare();
            ApiObserver<T> disposableObserver = new ApiObserver<T>(this.mTag, this.mCall, callback);
            if (this.mTag != null) {
                RequestManagerImpl.getIns().add(this.mTag, (Observer)disposableObserver);
            }
            this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls(callback))).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc<T>(disposableObserver, this.getClient().getHttpConfig().retryCount, this.getClient().getHttpConfig().retryDelayMillis, new ApiRetryFunc.OnRetry<T>(){

                @Override
                @NonNull
                public Observable.Observe<T> observe() {
                    return Singleton.this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls((Object)callback))).observeOn(Schedulers.mainThread());
                }
            }));
        }

        public <T, R> void request(final AsyncCallback<T, R> callback) {
            this.prepare();
            AsyncApiObserver<T, R> disposableObserver = new AsyncApiObserver<T, R>(this.mTag, this.mCall, callback);
            if (this.mTag != null) {
                RequestManagerImpl.getIns().add(this.mTag, (Observer)disposableObserver);
            }
            this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls(callback))).map(new MapFunc<T, R>(callback)).observeOn(Schedulers.mainThread()).subscribe(new ApiRetryFunc(disposableObserver, this.getClient().getHttpConfig().retryCount, this.getClient().getHttpConfig().retryDelayMillis, new ApiRetryFunc.OnRetry<R>(){

                @Override
                @NonNull
                public Observable.Observe<R> observe() {
                    return Singleton.this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(Util.getFirstCls((Object)callback))).map(new MapFunc(callback)).observeOn(Schedulers.mainThread());
                }
            }));
        }

        public <T> Observable.Observe<T> observable(Class<T> clazz) {
            this.prepare();
            return this.mObservable.subscribeOn(Schedulers.io()).map(new ApiFunc(clazz));
        }

        public Singleton addForm(String formKey, Object formValue) {
            if (formKey != null && formValue != null) {
                this.mForms.put(formKey, formValue);
            }
            return this;
        }

        public Singleton setRequestBody(RequestBody requestBody) {
            this.mRequestBody = requestBody;
            return this;
        }

        public Singleton setString(String string) {
            this.mContent = string;
            this.mMediaType = MediaTypes.TEXT_PLAIN_TYPE;
            return this;
        }

        public Singleton setString(String string, MediaType mediaType) {
            this.mContent = string;
            this.mMediaType = mediaType;
            return this;
        }

        public Singleton setJson(String json) {
            this.mContent = json;
            this.mMediaType = MediaTypes.APPLICATION_JSON_TYPE;
            return this;
        }

        public Singleton setJson(JSONObject jsonObject) {
            this.mContent = jsonObject.toString();
            this.mMediaType = MediaTypes.APPLICATION_JSON_TYPE;
            return this;
        }

        public Singleton setJson(JSONArray jsonArray) {
            this.mContent = jsonArray.toString();
            this.mMediaType = MediaTypes.APPLICATION_JSON_TYPE;
            return this;
        }
    }
}

