/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3;

import android.support.annotation.Nullable;
import com.d.lib.aster.base.IRequestManager;
import com.d.lib.aster.integration.okhttp3.OkHttpClient;
import com.d.lib.aster.integration.okhttp3.observer.DownloadObserver;
import com.d.lib.aster.integration.okhttp3.observer.UploadObserver;
import com.d.lib.aster.scheduler.callback.DisposableObserver;
import com.d.lib.aster.scheduler.callback.Observer;
import java.util.HashMap;
import java.util.Set;
import okhttp3.Call;

public class RequestManagerImpl
implements IRequestManager<Observer> {
    private HashMap<Object, Observer> mHashMap = new HashMap();

    public static RequestManagerImpl getIns() {
        return Singleton.INSTANCE;
    }

    private RequestManagerImpl() {
    }

    public synchronized void add(Object tag, Observer disposable) {
        if (tag == null || disposable == null) {
            return;
        }
        this.mHashMap.put(tag, disposable);
    }

    public synchronized void remove(Object tag) {
        if (this.mHashMap.isEmpty() || tag == null) {
            return;
        }
        this.mHashMap.remove(tag);
    }

    public synchronized void removeAll() {
        if (this.mHashMap.isEmpty()) {
            return;
        }
        this.mHashMap.clear();
    }

    public synchronized boolean canceled(Object tag) {
        if (tag == null) {
            return false;
        }
        boolean canceled = this.mHashMap.containsKey(tag);
        this.cancel(tag);
        return canceled;
    }

    public synchronized void cancel(Object tag) {
        if (tag == null) {
            return;
        }
        Observer value = this.mHashMap.remove(tag);
        this.cancelImpl(value);
    }

    private void cancelImpl(@Nullable Observer value) {
        if (value == null || !(value instanceof DisposableObserver)) {
            return;
        }
        DisposableObserver disposable = (DisposableObserver)value;
        if (!disposable.isDisposed()) {
            if (disposable instanceof DownloadObserver) {
                ((DownloadObserver)disposable).cancel();
            } else if (disposable instanceof UploadObserver) {
                ((UploadObserver)disposable).cancel();
            } else {
                disposable.dispose();
            }
        }
    }

    public synchronized void cancelAll() {
        if (this.mHashMap.isEmpty()) {
            return;
        }
        HashMap<Object, Observer> temp = new HashMap<Object, Observer>(this.mHashMap);
        this.mHashMap.clear();
        Set<Object> keys = temp.keySet();
        for (Object k : keys) {
            this.cancelImpl(temp.get(k));
        }
    }

    public static void addTag(Call call, Object tag) {
    }

    public static void cancelTag(OkHttpClient client, Object tag) {
        if (client == null || tag == null) {
            return;
        }
        for (Call call : client.getClient().dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : client.getClient().dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    private static class Singleton {
        private static final RequestManagerImpl INSTANCE = new RequestManagerImpl();

        private Singleton() {
        }
    }
}

