/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3;

import android.accounts.NetworkErrorException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.d.lib.aster.base.Params;
import com.d.lib.aster.callback.SimpleCallback;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.Task;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpApi {
    private Impl mImpl;

    public OkHttpApi(OkHttpClient mClient) {
        this.mImpl = new Impl(mClient);
    }

    public Impl getImpl() {
        return this.mImpl;
    }

    public Callable get(String url, Params params) {
        return this.get(url + "?" + params.getRequestParamsString());
    }

    public Callable get(String url) {
        final Call call = this.getImpl().getImpl(url);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable post(String url) {
        final Call call = this.getImpl().postImpl(url, null);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable post(String url, Params params) {
        final Call call = this.getImpl().postImpl(url, params);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable postForm(String url, Map<String, Object> forms) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, Object> entry : forms.entrySet()) {
            builder.add(entry.getKey(), String.valueOf(entry.getValue()));
        }
        final Call call = this.getImpl().postBodyImpl(url, (RequestBody)builder.build());
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable postBody(String url, RequestBody requestBody) {
        final Call call = this.getImpl().postBodyImpl(url, requestBody);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable put(String url, Params params) {
        final Call call = this.getImpl().putImpl(url, params);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable head(String url, Params params) {
        final Call call = this.getImpl().headImpl(url, params);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable delete(String url, Params params) {
        final Call call = this.getImpl().deleteImpl(url, params);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable options(String url, Params params) {
        final Call call = this.getImpl().optionsImpl(url, params);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable patch(String url, Params params) {
        final Call call = this.getImpl().patchImpl(url, params);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable download(String url, Params params) {
        return this.download(url + "?" + params.getRequestParamsString());
    }

    public Callable download(String url) {
        final Call call = this.getImpl().downloadImpl(url);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    public Callable upload(String url, List<MultipartBody.Part> multipartBodyParts) {
        final Call call = this.getImpl().uploadImpl(url, multipartBodyParts);
        Observable observable = Observable.create((Task)new Task<ResponseBody>(){

            public ResponseBody run() throws Exception {
                try {
                    Response response = call.execute();
                    int code = response.code();
                    return response.body();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return new Callable(call, (Observable<ResponseBody>)observable);
    }

    private void checkSuccessful(@NonNull Response response) throws Exception {
        if (!response.isSuccessful()) {
            throw new NetworkErrorException(!TextUtils.isEmpty((CharSequence)response.message()) ? "Request is not successful for " + response.message() : "Request is not successful.");
        }
    }

    static class Impl {
        private OkHttpClient mClient;

        public Impl(OkHttpClient client) {
            this.mClient = client;
        }

        public void get(String url, Params params, SimpleCallback<Response> callback) {
            this.get(url + "?" + params.getRequestParamsString(), callback);
        }

        public void get(String url, SimpleCallback<Response> callback) {
            this.enqueue(this.getImpl(url), callback);
        }

        private Call getImpl(String url) {
            Request request = new Request.Builder().url(url).build();
            return this.mClient.newCall(request);
        }

        public Response post(String url) throws IOException {
            return this.postImpl(url, null).execute();
        }

        public void post(String url, SimpleCallback<Response> callback) {
            this.enqueue(this.postImpl(url, null), callback);
        }

        public Response post(String url, Params params) throws IOException {
            return this.postImpl(url, params).execute();
        }

        public void post(String url, Params params, SimpleCallback<Response> callback) {
            this.enqueue(this.postImpl(url, params), callback);
        }

        private Call postImpl(String url, Params params) {
            FormBody.Builder builder = new FormBody.Builder();
            if (params != null) {
                for (String key : params.keySet()) {
                    builder.add(key, (String)params.get((Object)key));
                }
            }
            Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
            return this.mClient.newCall(request);
        }

        public Response postBody(String url, RequestBody requestBody) throws IOException {
            return this.postBodyImpl(url, requestBody).execute();
        }

        public void postBody(String url, RequestBody requestBody, SimpleCallback<Response> callback) {
            this.enqueue(this.postBodyImpl(url, requestBody), callback);
        }

        private Call postBodyImpl(String url, RequestBody requestBody) {
            Request request = new Request.Builder().url(url).post(requestBody).build();
            return this.mClient.newCall(request);
        }

        private Call putImpl(String url, Params params) {
            FormBody.Builder builder = new FormBody.Builder();
            for (Map.Entry entry : params.entrySet()) {
                builder.add((String)entry.getKey(), (String)entry.getValue());
            }
            Request request = new Request.Builder().url(url).put((RequestBody)builder.build()).build();
            return this.mClient.newCall(request);
        }

        public Response head(String url, Params params) throws IOException {
            return this.headImpl(url, params).execute();
        }

        private Call headImpl(String url, Params params) {
            FormBody.Builder builder = new FormBody.Builder();
            if (params != null) {
                for (String key : params.keySet()) {
                    builder.add(key, (String)params.get((Object)key));
                }
            }
            Request request = new Request.Builder().url(url).method("HEAD", (RequestBody)builder.build()).build();
            return this.mClient.newCall(request);
        }

        public Response delete(String url, Params params) throws IOException {
            return this.deleteImpl(url, params).execute();
        }

        private Call deleteImpl(String url, Params params) {
            FormBody.Builder builder = new FormBody.Builder();
            if (params != null) {
                for (String key : params.keySet()) {
                    builder.add(key, (String)params.get((Object)key));
                }
            }
            Request request = new Request.Builder().url(url).delete((RequestBody)builder.build()).build();
            return this.mClient.newCall(request);
        }

        public Response options(String url, Params params) throws IOException {
            return this.optionsImpl(url, params).execute();
        }

        private Call optionsImpl(String url, Params params) {
            FormBody.Builder builder = new FormBody.Builder();
            if (params != null) {
                for (String key : params.keySet()) {
                    builder.add(key, (String)params.get((Object)key));
                }
            }
            Request request = new Request.Builder().url(url).method("OPTIONS", (RequestBody)builder.build()).build();
            return this.mClient.newCall(request);
        }

        private Call patchImpl(String url, Params params) {
            FormBody.Builder builder = new FormBody.Builder();
            for (Map.Entry entry : params.entrySet()) {
                builder.add((String)entry.getKey(), (String)entry.getValue());
            }
            Request request = new Request.Builder().url(url).patch((RequestBody)builder.build()).build();
            return this.mClient.newCall(request);
        }

        private Call downloadImpl(String url) {
            Request request = new Request.Builder().url(url).build();
            return this.mClient.newCall(request);
        }

        private Call uploadImpl(String url, List<MultipartBody.Part> multipartBodyParts) {
            MultipartBody.Builder builder = new MultipartBody.Builder();
            for (MultipartBody.Part part : multipartBodyParts) {
                builder.addPart(part);
            }
            Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
            return this.mClient.newCall(request);
        }

        private void enqueue(@NonNull Call call, final SimpleCallback<Response> callback) {
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (callback != null) {
                        callback.onError((Throwable)e);
                    }
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (callback != null) {
                        callback.onSuccess((Object)response);
                    }
                }
            });
        }
    }

    public static final class Callable {
        public final Call call;
        public final Observable<ResponseBody> observable;

        public Callable(Call call, Observable<ResponseBody> observable) {
            this.call = call;
            this.observable = observable;
        }
    }
}

