/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.request;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.base.Params;
import com.d.lib.aster.callback.ProgressCallback;
import com.d.lib.aster.integration.okhttp3.OkHttpApi;
import com.d.lib.aster.integration.okhttp3.OkHttpClient;
import com.d.lib.aster.integration.okhttp3.RequestManagerImpl;
import com.d.lib.aster.integration.okhttp3.func.ApiRetryFunc;
import com.d.lib.aster.integration.okhttp3.observer.DownloadObserver;
import com.d.lib.aster.interceptor.IHeadersInterceptor;
import com.d.lib.aster.interceptor.IInterceptor;
import com.d.lib.aster.request.IDownloadRequest;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.Observer;
import com.d.lib.aster.scheduler.schedule.Schedulers;
import com.d.lib.aster.utils.Util;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Call;
import okhttp3.ResponseBody;

public class DownloadRequest
extends IDownloadRequest<DownloadRequest, OkHttpClient> {
    protected Call mCall;
    protected Observable<ResponseBody> mObservable;

    public DownloadRequest(String url) {
        super(url, null);
    }

    public DownloadRequest(String url, Params params) {
        super(url, params);
    }

    public DownloadRequest(String url, Params params, Config config) {
        super(url, params, config);
    }

    protected OkHttpClient getClient() {
        return OkHttpClient.create(1, this.mConfig.log(false));
    }

    protected void prepare() {
        OkHttpApi.Callable callable = this.mParams == null || this.mParams.size() <= 0 ? this.getClient().create().download(this.mUrl) : this.getClient().create().download(this.mUrl, this.mParams);
        this.mCall = callable.call;
        this.mObservable = callable.observable;
    }

    public void request(@NonNull String path, @NonNull String name, @NonNull ProgressCallback callback) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("This path can not be empty!");
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("This name can not be empty!");
        }
        if (callback == null) {
            throw new NullPointerException("This callback must not be null!");
        }
        this.prepare();
        DownloadRequest.requestImpl(this.mObservable, this.getClient().getHttpConfig(), path, name, this.mTag, this.mCall, callback);
    }

    private static void requestImpl(final Observable<ResponseBody> observable, Config config, String path, String name, Object tag, Call call, final ProgressCallback callback) {
        if (callback != null) {
            Util.executeMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onStart();
                }
            });
        }
        DownloadObserver disposableObserver = new DownloadObserver(path, name, tag, call, callback);
        if (tag != null) {
            RequestManagerImpl.getIns().add(tag, (Observer)disposableObserver);
        }
        observable.subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe(new ApiRetryFunc<ResponseBody>(disposableObserver, config.retryCount, config.retryDelayMillis, new ApiRetryFunc.OnRetry<ResponseBody>(){

            @Override
            @NonNull
            public Observable.Observe<ResponseBody> observe() {
                return observable.subscribeOn(Schedulers.io()).observeOn(Schedulers.io());
            }
        }));
    }

    public DownloadRequest baseUrl(String baseUrl) {
        return (DownloadRequest)super.baseUrl(baseUrl);
    }

    public DownloadRequest headers(Map<String, String> headers) {
        return (DownloadRequest)super.headers(headers);
    }

    public DownloadRequest headers(IHeadersInterceptor.OnHeadInterceptor onHeadInterceptor) {
        return (DownloadRequest)super.headers(onHeadInterceptor);
    }

    public DownloadRequest connectTimeout(long timeout) {
        return (DownloadRequest)super.connectTimeout(timeout);
    }

    public DownloadRequest readTimeout(long timeout) {
        return (DownloadRequest)super.readTimeout(timeout);
    }

    public DownloadRequest writeTimeout(long timeout) {
        return (DownloadRequest)super.writeTimeout(timeout);
    }

    public DownloadRequest sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        return (DownloadRequest)super.sslSocketFactory(sslSocketFactory);
    }

    public DownloadRequest addInterceptor(IInterceptor interceptor) {
        return (DownloadRequest)super.addInterceptor(interceptor);
    }

    public DownloadRequest addNetworkInterceptors(IInterceptor interceptor) {
        return (DownloadRequest)super.addNetworkInterceptors(interceptor);
    }

    public DownloadRequest retryCount(int retryCount) {
        return (DownloadRequest)super.retryCount(retryCount);
    }

    public DownloadRequest retryDelayMillis(long retryDelayMillis) {
        return (DownloadRequest)super.retryDelayMillis(retryDelayMillis);
    }

    public static class Singleton
    extends IDownloadRequest.Singleton<Singleton, OkHttpClient> {
        protected Observable<ResponseBody> mObservable;
        protected Call mCall;

        public Singleton(String url) {
            super(url);
        }

        public Singleton(String url, Params params) {
            super(url, params);
        }

        protected OkHttpClient getClient() {
            return OkHttpClient.getDefault(1);
        }

        protected void prepare() {
            OkHttpApi.Callable callable = this.mParams == null || this.mParams.size() <= 0 ? this.getClient().create().download(this.mUrl) : this.getClient().create().download(this.mUrl, this.mParams);
            this.mCall = callable.call;
            this.mObservable = callable.observable;
        }

        public void request(@NonNull String path, @NonNull String name, @NonNull ProgressCallback callback) {
            if (TextUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("This path can not be empty!");
            }
            if (TextUtils.isEmpty((CharSequence)name)) {
                throw new IllegalArgumentException("This name can not be empty!");
            }
            if (callback == null) {
                throw new NullPointerException("This callback must not be null!");
            }
            this.prepare();
            DownloadRequest.requestImpl((Observable<ResponseBody>)this.mObservable, this.getClient().getHttpConfig(), path, name, this.mTag, this.mCall, callback);
        }
    }
}

