/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.func;

import android.support.annotation.NonNull;
import com.d.lib.aster.base.Config;
import com.d.lib.aster.scheduler.Observable;
import com.d.lib.aster.scheduler.callback.DisposableObserver;
import com.d.lib.aster.scheduler.callback.Observer;
import com.d.lib.aster.utils.ULog;
import com.d.lib.aster.utils.Util;
import java.net.ConnectException;
import java.net.SocketTimeoutException;

public class ApiRetryFunc<T>
extends DisposableObserver<T> {
    private final OnRetry<T> mObserve;
    private final DisposableObserver<T> mDisposableObserver;
    private final int mMaxRetries;
    private final long mRetryDelayMillis;
    private int mRetryCount;

    public ApiRetryFunc(@NonNull DisposableObserver<T> disposableObserver, int maxRetries, long retryDelayMillis, @NonNull OnRetry<T> observe) {
        this.mObserve = observe;
        this.mDisposableObserver = disposableObserver;
        this.mMaxRetries = maxRetries != -1 ? maxRetries : Config.getDefault().retryCount;
        this.mRetryDelayMillis = retryDelayMillis != -1L ? retryDelayMillis : Config.getDefault().retryDelayMillis;
    }

    public void onNext(@NonNull T result) {
        this.mDisposableObserver.onNext(result);
    }

    public void onError(Throwable e) {
        Util.printThread((String)"Aster_thread retryInit");
        Util.printThread((String)"Aster_thread retryApply");
        if (++this.mRetryCount <= this.mMaxRetries && (e instanceof SocketTimeoutException || e instanceof ConnectException)) {
            ULog.d((String)("Get response data error, it will try after " + this.mRetryDelayMillis + " millisecond, retry count " + this.mRetryCount + "/" + this.mMaxRetries));
            ++this.mRetryCount;
            this.mObserve.observe().subscribe((Observer)this);
            return;
        }
        this.mDisposableObserver.onError(e);
    }

    public static interface OnRetry<T> {
        @NonNull
        public Observable.Observe<T> observe();
    }
}

