/*
 * Decompiled with CFR 0.152.
 */
package com.d.lib.aster.integration.okhttp3.body;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.d.lib.aster.callback.ProgressCallback;
import com.d.lib.aster.utils.ULog;
import com.d.lib.aster.utils.Util;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class UploadProgressRequestBody
extends RequestBody {
    private static final int MIN_DELAY_TIME = 1000;
    private RequestBody mRequestBody;
    private ProgressCallback mCallback;
    private long mLastTime;
    private AtomicBoolean disposed = new AtomicBoolean(false);

    public UploadProgressRequestBody(@NonNull RequestBody requestBody, @NonNull ProgressCallback callback) {
        this.mRequestBody = requestBody;
        this.mCallback = callback;
    }

    public MediaType contentType() {
        return this.mRequestBody.contentType();
    }

    public long contentLength() {
        try {
            return this.mRequestBody.contentLength();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void writeTo(@NonNull BufferedSink sink) throws IOException {
        this.onStartImpl();
        try {
            BufferedSink bufferedSink = Okio.buffer((Sink)new CountingSink((Sink)sink));
            this.mRequestBody.writeTo(bufferedSink);
            bufferedSink.flush();
            this.onSuccessImpl();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.onErrorImpl(e);
            throw e;
        }
    }

    private void onStartImpl() {
        if (this.mCallback == null) {
            return;
        }
        Util.executeMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UploadProgressRequestBody.this.mCallback.onStart();
            }
        });
    }

    private void onErrorImpl(final Throwable e) {
        if (this.isDisposed()) {
            if (this.mCallback != null) {
                this.mCallback.onCancel();
            }
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        Util.executeMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UploadProgressRequestBody.this.mCallback.onError(e);
            }
        });
    }

    private void onSuccessImpl() {
        if (this.mCallback == null) {
            return;
        }
        Util.executeMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UploadProgressRequestBody.this.mCallback.onSuccess();
            }
        });
    }

    public final boolean isDisposed() {
        return this.disposed.get();
    }

    public void dispose() {
        this.disposed.set(true);
    }

    private final class CountingSink
    extends ForwardingSink {
        private long currentLength;
        private long totalLength;

        CountingSink(Sink sink) {
            super(sink);
            this.currentLength = 0L;
            this.totalLength = 0L;
        }

        @SuppressLint(value={"CheckResult"})
        public void write(@NonNull Buffer source, long byteCount) throws IOException {
            long currentTime;
            super.write(source, byteCount);
            this.currentLength += byteCount;
            if (this.totalLength == 0L) {
                this.totalLength = UploadProgressRequestBody.this.contentLength();
            }
            if ((currentTime = System.currentTimeMillis()) - UploadProgressRequestBody.this.mLastTime >= 1000L || UploadProgressRequestBody.this.mLastTime == 0L || this.currentLength == this.totalLength) {
                UploadProgressRequestBody.this.mLastTime = currentTime;
                Util.executeMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ULog.d((String)("Upload progress currentLength: " + CountingSink.this.currentLength + " totalLength: " + CountingSink.this.totalLength));
                        UploadProgressRequestBody.this.mCallback.onProgress(CountingSink.this.currentLength, CountingSink.this.totalLength);
                    }
                });
            }
        }
    }
}

