/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.SubAttachment;
import com.dropbox.sign.model.SubCustomField;
import com.dropbox.sign.model.SubFieldOptions;
import com.dropbox.sign.model.SubFormFieldGroup;
import com.dropbox.sign.model.SubFormFieldRule;
import com.dropbox.sign.model.SubFormFieldsPerDocumentBase;
import com.dropbox.sign.model.SubSigningOptions;
import com.dropbox.sign.model.SubUnclaimedDraftSigner;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "files", "file_urls", "allow_decline", "attachments", "cc_email_addresses", "client_id", "custom_fields", "field_options", "form_field_groups", "form_field_rules", "form_fields_per_document", "hide_text_tags", "message", "metadata", "show_progress_stepper", "signers", "signing_options", "signing_redirect_url", "subject", "test_mode", "use_preexisting_fields", "use_text_tags", "expires_at"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class UnclaimedDraftCreateRequest {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_FILES = "files";
    private List<File> files = null;
    public static final String JSON_PROPERTY_FILE_URLS = "file_urls";
    private List<String> fileUrls = null;
    public static final String JSON_PROPERTY_ALLOW_DECLINE = "allow_decline";
    private Boolean allowDecline = false;
    public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
    private List<SubAttachment> attachments = null;
    public static final String JSON_PROPERTY_CC_EMAIL_ADDRESSES = "cc_email_addresses";
    private List<String> ccEmailAddresses = null;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "custom_fields";
    private List<SubCustomField> customFields = null;
    public static final String JSON_PROPERTY_FIELD_OPTIONS = "field_options";
    private SubFieldOptions fieldOptions;
    public static final String JSON_PROPERTY_FORM_FIELD_GROUPS = "form_field_groups";
    private List<SubFormFieldGroup> formFieldGroups = null;
    public static final String JSON_PROPERTY_FORM_FIELD_RULES = "form_field_rules";
    private List<SubFormFieldRule> formFieldRules = null;
    public static final String JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT = "form_fields_per_document";
    private List<SubFormFieldsPerDocumentBase> formFieldsPerDocument = null;
    public static final String JSON_PROPERTY_HIDE_TEXT_TAGS = "hide_text_tags";
    private Boolean hideTextTags = false;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, Object> metadata = null;
    public static final String JSON_PROPERTY_SHOW_PROGRESS_STEPPER = "show_progress_stepper";
    private Boolean showProgressStepper = true;
    public static final String JSON_PROPERTY_SIGNERS = "signers";
    private List<SubUnclaimedDraftSigner> signers = null;
    public static final String JSON_PROPERTY_SIGNING_OPTIONS = "signing_options";
    private SubSigningOptions signingOptions;
    public static final String JSON_PROPERTY_SIGNING_REDIRECT_URL = "signing_redirect_url";
    private String signingRedirectUrl;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;
    public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
    private Boolean testMode = false;
    public static final String JSON_PROPERTY_USE_PREEXISTING_FIELDS = "use_preexisting_fields";
    private Boolean usePreexistingFields = false;
    public static final String JSON_PROPERTY_USE_TEXT_TAGS = "use_text_tags";
    private Boolean useTextTags = false;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    private Integer expiresAt;

    public static UnclaimedDraftCreateRequest init(String jsonData) throws Exception {
        return (UnclaimedDraftCreateRequest)new ObjectMapper().readValue(jsonData, UnclaimedDraftCreateRequest.class);
    }

    public static UnclaimedDraftCreateRequest init(HashMap data) throws Exception {
        return (UnclaimedDraftCreateRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), UnclaimedDraftCreateRequest.class);
    }

    public UnclaimedDraftCreateRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UnclaimedDraftCreateRequest files(List<File> files) {
        this.files = files;
        return this;
    }

    public UnclaimedDraftCreateRequest addFilesItem(File filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<File> getFiles() {
        return this.files;
    }

    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFiles(List<File> files) {
        this.files = files;
    }

    public UnclaimedDraftCreateRequest fileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
        return this;
    }

    public UnclaimedDraftCreateRequest addFileUrlsItem(String fileUrlsItem) {
        if (this.fileUrls == null) {
            this.fileUrls = new ArrayList<String>();
        }
        this.fileUrls.add(fileUrlsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="file_urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    @JsonProperty(value="file_urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
    }

    public UnclaimedDraftCreateRequest allowDecline(Boolean allowDecline) {
        this.allowDecline = allowDecline;
        return this;
    }

    @Nullable
    @JsonProperty(value="allow_decline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowDecline() {
        return this.allowDecline;
    }

    @JsonProperty(value="allow_decline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowDecline(Boolean allowDecline) {
        this.allowDecline = allowDecline;
    }

    public UnclaimedDraftCreateRequest attachments(List<SubAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public UnclaimedDraftCreateRequest addAttachmentsItem(SubAttachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<SubAttachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubAttachment> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachments(List<SubAttachment> attachments) {
        this.attachments = attachments;
    }

    public UnclaimedDraftCreateRequest ccEmailAddresses(List<String> ccEmailAddresses) {
        this.ccEmailAddresses = ccEmailAddresses;
        return this;
    }

    public UnclaimedDraftCreateRequest addCcEmailAddressesItem(String ccEmailAddressesItem) {
        if (this.ccEmailAddresses == null) {
            this.ccEmailAddresses = new ArrayList<String>();
        }
        this.ccEmailAddresses.add(ccEmailAddressesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="cc_email_addresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCcEmailAddresses() {
        return this.ccEmailAddresses;
    }

    @JsonProperty(value="cc_email_addresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCcEmailAddresses(List<String> ccEmailAddresses) {
        this.ccEmailAddresses = ccEmailAddresses;
    }

    public UnclaimedDraftCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public UnclaimedDraftCreateRequest customFields(List<SubCustomField> customFields) {
        this.customFields = customFields;
        return this;
    }

    public UnclaimedDraftCreateRequest addCustomFieldsItem(SubCustomField customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new ArrayList<SubCustomField>();
        }
        this.customFields.add(customFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubCustomField> getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(List<SubCustomField> customFields) {
        this.customFields = customFields;
    }

    public UnclaimedDraftCreateRequest fieldOptions(SubFieldOptions fieldOptions) {
        this.fieldOptions = fieldOptions;
        return this;
    }

    @Nullable
    @JsonProperty(value="field_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubFieldOptions getFieldOptions() {
        return this.fieldOptions;
    }

    @JsonProperty(value="field_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldOptions(SubFieldOptions fieldOptions) {
        this.fieldOptions = fieldOptions;
    }

    public UnclaimedDraftCreateRequest formFieldGroups(List<SubFormFieldGroup> formFieldGroups) {
        this.formFieldGroups = formFieldGroups;
        return this;
    }

    public UnclaimedDraftCreateRequest addFormFieldGroupsItem(SubFormFieldGroup formFieldGroupsItem) {
        if (this.formFieldGroups == null) {
            this.formFieldGroups = new ArrayList<SubFormFieldGroup>();
        }
        this.formFieldGroups.add(formFieldGroupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="form_field_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubFormFieldGroup> getFormFieldGroups() {
        return this.formFieldGroups;
    }

    @JsonProperty(value="form_field_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFieldGroups(List<SubFormFieldGroup> formFieldGroups) {
        this.formFieldGroups = formFieldGroups;
    }

    public UnclaimedDraftCreateRequest formFieldRules(List<SubFormFieldRule> formFieldRules) {
        this.formFieldRules = formFieldRules;
        return this;
    }

    public UnclaimedDraftCreateRequest addFormFieldRulesItem(SubFormFieldRule formFieldRulesItem) {
        if (this.formFieldRules == null) {
            this.formFieldRules = new ArrayList<SubFormFieldRule>();
        }
        this.formFieldRules.add(formFieldRulesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="form_field_rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubFormFieldRule> getFormFieldRules() {
        return this.formFieldRules;
    }

    @JsonProperty(value="form_field_rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFieldRules(List<SubFormFieldRule> formFieldRules) {
        this.formFieldRules = formFieldRules;
    }

    public UnclaimedDraftCreateRequest formFieldsPerDocument(List<SubFormFieldsPerDocumentBase> formFieldsPerDocument) {
        this.formFieldsPerDocument = formFieldsPerDocument;
        return this;
    }

    public UnclaimedDraftCreateRequest addFormFieldsPerDocumentItem(SubFormFieldsPerDocumentBase formFieldsPerDocumentItem) {
        if (this.formFieldsPerDocument == null) {
            this.formFieldsPerDocument = new ArrayList<SubFormFieldsPerDocumentBase>();
        }
        this.formFieldsPerDocument.add(formFieldsPerDocumentItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="form_fields_per_document")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubFormFieldsPerDocumentBase> getFormFieldsPerDocument() {
        return this.formFieldsPerDocument;
    }

    @JsonProperty(value="form_fields_per_document")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFieldsPerDocument(List<SubFormFieldsPerDocumentBase> formFieldsPerDocument) {
        this.formFieldsPerDocument = formFieldsPerDocument;
    }

    public UnclaimedDraftCreateRequest hideTextTags(Boolean hideTextTags) {
        this.hideTextTags = hideTextTags;
        return this;
    }

    @Nullable
    @JsonProperty(value="hide_text_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideTextTags() {
        return this.hideTextTags;
    }

    @JsonProperty(value="hide_text_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideTextTags(Boolean hideTextTags) {
        this.hideTextTags = hideTextTags;
    }

    public UnclaimedDraftCreateRequest message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public UnclaimedDraftCreateRequest metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public UnclaimedDraftCreateRequest putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public UnclaimedDraftCreateRequest showProgressStepper(Boolean showProgressStepper) {
        this.showProgressStepper = showProgressStepper;
        return this;
    }

    @Nullable
    @JsonProperty(value="show_progress_stepper")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowProgressStepper() {
        return this.showProgressStepper;
    }

    @JsonProperty(value="show_progress_stepper")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowProgressStepper(Boolean showProgressStepper) {
        this.showProgressStepper = showProgressStepper;
    }

    public UnclaimedDraftCreateRequest signers(List<SubUnclaimedDraftSigner> signers) {
        this.signers = signers;
        return this;
    }

    public UnclaimedDraftCreateRequest addSignersItem(SubUnclaimedDraftSigner signersItem) {
        if (this.signers == null) {
            this.signers = new ArrayList<SubUnclaimedDraftSigner>();
        }
        this.signers.add(signersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="signers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubUnclaimedDraftSigner> getSigners() {
        return this.signers;
    }

    @JsonProperty(value="signers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigners(List<SubUnclaimedDraftSigner> signers) {
        this.signers = signers;
    }

    public UnclaimedDraftCreateRequest signingOptions(SubSigningOptions signingOptions) {
        this.signingOptions = signingOptions;
        return this;
    }

    @Nullable
    @JsonProperty(value="signing_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubSigningOptions getSigningOptions() {
        return this.signingOptions;
    }

    @JsonProperty(value="signing_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigningOptions(SubSigningOptions signingOptions) {
        this.signingOptions = signingOptions;
    }

    public UnclaimedDraftCreateRequest signingRedirectUrl(String signingRedirectUrl) {
        this.signingRedirectUrl = signingRedirectUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="signing_redirect_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSigningRedirectUrl() {
        return this.signingRedirectUrl;
    }

    @JsonProperty(value="signing_redirect_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigningRedirectUrl(String signingRedirectUrl) {
        this.signingRedirectUrl = signingRedirectUrl;
    }

    public UnclaimedDraftCreateRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public UnclaimedDraftCreateRequest testMode(Boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="test_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTestMode() {
        return this.testMode;
    }

    @JsonProperty(value="test_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public UnclaimedDraftCreateRequest usePreexistingFields(Boolean usePreexistingFields) {
        this.usePreexistingFields = usePreexistingFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="use_preexisting_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUsePreexistingFields() {
        return this.usePreexistingFields;
    }

    @JsonProperty(value="use_preexisting_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsePreexistingFields(Boolean usePreexistingFields) {
        this.usePreexistingFields = usePreexistingFields;
    }

    public UnclaimedDraftCreateRequest useTextTags(Boolean useTextTags) {
        this.useTextTags = useTextTags;
        return this;
    }

    @Nullable
    @JsonProperty(value="use_text_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseTextTags() {
        return this.useTextTags;
    }

    @JsonProperty(value="use_text_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseTextTags(Boolean useTextTags) {
        this.useTextTags = useTextTags;
    }

    public UnclaimedDraftCreateRequest expiresAt(Integer expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(Integer expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnclaimedDraftCreateRequest unclaimedDraftCreateRequest = (UnclaimedDraftCreateRequest)o;
        return Objects.equals((Object)this.type, (Object)unclaimedDraftCreateRequest.type) && Objects.equals(this.files, unclaimedDraftCreateRequest.files) && Objects.equals(this.fileUrls, unclaimedDraftCreateRequest.fileUrls) && Objects.equals(this.allowDecline, unclaimedDraftCreateRequest.allowDecline) && Objects.equals(this.attachments, unclaimedDraftCreateRequest.attachments) && Objects.equals(this.ccEmailAddresses, unclaimedDraftCreateRequest.ccEmailAddresses) && Objects.equals(this.clientId, unclaimedDraftCreateRequest.clientId) && Objects.equals(this.customFields, unclaimedDraftCreateRequest.customFields) && Objects.equals(this.fieldOptions, unclaimedDraftCreateRequest.fieldOptions) && Objects.equals(this.formFieldGroups, unclaimedDraftCreateRequest.formFieldGroups) && Objects.equals(this.formFieldRules, unclaimedDraftCreateRequest.formFieldRules) && Objects.equals(this.formFieldsPerDocument, unclaimedDraftCreateRequest.formFieldsPerDocument) && Objects.equals(this.hideTextTags, unclaimedDraftCreateRequest.hideTextTags) && Objects.equals(this.message, unclaimedDraftCreateRequest.message) && Objects.equals(this.metadata, unclaimedDraftCreateRequest.metadata) && Objects.equals(this.showProgressStepper, unclaimedDraftCreateRequest.showProgressStepper) && Objects.equals(this.signers, unclaimedDraftCreateRequest.signers) && Objects.equals(this.signingOptions, unclaimedDraftCreateRequest.signingOptions) && Objects.equals(this.signingRedirectUrl, unclaimedDraftCreateRequest.signingRedirectUrl) && Objects.equals(this.subject, unclaimedDraftCreateRequest.subject) && Objects.equals(this.testMode, unclaimedDraftCreateRequest.testMode) && Objects.equals(this.usePreexistingFields, unclaimedDraftCreateRequest.usePreexistingFields) && Objects.equals(this.useTextTags, unclaimedDraftCreateRequest.useTextTags) && Objects.equals(this.expiresAt, unclaimedDraftCreateRequest.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.files, this.fileUrls, this.allowDecline, this.attachments, this.ccEmailAddresses, this.clientId, this.customFields, this.fieldOptions, this.formFieldGroups, this.formFieldRules, this.formFieldsPerDocument, this.hideTextTags, this.message, this.metadata, this.showProgressStepper, this.signers, this.signingOptions, this.signingRedirectUrl, this.subject, this.testMode, this.usePreexistingFields, this.useTextTags, this.expiresAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnclaimedDraftCreateRequest {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    fileUrls: ").append(this.toIndentedString(this.fileUrls)).append("\n");
        sb.append("    allowDecline: ").append(this.toIndentedString(this.allowDecline)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    ccEmailAddresses: ").append(this.toIndentedString(this.ccEmailAddresses)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    fieldOptions: ").append(this.toIndentedString(this.fieldOptions)).append("\n");
        sb.append("    formFieldGroups: ").append(this.toIndentedString(this.formFieldGroups)).append("\n");
        sb.append("    formFieldRules: ").append(this.toIndentedString(this.formFieldRules)).append("\n");
        sb.append("    formFieldsPerDocument: ").append(this.toIndentedString(this.formFieldsPerDocument)).append("\n");
        sb.append("    hideTextTags: ").append(this.toIndentedString(this.hideTextTags)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    showProgressStepper: ").append(this.toIndentedString(this.showProgressStepper)).append("\n");
        sb.append("    signers: ").append(this.toIndentedString(this.signers)).append("\n");
        sb.append("    signingOptions: ").append(this.toIndentedString(this.signingOptions)).append("\n");
        sb.append("    signingRedirectUrl: ").append(this.toIndentedString(this.signingRedirectUrl)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    testMode: ").append(this.toIndentedString(this.testMode)).append("\n");
        sb.append("    usePreexistingFields: ").append(this.toIndentedString(this.usePreexistingFields)).append("\n");
        sb.append("    useTextTags: ").append(this.toIndentedString(this.useTextTags)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.type != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.type)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.type)).getClass().equals(File.class) || ((Object)((Object)this.type)).getClass().equals(Integer.class) || ((Object)((Object)this.type)).getClass().equals(String.class) || ((Object)((Object)this.type)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TYPE, (Object)this.type);
                } else if (this.isListOfFile((Object)this.type)) {
                    for (i = 0; i < this.getListSize((Object)this.type); ++i) {
                        map.put("type[" + i + "]", this.getFromList((Object)this.type, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.type));
                }
            }
            if (this.files != null) {
                if (this.isFileTypeOrListOfFiles(this.files)) {
                    fileTypeFound = true;
                }
                if (this.files.getClass().equals(File.class) || this.files.getClass().equals(Integer.class) || this.files.getClass().equals(String.class) || this.files.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILES, this.files);
                } else if (this.isListOfFile(this.files)) {
                    for (i = 0; i < this.getListSize(this.files); ++i) {
                        map.put("files[" + i + "]", this.getFromList(this.files, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILES, JSON.getDefault().getMapper().writeValueAsString(this.files));
                }
            }
            if (this.fileUrls != null) {
                if (this.isFileTypeOrListOfFiles(this.fileUrls)) {
                    fileTypeFound = true;
                }
                if (this.fileUrls.getClass().equals(File.class) || this.fileUrls.getClass().equals(Integer.class) || this.fileUrls.getClass().equals(String.class) || this.fileUrls.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILE_URLS, this.fileUrls);
                } else if (this.isListOfFile(this.fileUrls)) {
                    for (i = 0; i < this.getListSize(this.fileUrls); ++i) {
                        map.put("file_urls[" + i + "]", this.getFromList(this.fileUrls, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILE_URLS, JSON.getDefault().getMapper().writeValueAsString(this.fileUrls));
                }
            }
            if (this.allowDecline != null) {
                if (this.isFileTypeOrListOfFiles(this.allowDecline)) {
                    fileTypeFound = true;
                }
                if (this.allowDecline.getClass().equals(File.class) || this.allowDecline.getClass().equals(Integer.class) || this.allowDecline.getClass().equals(String.class) || this.allowDecline.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ALLOW_DECLINE, this.allowDecline);
                } else if (this.isListOfFile(this.allowDecline)) {
                    for (i = 0; i < this.getListSize(this.allowDecline); ++i) {
                        map.put("allow_decline[" + i + "]", this.getFromList(this.allowDecline, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ALLOW_DECLINE, JSON.getDefault().getMapper().writeValueAsString((Object)this.allowDecline));
                }
            }
            if (this.attachments != null) {
                if (this.isFileTypeOrListOfFiles(this.attachments)) {
                    fileTypeFound = true;
                }
                if (this.attachments.getClass().equals(File.class) || this.attachments.getClass().equals(Integer.class) || this.attachments.getClass().equals(String.class) || this.attachments.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ATTACHMENTS, this.attachments);
                } else if (this.isListOfFile(this.attachments)) {
                    for (i = 0; i < this.getListSize(this.attachments); ++i) {
                        map.put("attachments[" + i + "]", this.getFromList(this.attachments, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ATTACHMENTS, JSON.getDefault().getMapper().writeValueAsString(this.attachments));
                }
            }
            if (this.ccEmailAddresses != null) {
                if (this.isFileTypeOrListOfFiles(this.ccEmailAddresses)) {
                    fileTypeFound = true;
                }
                if (this.ccEmailAddresses.getClass().equals(File.class) || this.ccEmailAddresses.getClass().equals(Integer.class) || this.ccEmailAddresses.getClass().equals(String.class) || this.ccEmailAddresses.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CC_EMAIL_ADDRESSES, this.ccEmailAddresses);
                } else if (this.isListOfFile(this.ccEmailAddresses)) {
                    for (i = 0; i < this.getListSize(this.ccEmailAddresses); ++i) {
                        map.put("cc_email_addresses[" + i + "]", this.getFromList(this.ccEmailAddresses, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CC_EMAIL_ADDRESSES, JSON.getDefault().getMapper().writeValueAsString(this.ccEmailAddresses));
                }
            }
            if (this.clientId != null) {
                if (this.isFileTypeOrListOfFiles(this.clientId)) {
                    fileTypeFound = true;
                }
                if (this.clientId.getClass().equals(File.class) || this.clientId.getClass().equals(Integer.class) || this.clientId.getClass().equals(String.class) || this.clientId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_ID, this.clientId);
                } else if (this.isListOfFile(this.clientId)) {
                    for (i = 0; i < this.getListSize(this.clientId); ++i) {
                        map.put("client_id[" + i + "]", this.getFromList(this.clientId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientId));
                }
            }
            if (this.customFields != null) {
                if (this.isFileTypeOrListOfFiles(this.customFields)) {
                    fileTypeFound = true;
                }
                if (this.customFields.getClass().equals(File.class) || this.customFields.getClass().equals(Integer.class) || this.customFields.getClass().equals(String.class) || this.customFields.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CUSTOM_FIELDS, this.customFields);
                } else if (this.isListOfFile(this.customFields)) {
                    for (i = 0; i < this.getListSize(this.customFields); ++i) {
                        map.put("custom_fields[" + i + "]", this.getFromList(this.customFields, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CUSTOM_FIELDS, JSON.getDefault().getMapper().writeValueAsString(this.customFields));
                }
            }
            if (this.fieldOptions != null) {
                if (this.isFileTypeOrListOfFiles(this.fieldOptions)) {
                    fileTypeFound = true;
                }
                if (this.fieldOptions.getClass().equals(File.class) || this.fieldOptions.getClass().equals(Integer.class) || this.fieldOptions.getClass().equals(String.class) || this.fieldOptions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FIELD_OPTIONS, this.fieldOptions);
                } else if (this.isListOfFile(this.fieldOptions)) {
                    for (i = 0; i < this.getListSize(this.fieldOptions); ++i) {
                        map.put("field_options[" + i + "]", this.getFromList(this.fieldOptions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FIELD_OPTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.fieldOptions));
                }
            }
            if (this.formFieldGroups != null) {
                if (this.isFileTypeOrListOfFiles(this.formFieldGroups)) {
                    fileTypeFound = true;
                }
                if (this.formFieldGroups.getClass().equals(File.class) || this.formFieldGroups.getClass().equals(Integer.class) || this.formFieldGroups.getClass().equals(String.class) || this.formFieldGroups.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FORM_FIELD_GROUPS, this.formFieldGroups);
                } else if (this.isListOfFile(this.formFieldGroups)) {
                    for (i = 0; i < this.getListSize(this.formFieldGroups); ++i) {
                        map.put("form_field_groups[" + i + "]", this.getFromList(this.formFieldGroups, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FORM_FIELD_GROUPS, JSON.getDefault().getMapper().writeValueAsString(this.formFieldGroups));
                }
            }
            if (this.formFieldRules != null) {
                if (this.isFileTypeOrListOfFiles(this.formFieldRules)) {
                    fileTypeFound = true;
                }
                if (this.formFieldRules.getClass().equals(File.class) || this.formFieldRules.getClass().equals(Integer.class) || this.formFieldRules.getClass().equals(String.class) || this.formFieldRules.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FORM_FIELD_RULES, this.formFieldRules);
                } else if (this.isListOfFile(this.formFieldRules)) {
                    for (i = 0; i < this.getListSize(this.formFieldRules); ++i) {
                        map.put("form_field_rules[" + i + "]", this.getFromList(this.formFieldRules, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FORM_FIELD_RULES, JSON.getDefault().getMapper().writeValueAsString(this.formFieldRules));
                }
            }
            if (this.formFieldsPerDocument != null) {
                if (this.isFileTypeOrListOfFiles(this.formFieldsPerDocument)) {
                    fileTypeFound = true;
                }
                if (this.formFieldsPerDocument.getClass().equals(File.class) || this.formFieldsPerDocument.getClass().equals(Integer.class) || this.formFieldsPerDocument.getClass().equals(String.class) || this.formFieldsPerDocument.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT, this.formFieldsPerDocument);
                } else if (this.isListOfFile(this.formFieldsPerDocument)) {
                    for (i = 0; i < this.getListSize(this.formFieldsPerDocument); ++i) {
                        map.put("form_fields_per_document[" + i + "]", this.getFromList(this.formFieldsPerDocument, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT, JSON.getDefault().getMapper().writeValueAsString(this.formFieldsPerDocument));
                }
            }
            if (this.hideTextTags != null) {
                if (this.isFileTypeOrListOfFiles(this.hideTextTags)) {
                    fileTypeFound = true;
                }
                if (this.hideTextTags.getClass().equals(File.class) || this.hideTextTags.getClass().equals(Integer.class) || this.hideTextTags.getClass().equals(String.class) || this.hideTextTags.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_HIDE_TEXT_TAGS, this.hideTextTags);
                } else if (this.isListOfFile(this.hideTextTags)) {
                    for (i = 0; i < this.getListSize(this.hideTextTags); ++i) {
                        map.put("hide_text_tags[" + i + "]", this.getFromList(this.hideTextTags, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_HIDE_TEXT_TAGS, JSON.getDefault().getMapper().writeValueAsString((Object)this.hideTextTags));
                }
            }
            if (this.message != null) {
                if (this.isFileTypeOrListOfFiles(this.message)) {
                    fileTypeFound = true;
                }
                if (this.message.getClass().equals(File.class) || this.message.getClass().equals(Integer.class) || this.message.getClass().equals(String.class) || this.message.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_MESSAGE, this.message);
                } else if (this.isListOfFile(this.message)) {
                    for (i = 0; i < this.getListSize(this.message); ++i) {
                        map.put("message[" + i + "]", this.getFromList(this.message, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_MESSAGE, JSON.getDefault().getMapper().writeValueAsString((Object)this.message));
                }
            }
            if (this.metadata != null) {
                if (this.isFileTypeOrListOfFiles(this.metadata)) {
                    fileTypeFound = true;
                }
                if (this.metadata.getClass().equals(File.class) || this.metadata.getClass().equals(Integer.class) || this.metadata.getClass().equals(String.class) || this.metadata.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_METADATA, this.metadata);
                } else if (this.isListOfFile(this.metadata)) {
                    for (i = 0; i < this.getListSize(this.metadata); ++i) {
                        map.put("metadata[" + i + "]", this.getFromList(this.metadata, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_METADATA, JSON.getDefault().getMapper().writeValueAsString(this.metadata));
                }
            }
            if (this.showProgressStepper != null) {
                if (this.isFileTypeOrListOfFiles(this.showProgressStepper)) {
                    fileTypeFound = true;
                }
                if (this.showProgressStepper.getClass().equals(File.class) || this.showProgressStepper.getClass().equals(Integer.class) || this.showProgressStepper.getClass().equals(String.class) || this.showProgressStepper.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SHOW_PROGRESS_STEPPER, this.showProgressStepper);
                } else if (this.isListOfFile(this.showProgressStepper)) {
                    for (i = 0; i < this.getListSize(this.showProgressStepper); ++i) {
                        map.put("show_progress_stepper[" + i + "]", this.getFromList(this.showProgressStepper, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SHOW_PROGRESS_STEPPER, JSON.getDefault().getMapper().writeValueAsString((Object)this.showProgressStepper));
                }
            }
            if (this.signers != null) {
                if (this.isFileTypeOrListOfFiles(this.signers)) {
                    fileTypeFound = true;
                }
                if (this.signers.getClass().equals(File.class) || this.signers.getClass().equals(Integer.class) || this.signers.getClass().equals(String.class) || this.signers.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNERS, this.signers);
                } else if (this.isListOfFile(this.signers)) {
                    for (i = 0; i < this.getListSize(this.signers); ++i) {
                        map.put("signers[" + i + "]", this.getFromList(this.signers, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNERS, JSON.getDefault().getMapper().writeValueAsString(this.signers));
                }
            }
            if (this.signingOptions != null) {
                if (this.isFileTypeOrListOfFiles(this.signingOptions)) {
                    fileTypeFound = true;
                }
                if (this.signingOptions.getClass().equals(File.class) || this.signingOptions.getClass().equals(Integer.class) || this.signingOptions.getClass().equals(String.class) || this.signingOptions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNING_OPTIONS, this.signingOptions);
                } else if (this.isListOfFile(this.signingOptions)) {
                    for (i = 0; i < this.getListSize(this.signingOptions); ++i) {
                        map.put("signing_options[" + i + "]", this.getFromList(this.signingOptions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNING_OPTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.signingOptions));
                }
            }
            if (this.signingRedirectUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.signingRedirectUrl)) {
                    fileTypeFound = true;
                }
                if (this.signingRedirectUrl.getClass().equals(File.class) || this.signingRedirectUrl.getClass().equals(Integer.class) || this.signingRedirectUrl.getClass().equals(String.class) || this.signingRedirectUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNING_REDIRECT_URL, this.signingRedirectUrl);
                } else if (this.isListOfFile(this.signingRedirectUrl)) {
                    for (i = 0; i < this.getListSize(this.signingRedirectUrl); ++i) {
                        map.put("signing_redirect_url[" + i + "]", this.getFromList(this.signingRedirectUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNING_REDIRECT_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.signingRedirectUrl));
                }
            }
            if (this.subject != null) {
                if (this.isFileTypeOrListOfFiles(this.subject)) {
                    fileTypeFound = true;
                }
                if (this.subject.getClass().equals(File.class) || this.subject.getClass().equals(Integer.class) || this.subject.getClass().equals(String.class) || this.subject.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SUBJECT, this.subject);
                } else if (this.isListOfFile(this.subject)) {
                    for (i = 0; i < this.getListSize(this.subject); ++i) {
                        map.put("subject[" + i + "]", this.getFromList(this.subject, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SUBJECT, JSON.getDefault().getMapper().writeValueAsString((Object)this.subject));
                }
            }
            if (this.testMode != null) {
                if (this.isFileTypeOrListOfFiles(this.testMode)) {
                    fileTypeFound = true;
                }
                if (this.testMode.getClass().equals(File.class) || this.testMode.getClass().equals(Integer.class) || this.testMode.getClass().equals(String.class) || this.testMode.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEST_MODE, this.testMode);
                } else if (this.isListOfFile(this.testMode)) {
                    for (i = 0; i < this.getListSize(this.testMode); ++i) {
                        map.put("test_mode[" + i + "]", this.getFromList(this.testMode, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEST_MODE, JSON.getDefault().getMapper().writeValueAsString((Object)this.testMode));
                }
            }
            if (this.usePreexistingFields != null) {
                if (this.isFileTypeOrListOfFiles(this.usePreexistingFields)) {
                    fileTypeFound = true;
                }
                if (this.usePreexistingFields.getClass().equals(File.class) || this.usePreexistingFields.getClass().equals(Integer.class) || this.usePreexistingFields.getClass().equals(String.class) || this.usePreexistingFields.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_USE_PREEXISTING_FIELDS, this.usePreexistingFields);
                } else if (this.isListOfFile(this.usePreexistingFields)) {
                    for (i = 0; i < this.getListSize(this.usePreexistingFields); ++i) {
                        map.put("use_preexisting_fields[" + i + "]", this.getFromList(this.usePreexistingFields, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_USE_PREEXISTING_FIELDS, JSON.getDefault().getMapper().writeValueAsString((Object)this.usePreexistingFields));
                }
            }
            if (this.useTextTags != null) {
                if (this.isFileTypeOrListOfFiles(this.useTextTags)) {
                    fileTypeFound = true;
                }
                if (this.useTextTags.getClass().equals(File.class) || this.useTextTags.getClass().equals(Integer.class) || this.useTextTags.getClass().equals(String.class) || this.useTextTags.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_USE_TEXT_TAGS, this.useTextTags);
                } else if (this.isListOfFile(this.useTextTags)) {
                    for (i = 0; i < this.getListSize(this.useTextTags); ++i) {
                        map.put("use_text_tags[" + i + "]", this.getFromList(this.useTextTags, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_USE_TEXT_TAGS, JSON.getDefault().getMapper().writeValueAsString((Object)this.useTextTags));
                }
            }
            if (this.expiresAt != null) {
                if (this.isFileTypeOrListOfFiles(this.expiresAt)) {
                    fileTypeFound = true;
                }
                if (this.expiresAt.getClass().equals(File.class) || this.expiresAt.getClass().equals(Integer.class) || this.expiresAt.getClass().equals(String.class) || this.expiresAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EXPIRES_AT, this.expiresAt);
                } else if (this.isListOfFile(this.expiresAt)) {
                    for (i = 0; i < this.getListSize(this.expiresAt); ++i) {
                        map.put("expires_at[" + i + "]", this.getFromList(this.expiresAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EXPIRES_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.expiresAt));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SEND_DOCUMENT("send_document"),
        REQUEST_SIGNATURE("request_signature");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

