/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"template_id", "warnings"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateUpdateFilesResponseTemplate {
    public static final String JSON_PROPERTY_TEMPLATE_ID = "template_id";
    private String templateId;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    @Deprecated
    private List<WarningResponse> warnings = null;

    public static TemplateUpdateFilesResponseTemplate init(String jsonData) throws Exception {
        return (TemplateUpdateFilesResponseTemplate)new ObjectMapper().readValue(jsonData, TemplateUpdateFilesResponseTemplate.class);
    }

    public static TemplateUpdateFilesResponseTemplate init(HashMap data) throws Exception {
        return (TemplateUpdateFilesResponseTemplate)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TemplateUpdateFilesResponseTemplate.class);
    }

    public TemplateUpdateFilesResponseTemplate templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @Nullable
    @JsonProperty(value="template_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTemplateId() {
        return this.templateId;
    }

    @JsonProperty(value="template_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @Deprecated
    public TemplateUpdateFilesResponseTemplate warnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
        return this;
    }

    public TemplateUpdateFilesResponseTemplate addWarningsItem(WarningResponse warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<WarningResponse>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WarningResponse> getWarnings() {
        return this.warnings;
    }

    @Deprecated
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateUpdateFilesResponseTemplate templateUpdateFilesResponseTemplate = (TemplateUpdateFilesResponseTemplate)o;
        return Objects.equals(this.templateId, templateUpdateFilesResponseTemplate.templateId) && Objects.equals(this.warnings, templateUpdateFilesResponseTemplate.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateUpdateFilesResponseTemplate {\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.templateId != null) {
                if (this.isFileTypeOrListOfFiles(this.templateId)) {
                    fileTypeFound = true;
                }
                if (this.templateId.getClass().equals(File.class) || this.templateId.getClass().equals(Integer.class) || this.templateId.getClass().equals(String.class) || this.templateId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEMPLATE_ID, this.templateId);
                } else if (this.isListOfFile(this.templateId)) {
                    for (i = 0; i < this.getListSize(this.templateId); ++i) {
                        map.put("template_id[" + i + "]", this.getFromList(this.templateId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEMPLATE_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.templateId));
                }
            }
            if (this.warnings != null) {
                if (this.isFileTypeOrListOfFiles(this.warnings)) {
                    fileTypeFound = true;
                }
                if (this.warnings.getClass().equals(File.class) || this.warnings.getClass().equals(Integer.class) || this.warnings.getClass().equals(String.class) || this.warnings.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WARNINGS, this.warnings);
                } else if (this.isListOfFile(this.warnings)) {
                    for (i = 0; i < this.getListSize(this.warnings); ++i) {
                        map.put("warnings[" + i + "]", this.getFromList(this.warnings, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WARNINGS, JSON.getDefault().getMapper().writeValueAsString(this.warnings));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

