/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.ListInfoResponse;
import com.dropbox.sign.model.SubTeamResponse;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"sub_teams", "list_info", "warnings"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamSubTeamsResponse {
    public static final String JSON_PROPERTY_SUB_TEAMS = "sub_teams";
    private List<SubTeamResponse> subTeams = new ArrayList<SubTeamResponse>();
    public static final String JSON_PROPERTY_LIST_INFO = "list_info";
    private ListInfoResponse listInfo;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<WarningResponse> warnings = null;

    public static TeamSubTeamsResponse init(String jsonData) throws Exception {
        return (TeamSubTeamsResponse)new ObjectMapper().readValue(jsonData, TeamSubTeamsResponse.class);
    }

    public static TeamSubTeamsResponse init(HashMap data) throws Exception {
        return (TeamSubTeamsResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TeamSubTeamsResponse.class);
    }

    public TeamSubTeamsResponse subTeams(List<SubTeamResponse> subTeams) {
        this.subTeams = subTeams;
        return this;
    }

    public TeamSubTeamsResponse addSubTeamsItem(SubTeamResponse subTeamsItem) {
        if (this.subTeams == null) {
            this.subTeams = new ArrayList<SubTeamResponse>();
        }
        this.subTeams.add(subTeamsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="sub_teams")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SubTeamResponse> getSubTeams() {
        return this.subTeams;
    }

    @JsonProperty(value="sub_teams")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubTeams(List<SubTeamResponse> subTeams) {
        this.subTeams = subTeams;
    }

    public TeamSubTeamsResponse listInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
        return this;
    }

    @Nonnull
    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListInfoResponse getListInfo() {
        return this.listInfo;
    }

    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
    }

    public TeamSubTeamsResponse warnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
        return this;
    }

    public TeamSubTeamsResponse addWarningsItem(WarningResponse warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<WarningResponse>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WarningResponse> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamSubTeamsResponse teamSubTeamsResponse = (TeamSubTeamsResponse)o;
        return Objects.equals(this.subTeams, teamSubTeamsResponse.subTeams) && Objects.equals(this.listInfo, teamSubTeamsResponse.listInfo) && Objects.equals(this.warnings, teamSubTeamsResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.subTeams, this.listInfo, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamSubTeamsResponse {\n");
        sb.append("    subTeams: ").append(this.toIndentedString(this.subTeams)).append("\n");
        sb.append("    listInfo: ").append(this.toIndentedString(this.listInfo)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.subTeams != null) {
                if (this.isFileTypeOrListOfFiles(this.subTeams)) {
                    fileTypeFound = true;
                }
                if (this.subTeams.getClass().equals(File.class) || this.subTeams.getClass().equals(Integer.class) || this.subTeams.getClass().equals(String.class) || this.subTeams.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SUB_TEAMS, this.subTeams);
                } else if (this.isListOfFile(this.subTeams)) {
                    for (i = 0; i < this.getListSize(this.subTeams); ++i) {
                        map.put("sub_teams[" + i + "]", this.getFromList(this.subTeams, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SUB_TEAMS, JSON.getDefault().getMapper().writeValueAsString(this.subTeams));
                }
            }
            if (this.listInfo != null) {
                if (this.isFileTypeOrListOfFiles(this.listInfo)) {
                    fileTypeFound = true;
                }
                if (this.listInfo.getClass().equals(File.class) || this.listInfo.getClass().equals(Integer.class) || this.listInfo.getClass().equals(String.class) || this.listInfo.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LIST_INFO, this.listInfo);
                } else if (this.isListOfFile(this.listInfo)) {
                    for (i = 0; i < this.getListSize(this.listInfo); ++i) {
                        map.put("list_info[" + i + "]", this.getFromList(this.listInfo, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LIST_INFO, JSON.getDefault().getMapper().writeValueAsString((Object)this.listInfo));
                }
            }
            if (this.warnings != null) {
                if (this.isFileTypeOrListOfFiles(this.warnings)) {
                    fileTypeFound = true;
                }
                if (this.warnings.getClass().equals(File.class) || this.warnings.getClass().equals(Integer.class) || this.warnings.getClass().equals(String.class) || this.warnings.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WARNINGS, this.warnings);
                } else if (this.isListOfFile(this.warnings)) {
                    for (i = 0; i < this.getListSize(this.warnings); ++i) {
                        map.put("warnings[" + i + "]", this.getFromList(this.warnings, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WARNINGS, JSON.getDefault().getMapper().writeValueAsString(this.warnings));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

