/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.AccountResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "accounts", "invited_accounts", "invited_emails"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamResponse {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ACCOUNTS = "accounts";
    private List<AccountResponse> accounts = null;
    public static final String JSON_PROPERTY_INVITED_ACCOUNTS = "invited_accounts";
    private List<AccountResponse> invitedAccounts = null;
    public static final String JSON_PROPERTY_INVITED_EMAILS = "invited_emails";
    private List<String> invitedEmails = null;

    public static TeamResponse init(String jsonData) throws Exception {
        return (TeamResponse)new ObjectMapper().readValue(jsonData, TeamResponse.class);
    }

    public static TeamResponse init(HashMap data) throws Exception {
        return (TeamResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TeamResponse.class);
    }

    public TeamResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TeamResponse accounts(List<AccountResponse> accounts) {
        this.accounts = accounts;
        return this;
    }

    public TeamResponse addAccountsItem(AccountResponse accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<AccountResponse>();
        }
        this.accounts.add(accountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccountResponse> getAccounts() {
        return this.accounts;
    }

    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccounts(List<AccountResponse> accounts) {
        this.accounts = accounts;
    }

    public TeamResponse invitedAccounts(List<AccountResponse> invitedAccounts) {
        this.invitedAccounts = invitedAccounts;
        return this;
    }

    public TeamResponse addInvitedAccountsItem(AccountResponse invitedAccountsItem) {
        if (this.invitedAccounts == null) {
            this.invitedAccounts = new ArrayList<AccountResponse>();
        }
        this.invitedAccounts.add(invitedAccountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="invited_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccountResponse> getInvitedAccounts() {
        return this.invitedAccounts;
    }

    @JsonProperty(value="invited_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvitedAccounts(List<AccountResponse> invitedAccounts) {
        this.invitedAccounts = invitedAccounts;
    }

    public TeamResponse invitedEmails(List<String> invitedEmails) {
        this.invitedEmails = invitedEmails;
        return this;
    }

    public TeamResponse addInvitedEmailsItem(String invitedEmailsItem) {
        if (this.invitedEmails == null) {
            this.invitedEmails = new ArrayList<String>();
        }
        this.invitedEmails.add(invitedEmailsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="invited_emails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInvitedEmails() {
        return this.invitedEmails;
    }

    @JsonProperty(value="invited_emails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvitedEmails(List<String> invitedEmails) {
        this.invitedEmails = invitedEmails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamResponse teamResponse = (TeamResponse)o;
        return Objects.equals(this.name, teamResponse.name) && Objects.equals(this.accounts, teamResponse.accounts) && Objects.equals(this.invitedAccounts, teamResponse.invitedAccounts) && Objects.equals(this.invitedEmails, teamResponse.invitedEmails);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.accounts, this.invitedAccounts, this.invitedEmails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamResponse {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    invitedAccounts: ").append(this.toIndentedString(this.invitedAccounts)).append("\n");
        sb.append("    invitedEmails: ").append(this.toIndentedString(this.invitedEmails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
            if (this.accounts != null) {
                if (this.isFileTypeOrListOfFiles(this.accounts)) {
                    fileTypeFound = true;
                }
                if (this.accounts.getClass().equals(File.class) || this.accounts.getClass().equals(Integer.class) || this.accounts.getClass().equals(String.class) || this.accounts.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACCOUNTS, this.accounts);
                } else if (this.isListOfFile(this.accounts)) {
                    for (i = 0; i < this.getListSize(this.accounts); ++i) {
                        map.put("accounts[" + i + "]", this.getFromList(this.accounts, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACCOUNTS, JSON.getDefault().getMapper().writeValueAsString(this.accounts));
                }
            }
            if (this.invitedAccounts != null) {
                if (this.isFileTypeOrListOfFiles(this.invitedAccounts)) {
                    fileTypeFound = true;
                }
                if (this.invitedAccounts.getClass().equals(File.class) || this.invitedAccounts.getClass().equals(Integer.class) || this.invitedAccounts.getClass().equals(String.class) || this.invitedAccounts.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_INVITED_ACCOUNTS, this.invitedAccounts);
                } else if (this.isListOfFile(this.invitedAccounts)) {
                    for (i = 0; i < this.getListSize(this.invitedAccounts); ++i) {
                        map.put("invited_accounts[" + i + "]", this.getFromList(this.invitedAccounts, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_INVITED_ACCOUNTS, JSON.getDefault().getMapper().writeValueAsString(this.invitedAccounts));
                }
            }
            if (this.invitedEmails != null) {
                if (this.isFileTypeOrListOfFiles(this.invitedEmails)) {
                    fileTypeFound = true;
                }
                if (this.invitedEmails.getClass().equals(File.class) || this.invitedEmails.getClass().equals(Integer.class) || this.invitedEmails.getClass().equals(String.class) || this.invitedEmails.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_INVITED_EMAILS, this.invitedEmails);
                } else if (this.isListOfFile(this.invitedEmails)) {
                    for (i = 0; i < this.getListSize(this.invitedEmails); ++i) {
                        map.put("invited_emails[" + i + "]", this.getFromList(this.invitedEmails, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_INVITED_EMAILS, JSON.getDefault().getMapper().writeValueAsString(this.invitedEmails));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

