/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"team_id", "name"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamParentResponse {
    public static final String JSON_PROPERTY_TEAM_ID = "team_id";
    private String teamId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static TeamParentResponse init(String jsonData) throws Exception {
        return (TeamParentResponse)new ObjectMapper().readValue(jsonData, TeamParentResponse.class);
    }

    public static TeamParentResponse init(HashMap data) throws Exception {
        return (TeamParentResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TeamParentResponse.class);
    }

    public TeamParentResponse teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @Nullable
    @JsonProperty(value="team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeamId() {
        return this.teamId;
    }

    @JsonProperty(value="team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public TeamParentResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamParentResponse teamParentResponse = (TeamParentResponse)o;
        return Objects.equals(this.teamId, teamParentResponse.teamId) && Objects.equals(this.name, teamParentResponse.name);
    }

    public int hashCode() {
        return Objects.hash(this.teamId, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamParentResponse {\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.teamId != null) {
                if (this.isFileTypeOrListOfFiles(this.teamId)) {
                    fileTypeFound = true;
                }
                if (this.teamId.getClass().equals(File.class) || this.teamId.getClass().equals(Integer.class) || this.teamId.getClass().equals(String.class) || this.teamId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEAM_ID, this.teamId);
                } else if (this.isListOfFile(this.teamId)) {
                    for (i = 0; i < this.getListSize(this.teamId); ++i) {
                        map.put("team_id[" + i + "]", this.getFromList(this.teamId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEAM_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.teamId));
                }
            }
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

