/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"email_address", "team_id", "role", "sent_at", "redeemed_at", "expires_at"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamInviteResponse {
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;
    public static final String JSON_PROPERTY_TEAM_ID = "team_id";
    private String teamId;
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_SENT_AT = "sent_at";
    private Integer sentAt;
    public static final String JSON_PROPERTY_REDEEMED_AT = "redeemed_at";
    private Integer redeemedAt;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    private Integer expiresAt;

    public static TeamInviteResponse init(String jsonData) throws Exception {
        return (TeamInviteResponse)new ObjectMapper().readValue(jsonData, TeamInviteResponse.class);
    }

    public static TeamInviteResponse init(HashMap data) throws Exception {
        return (TeamInviteResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TeamInviteResponse.class);
    }

    public TeamInviteResponse emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public TeamInviteResponse teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @Nullable
    @JsonProperty(value="team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeamId() {
        return this.teamId;
    }

    @JsonProperty(value="team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public TeamInviteResponse role(String role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(String role) {
        this.role = role;
    }

    public TeamInviteResponse sentAt(Integer sentAt) {
        this.sentAt = sentAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="sent_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentAt() {
        return this.sentAt;
    }

    @JsonProperty(value="sent_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSentAt(Integer sentAt) {
        this.sentAt = sentAt;
    }

    public TeamInviteResponse redeemedAt(Integer redeemedAt) {
        this.redeemedAt = redeemedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="redeemed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRedeemedAt() {
        return this.redeemedAt;
    }

    @JsonProperty(value="redeemed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedeemedAt(Integer redeemedAt) {
        this.redeemedAt = redeemedAt;
    }

    public TeamInviteResponse expiresAt(Integer expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(Integer expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamInviteResponse teamInviteResponse = (TeamInviteResponse)o;
        return Objects.equals(this.emailAddress, teamInviteResponse.emailAddress) && Objects.equals(this.teamId, teamInviteResponse.teamId) && Objects.equals(this.role, teamInviteResponse.role) && Objects.equals(this.sentAt, teamInviteResponse.sentAt) && Objects.equals(this.redeemedAt, teamInviteResponse.redeemedAt) && Objects.equals(this.expiresAt, teamInviteResponse.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress, this.teamId, this.role, this.sentAt, this.redeemedAt, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamInviteResponse {\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    sentAt: ").append(this.toIndentedString(this.sentAt)).append("\n");
        sb.append("    redeemedAt: ").append(this.toIndentedString(this.redeemedAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.emailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.emailAddress)) {
                    fileTypeFound = true;
                }
                if (this.emailAddress.getClass().equals(File.class) || this.emailAddress.getClass().equals(Integer.class) || this.emailAddress.getClass().equals(String.class) || this.emailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, this.emailAddress);
                } else if (this.isListOfFile(this.emailAddress)) {
                    for (i = 0; i < this.getListSize(this.emailAddress); ++i) {
                        map.put("email_address[" + i + "]", this.getFromList(this.emailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.emailAddress));
                }
            }
            if (this.teamId != null) {
                if (this.isFileTypeOrListOfFiles(this.teamId)) {
                    fileTypeFound = true;
                }
                if (this.teamId.getClass().equals(File.class) || this.teamId.getClass().equals(Integer.class) || this.teamId.getClass().equals(String.class) || this.teamId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEAM_ID, this.teamId);
                } else if (this.isListOfFile(this.teamId)) {
                    for (i = 0; i < this.getListSize(this.teamId); ++i) {
                        map.put("team_id[" + i + "]", this.getFromList(this.teamId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEAM_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.teamId));
                }
            }
            if (this.role != null) {
                if (this.isFileTypeOrListOfFiles(this.role)) {
                    fileTypeFound = true;
                }
                if (this.role.getClass().equals(File.class) || this.role.getClass().equals(Integer.class) || this.role.getClass().equals(String.class) || this.role.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ROLE, this.role);
                } else if (this.isListOfFile(this.role)) {
                    for (i = 0; i < this.getListSize(this.role); ++i) {
                        map.put("role[" + i + "]", this.getFromList(this.role, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ROLE, JSON.getDefault().getMapper().writeValueAsString((Object)this.role));
                }
            }
            if (this.sentAt != null) {
                if (this.isFileTypeOrListOfFiles(this.sentAt)) {
                    fileTypeFound = true;
                }
                if (this.sentAt.getClass().equals(File.class) || this.sentAt.getClass().equals(Integer.class) || this.sentAt.getClass().equals(String.class) || this.sentAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SENT_AT, this.sentAt);
                } else if (this.isListOfFile(this.sentAt)) {
                    for (i = 0; i < this.getListSize(this.sentAt); ++i) {
                        map.put("sent_at[" + i + "]", this.getFromList(this.sentAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SENT_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.sentAt));
                }
            }
            if (this.redeemedAt != null) {
                if (this.isFileTypeOrListOfFiles(this.redeemedAt)) {
                    fileTypeFound = true;
                }
                if (this.redeemedAt.getClass().equals(File.class) || this.redeemedAt.getClass().equals(Integer.class) || this.redeemedAt.getClass().equals(String.class) || this.redeemedAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REDEEMED_AT, this.redeemedAt);
                } else if (this.isListOfFile(this.redeemedAt)) {
                    for (i = 0; i < this.getListSize(this.redeemedAt); ++i) {
                        map.put("redeemed_at[" + i + "]", this.getFromList(this.redeemedAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REDEEMED_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.redeemedAt));
                }
            }
            if (this.expiresAt != null) {
                if (this.isFileTypeOrListOfFiles(this.expiresAt)) {
                    fileTypeFound = true;
                }
                if (this.expiresAt.getClass().equals(File.class) || this.expiresAt.getClass().equals(Integer.class) || this.expiresAt.getClass().equals(String.class) || this.expiresAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EXPIRES_AT, this.expiresAt);
                } else if (this.isListOfFile(this.expiresAt)) {
                    for (i = 0; i < this.getListSize(this.expiresAt); ++i) {
                        map.put("expires_at[" + i + "]", this.getFromList(this.expiresAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EXPIRES_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.expiresAt));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

