/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.TeamParentResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"team_id", "team_parent", "name", "num_members", "num_sub_teams"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamInfoResponse {
    public static final String JSON_PROPERTY_TEAM_ID = "team_id";
    private String teamId;
    public static final String JSON_PROPERTY_TEAM_PARENT = "team_parent";
    private TeamParentResponse teamParent;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NUM_MEMBERS = "num_members";
    private Integer numMembers;
    public static final String JSON_PROPERTY_NUM_SUB_TEAMS = "num_sub_teams";
    private Integer numSubTeams;

    public static TeamInfoResponse init(String jsonData) throws Exception {
        return (TeamInfoResponse)new ObjectMapper().readValue(jsonData, TeamInfoResponse.class);
    }

    public static TeamInfoResponse init(HashMap data) throws Exception {
        return (TeamInfoResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TeamInfoResponse.class);
    }

    public TeamInfoResponse teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @Nullable
    @JsonProperty(value="team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeamId() {
        return this.teamId;
    }

    @JsonProperty(value="team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public TeamInfoResponse teamParent(TeamParentResponse teamParent) {
        this.teamParent = teamParent;
        return this;
    }

    @Nullable
    @JsonProperty(value="team_parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TeamParentResponse getTeamParent() {
        return this.teamParent;
    }

    @JsonProperty(value="team_parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamParent(TeamParentResponse teamParent) {
        this.teamParent = teamParent;
    }

    public TeamInfoResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TeamInfoResponse numMembers(Integer numMembers) {
        this.numMembers = numMembers;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumMembers() {
        return this.numMembers;
    }

    @JsonProperty(value="num_members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumMembers(Integer numMembers) {
        this.numMembers = numMembers;
    }

    public TeamInfoResponse numSubTeams(Integer numSubTeams) {
        this.numSubTeams = numSubTeams;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_sub_teams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumSubTeams() {
        return this.numSubTeams;
    }

    @JsonProperty(value="num_sub_teams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumSubTeams(Integer numSubTeams) {
        this.numSubTeams = numSubTeams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamInfoResponse teamInfoResponse = (TeamInfoResponse)o;
        return Objects.equals(this.teamId, teamInfoResponse.teamId) && Objects.equals(this.teamParent, teamInfoResponse.teamParent) && Objects.equals(this.name, teamInfoResponse.name) && Objects.equals(this.numMembers, teamInfoResponse.numMembers) && Objects.equals(this.numSubTeams, teamInfoResponse.numSubTeams);
    }

    public int hashCode() {
        return Objects.hash(this.teamId, this.teamParent, this.name, this.numMembers, this.numSubTeams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamInfoResponse {\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("    teamParent: ").append(this.toIndentedString(this.teamParent)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numMembers: ").append(this.toIndentedString(this.numMembers)).append("\n");
        sb.append("    numSubTeams: ").append(this.toIndentedString(this.numSubTeams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.teamId != null) {
                if (this.isFileTypeOrListOfFiles(this.teamId)) {
                    fileTypeFound = true;
                }
                if (this.teamId.getClass().equals(File.class) || this.teamId.getClass().equals(Integer.class) || this.teamId.getClass().equals(String.class) || this.teamId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEAM_ID, this.teamId);
                } else if (this.isListOfFile(this.teamId)) {
                    for (i = 0; i < this.getListSize(this.teamId); ++i) {
                        map.put("team_id[" + i + "]", this.getFromList(this.teamId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEAM_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.teamId));
                }
            }
            if (this.teamParent != null) {
                if (this.isFileTypeOrListOfFiles(this.teamParent)) {
                    fileTypeFound = true;
                }
                if (this.teamParent.getClass().equals(File.class) || this.teamParent.getClass().equals(Integer.class) || this.teamParent.getClass().equals(String.class) || this.teamParent.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEAM_PARENT, this.teamParent);
                } else if (this.isListOfFile(this.teamParent)) {
                    for (i = 0; i < this.getListSize(this.teamParent); ++i) {
                        map.put("team_parent[" + i + "]", this.getFromList(this.teamParent, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEAM_PARENT, JSON.getDefault().getMapper().writeValueAsString((Object)this.teamParent));
                }
            }
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
            if (this.numMembers != null) {
                if (this.isFileTypeOrListOfFiles(this.numMembers)) {
                    fileTypeFound = true;
                }
                if (this.numMembers.getClass().equals(File.class) || this.numMembers.getClass().equals(Integer.class) || this.numMembers.getClass().equals(String.class) || this.numMembers.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NUM_MEMBERS, this.numMembers);
                } else if (this.isListOfFile(this.numMembers)) {
                    for (i = 0; i < this.getListSize(this.numMembers); ++i) {
                        map.put("num_members[" + i + "]", this.getFromList(this.numMembers, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NUM_MEMBERS, JSON.getDefault().getMapper().writeValueAsString((Object)this.numMembers));
                }
            }
            if (this.numSubTeams != null) {
                if (this.isFileTypeOrListOfFiles(this.numSubTeams)) {
                    fileTypeFound = true;
                }
                if (this.numSubTeams.getClass().equals(File.class) || this.numSubTeams.getClass().equals(Integer.class) || this.numSubTeams.getClass().equals(String.class) || this.numSubTeams.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NUM_SUB_TEAMS, this.numSubTeams);
                } else if (this.isListOfFile(this.numSubTeams)) {
                    for (i = 0; i < this.getListSize(this.numSubTeams); ++i) {
                        map.put("num_sub_teams[" + i + "]", this.getFromList(this.numSubTeams, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NUM_SUB_TEAMS, JSON.getDefault().getMapper().writeValueAsString((Object)this.numSubTeams));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

