/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"role", "name", "email_address"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubUnclaimedDraftTemplateSigner {
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;

    public static SubUnclaimedDraftTemplateSigner init(String jsonData) throws Exception {
        return (SubUnclaimedDraftTemplateSigner)new ObjectMapper().readValue(jsonData, SubUnclaimedDraftTemplateSigner.class);
    }

    public static SubUnclaimedDraftTemplateSigner init(HashMap data) throws Exception {
        return (SubUnclaimedDraftTemplateSigner)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubUnclaimedDraftTemplateSigner.class);
    }

    public SubUnclaimedDraftTemplateSigner role(String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRole(String role) {
        this.role = role;
    }

    public SubUnclaimedDraftTemplateSigner name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SubUnclaimedDraftTemplateSigner emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubUnclaimedDraftTemplateSigner subUnclaimedDraftTemplateSigner = (SubUnclaimedDraftTemplateSigner)o;
        return Objects.equals(this.role, subUnclaimedDraftTemplateSigner.role) && Objects.equals(this.name, subUnclaimedDraftTemplateSigner.name) && Objects.equals(this.emailAddress, subUnclaimedDraftTemplateSigner.emailAddress);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.name, this.emailAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubUnclaimedDraftTemplateSigner {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.role != null) {
                if (this.isFileTypeOrListOfFiles(this.role)) {
                    fileTypeFound = true;
                }
                if (this.role.getClass().equals(File.class) || this.role.getClass().equals(Integer.class) || this.role.getClass().equals(String.class) || this.role.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ROLE, this.role);
                } else if (this.isListOfFile(this.role)) {
                    for (i = 0; i < this.getListSize(this.role); ++i) {
                        map.put("role[" + i + "]", this.getFromList(this.role, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ROLE, JSON.getDefault().getMapper().writeValueAsString((Object)this.role));
                }
            }
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
            if (this.emailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.emailAddress)) {
                    fileTypeFound = true;
                }
                if (this.emailAddress.getClass().equals(File.class) || this.emailAddress.getClass().equals(Integer.class) || this.emailAddress.getClass().equals(String.class) || this.emailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, this.emailAddress);
                } else if (this.isListOfFile(this.emailAddress)) {
                    for (i = 0; i < this.getListSize(this.emailAddress); ++i) {
                        map.put("email_address[" + i + "]", this.getFromList(this.emailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.emailAddress));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

