/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"default_type", "draw", "phone", "type", "upload"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubSigningOptions {
    public static final String JSON_PROPERTY_DEFAULT_TYPE = "default_type";
    private DefaultTypeEnum defaultType;
    public static final String JSON_PROPERTY_DRAW = "draw";
    private Boolean draw = false;
    public static final String JSON_PROPERTY_PHONE = "phone";
    private Boolean phone = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Boolean type = false;
    public static final String JSON_PROPERTY_UPLOAD = "upload";
    private Boolean upload = false;

    public static SubSigningOptions init(String jsonData) throws Exception {
        return (SubSigningOptions)new ObjectMapper().readValue(jsonData, SubSigningOptions.class);
    }

    public static SubSigningOptions init(HashMap data) throws Exception {
        return (SubSigningOptions)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubSigningOptions.class);
    }

    public SubSigningOptions defaultType(DefaultTypeEnum defaultType) {
        this.defaultType = defaultType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="default_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DefaultTypeEnum getDefaultType() {
        return this.defaultType;
    }

    @JsonProperty(value="default_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDefaultType(DefaultTypeEnum defaultType) {
        this.defaultType = defaultType;
    }

    public SubSigningOptions draw(Boolean draw) {
        this.draw = draw;
        return this;
    }

    @Nullable
    @JsonProperty(value="draw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDraw() {
        return this.draw;
    }

    @JsonProperty(value="draw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDraw(Boolean draw) {
        this.draw = draw;
    }

    public SubSigningOptions phone(Boolean phone) {
        this.phone = phone;
        return this;
    }

    @Nullable
    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhone(Boolean phone) {
        this.phone = phone;
    }

    public SubSigningOptions type(Boolean type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(Boolean type) {
        this.type = type;
    }

    public SubSigningOptions upload(Boolean upload) {
        this.upload = upload;
        return this;
    }

    @Nullable
    @JsonProperty(value="upload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUpload() {
        return this.upload;
    }

    @JsonProperty(value="upload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpload(Boolean upload) {
        this.upload = upload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubSigningOptions subSigningOptions = (SubSigningOptions)o;
        return Objects.equals((Object)this.defaultType, (Object)subSigningOptions.defaultType) && Objects.equals(this.draw, subSigningOptions.draw) && Objects.equals(this.phone, subSigningOptions.phone) && Objects.equals(this.type, subSigningOptions.type) && Objects.equals(this.upload, subSigningOptions.upload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultType, this.draw, this.phone, this.type, this.upload});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubSigningOptions {\n");
        sb.append("    defaultType: ").append(this.toIndentedString((Object)this.defaultType)).append("\n");
        sb.append("    draw: ").append(this.toIndentedString(this.draw)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    upload: ").append(this.toIndentedString(this.upload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.defaultType != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.defaultType)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.defaultType)).getClass().equals(File.class) || ((Object)((Object)this.defaultType)).getClass().equals(Integer.class) || ((Object)((Object)this.defaultType)).getClass().equals(String.class) || ((Object)((Object)this.defaultType)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_DEFAULT_TYPE, (Object)this.defaultType);
                } else if (this.isListOfFile((Object)this.defaultType)) {
                    for (i = 0; i < this.getListSize((Object)this.defaultType); ++i) {
                        map.put("default_type[" + i + "]", this.getFromList((Object)this.defaultType, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_DEFAULT_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.defaultType));
                }
            }
            if (this.draw != null) {
                if (this.isFileTypeOrListOfFiles(this.draw)) {
                    fileTypeFound = true;
                }
                if (this.draw.getClass().equals(File.class) || this.draw.getClass().equals(Integer.class) || this.draw.getClass().equals(String.class) || this.draw.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_DRAW, this.draw);
                } else if (this.isListOfFile(this.draw)) {
                    for (i = 0; i < this.getListSize(this.draw); ++i) {
                        map.put("draw[" + i + "]", this.getFromList(this.draw, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_DRAW, JSON.getDefault().getMapper().writeValueAsString((Object)this.draw));
                }
            }
            if (this.phone != null) {
                if (this.isFileTypeOrListOfFiles(this.phone)) {
                    fileTypeFound = true;
                }
                if (this.phone.getClass().equals(File.class) || this.phone.getClass().equals(Integer.class) || this.phone.getClass().equals(String.class) || this.phone.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_PHONE, this.phone);
                } else if (this.isListOfFile(this.phone)) {
                    for (i = 0; i < this.getListSize(this.phone); ++i) {
                        map.put("phone[" + i + "]", this.getFromList(this.phone, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_PHONE, JSON.getDefault().getMapper().writeValueAsString((Object)this.phone));
                }
            }
            if (this.type != null) {
                if (this.isFileTypeOrListOfFiles(this.type)) {
                    fileTypeFound = true;
                }
                if (this.type.getClass().equals(File.class) || this.type.getClass().equals(Integer.class) || this.type.getClass().equals(String.class) || this.type.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TYPE, this.type);
                } else if (this.isListOfFile(this.type)) {
                    for (i = 0; i < this.getListSize(this.type); ++i) {
                        map.put("type[" + i + "]", this.getFromList(this.type, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.type));
                }
            }
            if (this.upload != null) {
                if (this.isFileTypeOrListOfFiles(this.upload)) {
                    fileTypeFound = true;
                }
                if (this.upload.getClass().equals(File.class) || this.upload.getClass().equals(Integer.class) || this.upload.getClass().equals(String.class) || this.upload.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_UPLOAD, this.upload);
                } else if (this.isListOfFile(this.upload)) {
                    for (i = 0; i < this.getListSize(this.upload); ++i) {
                        map.put("upload[" + i + "]", this.getFromList(this.upload, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_UPLOAD, JSON.getDefault().getMapper().writeValueAsString((Object)this.upload));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DefaultTypeEnum {
        DRAW("draw"),
        PHONE("phone"),
        TYPE("type"),
        UPLOAD("upload");

        private String value;

        private DefaultTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DefaultTypeEnum fromValue(String value) {
            for (DefaultTypeEnum b : DefaultTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

