/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.SubSignatureRequestSigner;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"group", "signers", "order"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubSignatureRequestGroupedSigners {
    public static final String JSON_PROPERTY_GROUP = "group";
    private String group;
    public static final String JSON_PROPERTY_SIGNERS = "signers";
    private List<SubSignatureRequestSigner> signers = new ArrayList<SubSignatureRequestSigner>();
    public static final String JSON_PROPERTY_ORDER = "order";
    private Integer order;

    public static SubSignatureRequestGroupedSigners init(String jsonData) throws Exception {
        return (SubSignatureRequestGroupedSigners)new ObjectMapper().readValue(jsonData, SubSignatureRequestGroupedSigners.class);
    }

    public static SubSignatureRequestGroupedSigners init(HashMap data) throws Exception {
        return (SubSignatureRequestGroupedSigners)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubSignatureRequestGroupedSigners.class);
    }

    public SubSignatureRequestGroupedSigners group(String group) {
        this.group = group;
        return this;
    }

    @Nonnull
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGroup(String group) {
        this.group = group;
    }

    public SubSignatureRequestGroupedSigners signers(List<SubSignatureRequestSigner> signers) {
        this.signers = signers;
        return this;
    }

    public SubSignatureRequestGroupedSigners addSignersItem(SubSignatureRequestSigner signersItem) {
        if (this.signers == null) {
            this.signers = new ArrayList<SubSignatureRequestSigner>();
        }
        this.signers.add(signersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="signers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SubSignatureRequestSigner> getSigners() {
        return this.signers;
    }

    @JsonProperty(value="signers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSigners(List<SubSignatureRequestSigner> signers) {
        this.signers = signers;
    }

    public SubSignatureRequestGroupedSigners order(Integer order) {
        this.order = order;
        return this;
    }

    @Nullable
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(Integer order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubSignatureRequestGroupedSigners subSignatureRequestGroupedSigners = (SubSignatureRequestGroupedSigners)o;
        return Objects.equals(this.group, subSignatureRequestGroupedSigners.group) && Objects.equals(this.signers, subSignatureRequestGroupedSigners.signers) && Objects.equals(this.order, subSignatureRequestGroupedSigners.order);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.signers, this.order);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubSignatureRequestGroupedSigners {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    signers: ").append(this.toIndentedString(this.signers)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.group != null) {
                if (this.isFileTypeOrListOfFiles(this.group)) {
                    fileTypeFound = true;
                }
                if (this.group.getClass().equals(File.class) || this.group.getClass().equals(Integer.class) || this.group.getClass().equals(String.class) || this.group.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_GROUP, this.group);
                } else if (this.isListOfFile(this.group)) {
                    for (i = 0; i < this.getListSize(this.group); ++i) {
                        map.put("group[" + i + "]", this.getFromList(this.group, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_GROUP, JSON.getDefault().getMapper().writeValueAsString((Object)this.group));
                }
            }
            if (this.signers != null) {
                if (this.isFileTypeOrListOfFiles(this.signers)) {
                    fileTypeFound = true;
                }
                if (this.signers.getClass().equals(File.class) || this.signers.getClass().equals(Integer.class) || this.signers.getClass().equals(String.class) || this.signers.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNERS, this.signers);
                } else if (this.isListOfFile(this.signers)) {
                    for (i = 0; i < this.getListSize(this.signers); ++i) {
                        map.put("signers[" + i + "]", this.getFromList(this.signers, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNERS, JSON.getDefault().getMapper().writeValueAsString(this.signers));
                }
            }
            if (this.order != null) {
                if (this.isFileTypeOrListOfFiles(this.order)) {
                    fileTypeFound = true;
                }
                if (this.order.getClass().equals(File.class) || this.order.getClass().equals(Integer.class) || this.order.getClass().equals(String.class) || this.order.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ORDER, this.order);
                } else if (this.isListOfFile(this.order)) {
                    for (i = 0; i < this.getListSize(this.order); ++i) {
                        map.put("order[" + i + "]", this.getFromList(this.order, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ORDER, JSON.getDefault().getMapper().writeValueAsString((Object)this.order));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

