/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"allow_edit_signers", "allow_edit_documents"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubEditorOptions {
    public static final String JSON_PROPERTY_ALLOW_EDIT_SIGNERS = "allow_edit_signers";
    private Boolean allowEditSigners = false;
    public static final String JSON_PROPERTY_ALLOW_EDIT_DOCUMENTS = "allow_edit_documents";
    private Boolean allowEditDocuments = false;

    public static SubEditorOptions init(String jsonData) throws Exception {
        return (SubEditorOptions)new ObjectMapper().readValue(jsonData, SubEditorOptions.class);
    }

    public static SubEditorOptions init(HashMap data) throws Exception {
        return (SubEditorOptions)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubEditorOptions.class);
    }

    public SubEditorOptions allowEditSigners(Boolean allowEditSigners) {
        this.allowEditSigners = allowEditSigners;
        return this;
    }

    @Nullable
    @JsonProperty(value="allow_edit_signers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowEditSigners() {
        return this.allowEditSigners;
    }

    @JsonProperty(value="allow_edit_signers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowEditSigners(Boolean allowEditSigners) {
        this.allowEditSigners = allowEditSigners;
    }

    public SubEditorOptions allowEditDocuments(Boolean allowEditDocuments) {
        this.allowEditDocuments = allowEditDocuments;
        return this;
    }

    @Nullable
    @JsonProperty(value="allow_edit_documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowEditDocuments() {
        return this.allowEditDocuments;
    }

    @JsonProperty(value="allow_edit_documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowEditDocuments(Boolean allowEditDocuments) {
        this.allowEditDocuments = allowEditDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubEditorOptions subEditorOptions = (SubEditorOptions)o;
        return Objects.equals(this.allowEditSigners, subEditorOptions.allowEditSigners) && Objects.equals(this.allowEditDocuments, subEditorOptions.allowEditDocuments);
    }

    public int hashCode() {
        return Objects.hash(this.allowEditSigners, this.allowEditDocuments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubEditorOptions {\n");
        sb.append("    allowEditSigners: ").append(this.toIndentedString(this.allowEditSigners)).append("\n");
        sb.append("    allowEditDocuments: ").append(this.toIndentedString(this.allowEditDocuments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.allowEditSigners != null) {
                if (this.isFileTypeOrListOfFiles(this.allowEditSigners)) {
                    fileTypeFound = true;
                }
                if (this.allowEditSigners.getClass().equals(File.class) || this.allowEditSigners.getClass().equals(Integer.class) || this.allowEditSigners.getClass().equals(String.class) || this.allowEditSigners.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ALLOW_EDIT_SIGNERS, this.allowEditSigners);
                } else if (this.isListOfFile(this.allowEditSigners)) {
                    for (i = 0; i < this.getListSize(this.allowEditSigners); ++i) {
                        map.put("allow_edit_signers[" + i + "]", this.getFromList(this.allowEditSigners, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ALLOW_EDIT_SIGNERS, JSON.getDefault().getMapper().writeValueAsString((Object)this.allowEditSigners));
                }
            }
            if (this.allowEditDocuments != null) {
                if (this.isFileTypeOrListOfFiles(this.allowEditDocuments)) {
                    fileTypeFound = true;
                }
                if (this.allowEditDocuments.getClass().equals(File.class) || this.allowEditDocuments.getClass().equals(Integer.class) || this.allowEditDocuments.getClass().equals(String.class) || this.allowEditDocuments.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ALLOW_EDIT_DOCUMENTS, this.allowEditDocuments);
                } else if (this.isListOfFile(this.allowEditDocuments)) {
                    for (i = 0; i < this.getListSize(this.allowEditDocuments); ++i) {
                        map.put("allow_edit_documents[" + i + "]", this.getFromList(this.allowEditDocuments, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ALLOW_EDIT_DOCUMENTS, JSON.getDefault().getMapper().writeValueAsString((Object)this.allowEditDocuments));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

