/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.ListInfoResponse;
import com.dropbox.sign.model.SignatureRequestResponse;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"signature_requests", "list_info", "warnings"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SignatureRequestListResponse {
    public static final String JSON_PROPERTY_SIGNATURE_REQUESTS = "signature_requests";
    private List<SignatureRequestResponse> signatureRequests = new ArrayList<SignatureRequestResponse>();
    public static final String JSON_PROPERTY_LIST_INFO = "list_info";
    private ListInfoResponse listInfo;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<WarningResponse> warnings = null;

    public static SignatureRequestListResponse init(String jsonData) throws Exception {
        return (SignatureRequestListResponse)new ObjectMapper().readValue(jsonData, SignatureRequestListResponse.class);
    }

    public static SignatureRequestListResponse init(HashMap data) throws Exception {
        return (SignatureRequestListResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SignatureRequestListResponse.class);
    }

    public SignatureRequestListResponse signatureRequests(List<SignatureRequestResponse> signatureRequests) {
        this.signatureRequests = signatureRequests;
        return this;
    }

    public SignatureRequestListResponse addSignatureRequestsItem(SignatureRequestResponse signatureRequestsItem) {
        if (this.signatureRequests == null) {
            this.signatureRequests = new ArrayList<SignatureRequestResponse>();
        }
        this.signatureRequests.add(signatureRequestsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="signature_requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SignatureRequestResponse> getSignatureRequests() {
        return this.signatureRequests;
    }

    @JsonProperty(value="signature_requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSignatureRequests(List<SignatureRequestResponse> signatureRequests) {
        this.signatureRequests = signatureRequests;
    }

    public SignatureRequestListResponse listInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
        return this;
    }

    @Nonnull
    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListInfoResponse getListInfo() {
        return this.listInfo;
    }

    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
    }

    public SignatureRequestListResponse warnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
        return this;
    }

    public SignatureRequestListResponse addWarningsItem(WarningResponse warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<WarningResponse>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WarningResponse> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureRequestListResponse signatureRequestListResponse = (SignatureRequestListResponse)o;
        return Objects.equals(this.signatureRequests, signatureRequestListResponse.signatureRequests) && Objects.equals(this.listInfo, signatureRequestListResponse.listInfo) && Objects.equals(this.warnings, signatureRequestListResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.signatureRequests, this.listInfo, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignatureRequestListResponse {\n");
        sb.append("    signatureRequests: ").append(this.toIndentedString(this.signatureRequests)).append("\n");
        sb.append("    listInfo: ").append(this.toIndentedString(this.listInfo)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.signatureRequests != null) {
                if (this.isFileTypeOrListOfFiles(this.signatureRequests)) {
                    fileTypeFound = true;
                }
                if (this.signatureRequests.getClass().equals(File.class) || this.signatureRequests.getClass().equals(Integer.class) || this.signatureRequests.getClass().equals(String.class) || this.signatureRequests.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNATURE_REQUESTS, this.signatureRequests);
                } else if (this.isListOfFile(this.signatureRequests)) {
                    for (i = 0; i < this.getListSize(this.signatureRequests); ++i) {
                        map.put("signature_requests[" + i + "]", this.getFromList(this.signatureRequests, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNATURE_REQUESTS, JSON.getDefault().getMapper().writeValueAsString(this.signatureRequests));
                }
            }
            if (this.listInfo != null) {
                if (this.isFileTypeOrListOfFiles(this.listInfo)) {
                    fileTypeFound = true;
                }
                if (this.listInfo.getClass().equals(File.class) || this.listInfo.getClass().equals(Integer.class) || this.listInfo.getClass().equals(String.class) || this.listInfo.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LIST_INFO, this.listInfo);
                } else if (this.isListOfFile(this.listInfo)) {
                    for (i = 0; i < this.getListSize(this.listInfo); ++i) {
                        map.put("list_info[" + i + "]", this.getFromList(this.listInfo, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LIST_INFO, JSON.getDefault().getMapper().writeValueAsString((Object)this.listInfo));
                }
            }
            if (this.warnings != null) {
                if (this.isFileTypeOrListOfFiles(this.warnings)) {
                    fileTypeFound = true;
                }
                if (this.warnings.getClass().equals(File.class) || this.warnings.getClass().equals(Integer.class) || this.warnings.getClass().equals(String.class) || this.warnings.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WARNINGS, this.warnings);
                } else if (this.isListOfFile(this.warnings)) {
                    for (i = 0; i < this.getListSize(this.warnings); ++i) {
                        map.put("warnings[" + i + "]", this.getFromList(this.warnings, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WARNINGS, JSON.getDefault().getMapper().writeValueAsString(this.warnings));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

