/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.ReportResponse;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"report", "warnings"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class ReportCreateResponse {
    public static final String JSON_PROPERTY_REPORT = "report";
    private ReportResponse report;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<WarningResponse> warnings = null;

    public static ReportCreateResponse init(String jsonData) throws Exception {
        return (ReportCreateResponse)new ObjectMapper().readValue(jsonData, ReportCreateResponse.class);
    }

    public static ReportCreateResponse init(HashMap data) throws Exception {
        return (ReportCreateResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), ReportCreateResponse.class);
    }

    public ReportCreateResponse report(ReportResponse report) {
        this.report = report;
        return this;
    }

    @Nonnull
    @JsonProperty(value="report")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReportResponse getReport() {
        return this.report;
    }

    @JsonProperty(value="report")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReport(ReportResponse report) {
        this.report = report;
    }

    public ReportCreateResponse warnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
        return this;
    }

    public ReportCreateResponse addWarningsItem(WarningResponse warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<WarningResponse>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WarningResponse> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportCreateResponse reportCreateResponse = (ReportCreateResponse)o;
        return Objects.equals(this.report, reportCreateResponse.report) && Objects.equals(this.warnings, reportCreateResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.report, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportCreateResponse {\n");
        sb.append("    report: ").append(this.toIndentedString(this.report)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.report != null) {
                if (this.isFileTypeOrListOfFiles(this.report)) {
                    fileTypeFound = true;
                }
                if (this.report.getClass().equals(File.class) || this.report.getClass().equals(Integer.class) || this.report.getClass().equals(String.class) || this.report.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REPORT, this.report);
                } else if (this.isListOfFile(this.report)) {
                    for (i = 0; i < this.getListSize(this.report); ++i) {
                        map.put("report[" + i + "]", this.getFromList(this.report, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REPORT, JSON.getDefault().getMapper().writeValueAsString((Object)this.report));
                }
            }
            if (this.warnings != null) {
                if (this.isFileTypeOrListOfFiles(this.warnings)) {
                    fileTypeFound = true;
                }
                if (this.warnings.getClass().equals(File.class) || this.warnings.getClass().equals(Integer.class) || this.warnings.getClass().equals(String.class) || this.warnings.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WARNINGS, this.warnings);
                } else if (this.isListOfFile(this.warnings)) {
                    for (i = 0; i < this.getListSize(this.warnings); ++i) {
                        map.put("warnings[" + i + "]", this.getFromList(this.warnings, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WARNINGS, JSON.getDefault().getMapper().writeValueAsString(this.warnings));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

